/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core;

import com.perforce.p4java.Log;
import com.perforce.p4java.core.IReviewSubscription;
import com.perforce.p4java.core.IUser;
import com.perforce.p4java.core.ViewMap;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.core.ReviewSubscription;
import com.perforce.p4java.impl.generic.core.UserSummary;
import com.perforce.p4java.server.IServer;
import java.util.Date;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class User
extends UserSummary
implements IUser {
    private String password = null;
    private String jobView = null;
    private ViewMap<IReviewSubscription> reviewSubscriptions = null;

    public User() {
    }

    public User(String loginName, String email, String fullName, Date access, Date update, String password, String jobView, ViewMap<IReviewSubscription> reviewSubscriptions) {
        super(loginName, email, fullName, access, update);
        this.password = password;
        this.jobView = jobView;
        this.reviewSubscriptions = reviewSubscriptions;
    }

    public User(Map<String, Object> map, IServer server) {
        super(map, false);
        this.server = server;
        if (map != null) {
            String JOBVIEW_KEY = "JobView";
            String PASSWORD_KEY = "Password";
            String REVIEW_KEY_PFX = "Reviews";
            try {
                this.jobView = (String)map.get("JobView");
                this.password = (String)map.get("Password");
                int i = 0;
                while (map.containsKey("Reviews" + i)) {
                    if (this.reviewSubscriptions == null) {
                        this.reviewSubscriptions = new ViewMap();
                    }
                    this.reviewSubscriptions.addEntry(new ReviewSubscription(i, (String)map.get("Reviews" + i)));
                    ++i;
                }
            }
            catch (Throwable thr) {
                Log.error("Unexpected exception in User constructor: " + thr.getLocalizedMessage());
                Log.exception(thr);
            }
        }
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getJobView() {
        return this.jobView;
    }

    @Override
    public void setJobView(String jobView) {
        this.jobView = jobView;
    }

    @Override
    public ViewMap<IReviewSubscription> getReviewSubscriptions() {
        return this.reviewSubscriptions;
    }

    @Override
    public void setReviewSubscriptions(ViewMap<IReviewSubscription> reviewSubscriptions) {
        this.reviewSubscriptions = reviewSubscriptions;
    }

    @Override
    public void refresh() throws ConnectionException, RequestException, AccessException {
        IUser refreshedUser;
        IServer refreshServer = this.server;
        String refreshName = this.getLoginName();
        if (refreshServer != null && refreshName != null && (refreshedUser = refreshServer.getUser(refreshName)) != null) {
            this.setLoginName(refreshedUser.getLoginName());
            this.setEmail(refreshedUser.getEmail());
            this.setAccess(refreshedUser.getAccess());
            this.setUpdate(refreshedUser.getUpdate());
            this.setFullName(refreshedUser.getFullName());
            this.setJobView(refreshedUser.getJobView());
            this.setPassword(refreshedUser.getPassword());
            this.setReviewSubscriptions(refreshedUser.getReviewSubscriptions());
        }
    }

    @Override
    public void update() throws ConnectionException, RequestException, AccessException {
        this.server.updateUser(this, false);
    }

    @Override
    public void update(boolean force) throws ConnectionException, RequestException, AccessException {
        this.server.updateUser(this, true);
    }
}

