/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.stream;

import com.jcraft.jzlib.ZInputStream;
import com.perforce.p4java.exception.P4JError;
import com.perforce.p4java.exception.P4JNullPointerError;
import com.perforce.p4java.exception.P4JUnimplementedError;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;

public class P4JGZIPInputStream
extends InflaterInputStream {
    private ZInputStream jzInStream = null;

    public P4JGZIPInputStream(InputStream in) throws IOException {
        super(in);
        this.jzInStream = new ZInputStream(in, true);
    }

    public int read(byte[] bytes) throws IOException {
        if (bytes == null) {
            throw new P4JNullPointerError("null byte array passed to P4JGZIPInputStream.read()");
        }
        return this.read(bytes, 0, bytes.length);
    }

    public int read(byte[] bytes, int offset, int len) throws IOException {
        if (bytes == null) {
            throw new P4JNullPointerError("null byte array passed to P4JGZIPInputStream.read()");
        }
        if (len <= 0 || offset < 0 || offset >= bytes.length || len > bytes.length - offset) {
            throw new P4JError("bad length or offset in P4JGZIPInputStream.read()");
        }
        return this.jzInStream.read(bytes, offset, len);
    }

    public int read() throws IOException {
        throw new P4JUnimplementedError("single-byte P4JGZIPInputStream.read()");
    }

    public void close() throws IOException {
        this.jzInStream.close();
    }
}

