/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.func.proto;

import com.perforce.p4java.P4JTracer;
import com.perforce.p4java.exception.P4JConnectionException;
import com.perforce.p4java.exception.P4JError;
import com.perforce.p4java.exception.P4JNullPointerError;
import com.perforce.p4java.exception.P4JProtocolError;
import com.perforce.p4java.impl.mapbased.rpc.P4JRpcCommandEnv;
import com.perforce.p4java.impl.mapbased.rpc.connection.P4JRpcConnection;
import com.perforce.p4java.impl.mapbased.rpc.func.P4JRpcFunctionSpec;
import com.perforce.p4java.impl.mapbased.rpc.packet.P4JRpcPacket;
import com.perforce.p4java.impl.mapbased.rpc.packet.P4JRpcPacketDispatcher;
import com.perforce.p4java.server.callback.P4JProgressCallback;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P4JRpcProtocolFunctionDispatcher {
    public static final String TRACE_PREFIX = "P4JRpcProtocolFunctionDispatcher";
    private P4JRpcPacketDispatcher mainDispatcher = null;
    private Properties props = null;

    public P4JRpcProtocolFunctionDispatcher(P4JRpcPacketDispatcher mainDispatcher, Properties props) {
        if (mainDispatcher == null) {
            throw new P4JNullPointerError("Null main dispatcher passed to P4JRpcProtocolFunctionDispatcher constructor");
        }
        this.props = props;
        this.mainDispatcher = mainDispatcher;
    }

    public P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult dispatch(P4JRpcPacketDispatcher.P4JRpcPacketDispatcherMode dispatchMode, P4JRpcFunctionSpec funcSpec, P4JRpcCommandEnv cmdEnv, Map<String, Object> resultsMap) throws P4JConnectionException {
        if (funcSpec == null) {
            throw new P4JNullPointerError("Null function spec passed to P4JRpcProtocolFunctionDispatcher.dispatch()");
        }
        if (cmdEnv == null) {
            throw new P4JNullPointerError("Null command environment passed to P4JRpcProtocolFunctionDispatcher.dispatch()");
        }
        int cmdCallBackKey = cmdEnv.getCmdCallBackKey();
        P4JRpcConnection rpcConnection = cmdEnv.getRpcConnection();
        P4JTracer.fine("P4JRpcProtocolFunctionDispatcher.dispatch: function: " + funcSpec.toString().toLowerCase());
        P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult result = P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.NONE;
        switch (funcSpec) {
            case PROTOCOL_PROTOCOL: {
                P4JTracer.superfine("P4JRpcProtocolFunctionDispatcher.dispatch: processing protocol command");
                for (String key : resultsMap.keySet()) {
                    cmdEnv.getServerProtocolSpecsMap().put(key, resultsMap.get(key));
                }
                result = P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.CONTINUE;
                break;
            }
            case PROTOCOL_FLUSH1: {
                P4JTracer.superfine("P4JRpcProtocolFunctionDispatcher.dispatch: processing flush1 command");
                P4JRpcPacket flush2Packet = rpcConnection.getFlowController().respondToFlush1(resultsMap);
                rpcConnection.putRpcPacket(flush2Packet);
                result = P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.CONTINUE;
                break;
            }
            case PROTOCOL_RELEASE: {
                P4JTracer.superfine("P4JRpcProtocolFunctionDispatcher.dispatch: processing release command");
                P4JProgressCallback progressCallback = cmdEnv.getProgressCallback();
                if (progressCallback != null) {
                    progressCallback.stop(cmdCallBackKey);
                }
                result = P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.STOP_NORMAL;
                break;
            }
            case PROTOCOL_COMPRESS1: {
                rpcConnection.useConnectionCompression();
                result = P4JRpcPacketDispatcher.P4JRpcPacketDispatcherResult.CONTINUE;
                break;
            }
            case PROTOCOL_COMPRESS2: {
                throw new P4JProtocolError("Unexpected compress2 message in protocol dispatcher");
            }
            default: {
                throw new P4JError("Unimplemented function spec in P4JRpcProtocolFunctionDispatcher.dispatch(): '" + funcSpec.toString() + "'");
            }
        }
        return result;
    }

    public void sendRelease2(P4JRpcConnection rpcConnection) throws P4JConnectionException {
        if (rpcConnection == null) {
            throw new P4JNullPointerError("Null rpc connection passed to P4JRpcProtocolFunctionDispatcher.sendRelease2()");
        }
        P4JTracer.coarse("P4JRpcProtocolFunctionDispatcher sending release2");
        HashMap<String, Object> flushMap = new HashMap<String, Object>(2);
        P4JRpcPacket flush2Packet = P4JRpcPacket.constructRpcPacket(P4JRpcFunctionSpec.PROTOCOL_RELEASE2, flushMap, null);
        rpcConnection.putRpcPacket(flush2Packet);
    }
}

