/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core;

import com.perforce.p4java.core.P4JJob;
import com.perforce.p4java.core.P4JJobSpec;
import com.perforce.p4java.exception.P4JAccessException;
import com.perforce.p4java.exception.P4JConnectionException;
import com.perforce.p4java.exception.P4JNullPointerError;
import com.perforce.p4java.exception.P4JRequestException;
import com.perforce.p4java.impl.generic.core.P4JServerResourceImpl;
import com.perforce.p4java.server.P4JServer;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P4JJobImpl
extends P4JServerResourceImpl
implements P4JJob {
    public int SHORT_DESCR_LENGTH = 128;
    private String id = null;
    private Map<String, Object> rawFields = null;
    private String description = null;
    private P4JJobSpec jobSpec = null;

    public P4JJobImpl(P4JServer server, Map<String, Object> map) {
        this(server, map, false);
    }

    public P4JJobImpl(P4JServer server, Map<String, Object> map, boolean longDescriptions) {
        super(true, true, true, true);
        this.server = server;
        this.rawFields = map;
        if (map != null) {
            this.id = this.getJobIdString(map);
            this.description = this.getDescriptionString(map, longDescriptions);
        }
    }

    private void updateFlags() {
        this.complete = this.description != null && this.rawFields != null;
    }

    @Override
    public void complete() throws P4JConnectionException, P4JRequestException, P4JAccessException {
        this.refresh();
    }

    @Override
    public void refresh() throws P4JConnectionException, P4JRequestException, P4JAccessException {
        P4JJob refreshedJob;
        P4JServer refreshServer = this.server;
        String refreshId = this.id;
        if (refreshServer != null && refreshId != null && (refreshedJob = refreshServer.getJob(refreshId)) != null) {
            this.description = refreshedJob.getDescription();
            this.rawFields = refreshedJob.getRawFields();
        }
        this.updateFlags();
    }

    @Override
    public String updateOnServer() throws P4JConnectionException, P4JRequestException, P4JAccessException {
        if (this.server == null) {
            throw new P4JNullPointerError("Null server field in P4JJobImpl.updateOnServer");
        }
        return this.server.updateJob(this);
    }

    @Override
    public void update() throws P4JConnectionException, P4JRequestException, P4JAccessException {
        this.server.updateJob(this);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public P4JJobSpec getJobSpec() {
        return this.jobSpec;
    }

    @Override
    public Map<String, Object> getRawFields() {
        return this.rawFields;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setRawFields(Map<String, Object> rawFields) {
        this.rawFields = rawFields;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setJobSpec(P4JJobSpec jobSpec) {
        this.jobSpec = jobSpec;
    }

    protected String getJobIdString(Map<String, Object> map) {
        String candidate = (String)map.get("Job");
        if (candidate == null && (candidate = (String)map.get("job")) == null) {
            candidate = (String)map.get("JobId");
        }
        return candidate;
    }

    protected String getDescriptionString(Map<String, Object> map, boolean longDescriptions) {
        String candidate = (String)map.get("Description");
        if (candidate == null && (candidate = (String)map.get("description")) == null) {
            candidate = (String)map.get("Desc");
        }
        if (candidate != null && !longDescriptions && candidate.length() > this.SHORT_DESCR_LENGTH) {
            return candidate.substring(0, this.SHORT_DESCR_LENGTH - 1);
        }
        return candidate;
    }
}

