/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.mipush.sdk;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.ServiceInfo;
import android.text.TextUtils;
import com.xiaomi.channel.commonutils.android.g;
import com.xiaomi.channel.commonutils.android.j;
import com.xiaomi.channel.commonutils.logger.b;
import com.xiaomi.channel.commonutils.misc.f;
import com.xiaomi.mipush.sdk.Constants;
import com.xiaomi.mipush.sdk.MiPushCommandMessage;
import com.xiaomi.mipush.sdk.MiPushMessage;
import com.xiaomi.mipush.sdk.PushMessageHandler;
import com.xiaomi.mipush.sdk.PushMessageHelper;
import com.xiaomi.mipush.sdk.a;
import com.xiaomi.mipush.sdk.ab;
import com.xiaomi.mipush.sdk.d;
import com.xiaomi.mipush.sdk.h;
import com.xiaomi.mipush.sdk.k;
import com.xiaomi.mipush.sdk.l;
import com.xiaomi.mipush.sdk.m;
import com.xiaomi.mipush.sdk.n;
import com.xiaomi.mipush.sdk.o;
import com.xiaomi.mipush.sdk.p;
import com.xiaomi.mipush.sdk.u;
import com.xiaomi.mipush.sdk.x;
import com.xiaomi.mipush.sdk.z;
import com.xiaomi.push.service.ah;
import com.xiaomi.push.service.aw;
import com.xiaomi.push.service.receivers.NetworkStatusReceiver;
import com.xiaomi.xmpush.thrift.ae;
import com.xiaomi.xmpush.thrift.af;
import com.xiaomi.xmpush.thrift.ak;
import com.xiaomi.xmpush.thrift.am;
import com.xiaomi.xmpush.thrift.ao;
import com.xiaomi.xmpush.thrift.e;
import com.xiaomi.xmpush.thrift.r;
import com.xiaomi.xmpush.thrift.t;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MiPushClient {
    public static final String COMMAND_REGISTER = "register";
    public static final String COMMAND_SET_ALIAS = "set-alias";
    public static final String COMMAND_UNSET_ALIAS = "unset-alias";
    public static final String COMMAND_SET_ACCOUNT = "set-account";
    public static final String COMMAND_UNSET_ACCOUNT = "unset-account";
    public static final String COMMAND_SUBSCRIBE_TOPIC = "subscribe-topic";
    public static final String COMMAND_UNSUBSCRIBE_TOPIC = "unsubscibe-topic";
    public static final String COMMAND_SET_ACCEPT_TIME = "accept-time";
    public static final String PREF_EXTRA = "mipush_extra";
    private static Context sContext;
    private static long sCurMsgId;
    private static z mSyncMIIDHelper;

    public static boolean shouldUseMIUIPush(Context context) {
        return u.a(context).c();
    }

    public static void registerPush(Context context, String string, String string2) {
        if (!NetworkStatusReceiver.a()) {
            MiPushClient.registerNetworkReceiver(context);
        }
        new Thread(new k(context, string, string2)).start();
    }

    private static void registerNetworkReceiver(Context context) {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        intentFilter.addCategory("android.intent.category.DEFAULT");
        context.registerReceiver((BroadcastReceiver)new NetworkStatusReceiver(null), intentFilter);
    }

    @Deprecated
    public static void initialize(Context context, String string, String string2, MiPushClientCallback miPushClientCallback) {
        MiPushClient.checkNotNull(context, "context");
        MiPushClient.checkNotNull(string, "appID");
        MiPushClient.checkNotNull(string2, "appToken");
        try {
            Object object;
            boolean bl2;
            if (aw.a().b()) {
                aw.a().a(context);
            }
            String string3 = "UPLOADER_FROM_MIPUSHCLIENT";
            aw.a().a(new ab(context), string3);
            sContext = context.getApplicationContext();
            if (sContext == null) {
                sContext = context;
            }
            if (miPushClientCallback != null) {
                PushMessageHandler.a(miPushClientCallback);
            }
            if (j.b(context)) {
                h.a(context);
            }
            boolean bl3 = bl2 = a.a(sContext).m() != Constants.a();
            if (!bl2 && !MiPushClient.shouldSendRegRequest(sContext)) {
                u.a(context).a();
                b.a("Could not send  register message within 5s repeatly .");
                return;
            }
            if (!bl2 && a.a(sContext).a(string, string2) && !a.a(sContext).n()) {
                Object object2;
                if (1 == PushMessageHelper.getPushMode(context)) {
                    MiPushClient.checkNotNull(miPushClientCallback, "callback");
                    miPushClientCallback.onInitializeResult(0L, null, a.a(context).e());
                } else {
                    object = new ArrayList();
                    object.add(a.a(context).e());
                    object2 = PushMessageHelper.generateCommandMessage(COMMAND_REGISTER, (List<String>)object, 0L, null, null);
                    PushMessageHelper.sendCommandMessageBroadcast(sContext, (MiPushCommandMessage)object2);
                }
                u.a(context).a();
                if (a.a(sContext).a()) {
                    object = new ae();
                    ((ae)object).b(a.a(context).c());
                    ((ae)object).c("client_info_update");
                    ((ae)object).a(MiPushClient.generatePacketID());
                    ((ae)object).h = new HashMap<String, String>();
                    ((ae)object).h.put("app_version", com.xiaomi.channel.commonutils.android.b.a(sContext, sContext.getPackageName()));
                    ((ae)object).h.put("app_version_code", Integer.toString(com.xiaomi.channel.commonutils.android.b.b(sContext, sContext.getPackageName())));
                    ((ae)object).h.put("push_sdk_vn", "3_2_3");
                    ((ae)object).h.put("push_sdk_vc", Integer.toString(30203));
                    object2 = a.a(sContext).g();
                    if (!TextUtils.isEmpty((CharSequence)object2)) {
                        ((ae)object).h.put("deviceid", (String)object2);
                    }
                    u.a(context).a(object, com.xiaomi.xmpush.thrift.a.i, false, null);
                }
                if (!com.xiaomi.channel.commonutils.android.h.a(sContext, "update_devId", false)) {
                    MiPushClient.updateIMEI();
                    com.xiaomi.channel.commonutils.android.h.b(sContext, "update_devId", true);
                }
                if (MiPushClient.shouldUseMIUIPush(sContext) && MiPushClient.shouldPullNotification(sContext)) {
                    object = new ae();
                    ((ae)object).b(a.a(sContext).c());
                    ((ae)object).c("pull");
                    ((ae)object).a(MiPushClient.generatePacketID());
                    ((ae)object).a(false);
                    u.a(sContext).a(object, com.xiaomi.xmpush.thrift.a.i, false, null, false);
                    MiPushClient.addPullNotificationTime(sContext);
                }
            } else {
                object = com.xiaomi.channel.commonutils.string.d.a(6);
                a.a(sContext).h();
                a.a(sContext).a(Constants.a());
                a.a(sContext).a(string, string2, (String)object);
                MiPushClient.clearExtras(sContext);
                af af2 = new af();
                af2.a(MiPushClient.generatePacketID());
                af2.b(string);
                af2.e(string2);
                af2.d(context.getPackageName());
                af2.f((String)object);
                af2.c(com.xiaomi.channel.commonutils.android.b.a(context, context.getPackageName()));
                af2.b(com.xiaomi.channel.commonutils.android.b.b(context, context.getPackageName()));
                af2.g("3_2_3");
                af2.a(30203);
                af2.h(com.xiaomi.channel.commonutils.android.e.b(sContext));
                af2.a(t.c);
                String string4 = com.xiaomi.channel.commonutils.android.e.d(sContext);
                if (!TextUtils.isEmpty((CharSequence)string4)) {
                    if (g.b()) {
                        af2.i(string4);
                    }
                    af2.k(com.xiaomi.channel.commonutils.string.d.a(string4));
                }
                af2.j(com.xiaomi.channel.commonutils.android.e.a());
                int n2 = com.xiaomi.channel.commonutils.android.e.b();
                if (n2 >= 0) {
                    af2.c(n2);
                }
                u.a(sContext).a(af2, bl2);
            }
            MiPushClient.addRegRequestTime(sContext);
            MiPushClient.scheduleOcVersionCheckJob();
            MiPushClient.scheduleGeoFenceRepeatJobs();
            MiPushClient.loadPlugin();
            x.a(sContext);
            try {
                if (mSyncMIIDHelper == null) {
                    mSyncMIIDHelper = new z(sContext);
                }
                mSyncMIIDHelper.a(sContext);
            }
            catch (Exception exception) {
                b.d(exception.toString());
            }
            if ("disable_syncing".equals(p.a(sContext).a())) {
                MiPushClient.disablePush(sContext);
            }
            if ("enable_syncing".equals(p.a(sContext).a())) {
                MiPushClient.enablePush(sContext);
            }
        }
        catch (Throwable throwable) {
            b.a(throwable);
        }
    }

    private static void scheduleOcVersionCheckJob() {
        int n2 = ah.a(sContext).a(e.A.a(), 86400);
        f.a(sContext).a(new o(sContext), n2, 5);
    }

    private static void scheduleGeoFenceRepeatJobs() {
        if (!com.xiaomi.push.service.h.b(sContext)) {
            return;
        }
        int n2 = ah.a(sContext).a(e.O.a(), 900);
        f.a(sContext).a(new d(sContext), n2);
    }

    private static void loadPlugin() {
        int n2 = e.z.a();
        if (ah.a(sContext).a(n2, MiPushClient.getDefaultSwitch())) {
            f.a(sContext).a(new l(), 10);
        }
    }

    private static boolean getDefaultSwitch() {
        return g.b();
    }

    private static void updateIMEI() {
        new Thread(new m()).start();
    }

    public static void awakeApps(Context context, String[] stringArray) {
        new Thread(new n(stringArray, context)).start();
    }

    private static void awakePushServiceByPackageInfo(Context context, PackageInfo packageInfo) {
        ServiceInfo[] serviceInfoArray = packageInfo.services;
        if (serviceInfoArray != null) {
            for (ServiceInfo serviceInfo : serviceInfoArray) {
                if (!serviceInfo.exported || !serviceInfo.enabled || !"com.xiaomi.mipush.sdk.PushMessageHandler".equals(serviceInfo.name) || context.getPackageName().equals(serviceInfo.packageName)) continue;
                try {
                    Thread.sleep((long)(Math.random() * 2.0 + 1.0) * 1000L);
                    Intent intent = new Intent();
                    intent.setClassName(serviceInfo.packageName, serviceInfo.name);
                    intent.setAction("com.xiaomi.mipush.sdk.WAKEUP");
                    intent.putExtra("waker_pkgname", context.getPackageName());
                    context.startService(intent);
                }
                catch (Throwable throwable) {}
                break;
            }
        }
    }

    public static List<String> getAllAlias(Context context) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        Set set = sharedPreferences.getAll().keySet();
        for (String string : set) {
            if (!string.startsWith("alias_")) continue;
            arrayList.add(string.substring("alias_".length()));
        }
        return arrayList;
    }

    public static List<String> getAllTopic(Context context) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        Set set = sharedPreferences.getAll().keySet();
        for (String string : set) {
            if (!string.startsWith("topic_") || string.contains("**ALL**")) continue;
            arrayList.add(string.substring("topic_".length()));
        }
        return arrayList;
    }

    public static List<String> getAllUserAccount(Context context) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        Set set = sharedPreferences.getAll().keySet();
        for (String string : set) {
            if (!string.startsWith("account_")) continue;
            arrayList.add(string.substring("account_".length()));
        }
        return arrayList;
    }

    protected static void clearExtras(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.clear();
        editor.commit();
    }

    static void reInitialize(Context context, t t2) {
        if (!a.a(context).i()) {
            return;
        }
        String string = com.xiaomi.channel.commonutils.string.d.a(6);
        String string2 = a.a(context).c();
        String string3 = a.a(context).d();
        a.a(context).h();
        a.a(context).a(string2, string3, string);
        af af2 = new af();
        af2.a(MiPushClient.generatePacketID());
        af2.b(string2);
        af2.e(string3);
        af2.f(string);
        af2.d(context.getPackageName());
        af2.c(com.xiaomi.channel.commonutils.android.b.a(context, context.getPackageName()));
        af2.a(t2);
        u.a(context).a(af2, false);
    }

    @Deprecated
    public static void reportMessageClicked(Context context, String string) {
        MiPushClient.reportMessageClicked(context, string, null, null);
    }

    public static void reportMessageClicked(Context context, MiPushMessage miPushMessage) {
        r r2 = new r();
        r2.a(miPushMessage.getMessageId());
        r2.b(miPushMessage.getTopic());
        r2.d(miPushMessage.getDescription());
        r2.c(miPushMessage.getTitle());
        r2.c(miPushMessage.getNotifyId());
        r2.a(miPushMessage.getNotifyType());
        r2.b(miPushMessage.getPassThrough());
        r2.a(miPushMessage.getExtra());
        MiPushClient.reportMessageClicked(context, miPushMessage.getMessageId(), r2, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    static void reportMessageClicked(Context context, String string, r r2, String string2) {
        ae ae2 = new ae();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            if (!a.a(context).b()) {
                b.d("do not report clicked message");
                return;
            }
            ae2.b(a.a(context).c());
        } else {
            ae2.b(string2);
        }
        ae2.c("bar:click");
        ae2.a(string);
        ae2.a(false);
        u.a(context).a(ae2, com.xiaomi.xmpush.thrift.a.i, false, r2);
    }

    static void reportIgnoreRegMessageClicked(Context context, String string, r r2, String string2, String string3) {
        ae ae2 = new ae();
        if (TextUtils.isEmpty((CharSequence)string3)) {
            b.d("do not report clicked message");
            return;
        }
        ae2.b(string3);
        ae2.c("bar:click");
        ae2.a(string);
        ae2.a(false);
        u.a(context).a(ae2, com.xiaomi.xmpush.thrift.a.i, false, true, r2, true, string2, string3);
    }

    public static void setLocalNotificationType(Context context, int n2) {
        int n3 = n2 & 0xFFFFFFFF;
        u.a(context).b(n3);
    }

    public static void clearLocalNotificationType(Context context) {
        u.a(context).f();
    }

    public static void unregisterPush(Context context) {
        if (!a.a(context).b()) {
            return;
        }
        am am2 = new am();
        am2.a(MiPushClient.generatePacketID());
        am2.b(a.a(context).c());
        am2.c(a.a(context).e());
        am2.e(a.a(context).d());
        am2.d(context.getPackageName());
        u.a(context).a(am2);
        PushMessageHandler.a();
        a.a(context).k();
        MiPushClient.clearExtras(context);
        MiPushClient.clearLocalNotificationType(context);
        MiPushClient.clearNotification(context);
        if (mSyncMIIDHelper != null) {
            com.xiaomi.push.service.k.a(context).b(mSyncMIIDHelper);
        }
    }

    public static void disablePush(Context context) {
        u.a(context).a(true);
    }

    public static void enablePush(Context context) {
        u.a(context).a(false);
    }

    public static void setAlias(Context context, String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            MiPushClient.setCommand(context, COMMAND_SET_ALIAS, string, string2);
        }
    }

    public static void unsetAlias(Context context, String string, String string2) {
        MiPushClient.setCommand(context, COMMAND_UNSET_ALIAS, string, string2);
    }

    public static void setUserAccount(Context context, String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            MiPushClient.setCommand(context, COMMAND_SET_ACCOUNT, string, string2);
        }
    }

    public static void unsetUserAccount(Context context, String string, String string2) {
        MiPushClient.setCommand(context, COMMAND_UNSET_ACCOUNT, string, string2);
    }

    public static void subscribe(Context context, String string, String string2) {
        if (TextUtils.isEmpty((CharSequence)a.a(context).c()) || TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        if (Math.abs(System.currentTimeMillis() - MiPushClient.topicSubscribedTime(context, string)) > 86400000L) {
            ak ak2 = new ak();
            ak2.a(MiPushClient.generatePacketID());
            ak2.b(a.a(context).c());
            ak2.c(string);
            ak2.d(context.getPackageName());
            ak2.e(string2);
            u.a(context).a(ak2, com.xiaomi.xmpush.thrift.a.c, null);
        } else if (1 == PushMessageHelper.getPushMode(context)) {
            PushMessageHandler.a(context, string2, 0L, null, string);
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            MiPushCommandMessage miPushCommandMessage = PushMessageHelper.generateCommandMessage(COMMAND_SUBSCRIBE_TOPIC, arrayList, 0L, null, null);
            PushMessageHelper.sendCommandMessageBroadcast(context, miPushCommandMessage);
        }
    }

    public static void unsubscribe(Context context, String string, String string2) {
        if (!a.a(context).b()) {
            return;
        }
        if (MiPushClient.topicSubscribedTime(context, string) < 0L) {
            b.a("Don't cancel subscribe for " + string + " is unsubscribed");
            return;
        }
        ao ao2 = new ao();
        ao2.a(MiPushClient.generatePacketID());
        ao2.b(a.a(context).c());
        ao2.c(string);
        ao2.d(context.getPackageName());
        ao2.e(string2);
        u.a(context).a(ao2, com.xiaomi.xmpush.thrift.a.d, null);
    }

    public static void pausePush(Context context, String string) {
        MiPushClient.setAcceptTime(context, 0, 0, 0, 0, string);
    }

    public static void resumePush(Context context, String string) {
        MiPushClient.setAcceptTime(context, 0, 0, 23, 59, string);
    }

    public static void clearNotification(Context context, int n2) {
        u.a(context).a(n2);
    }

    public static void clearNotification(Context context, String string, String string2) {
        u.a(context).a(string, string2);
    }

    public static void clearNotification(Context context) {
        u.a(context).a(-1);
    }

    public static String getRegId(Context context) {
        if (a.a(context).i()) {
            return a.a(context).e();
        }
        return null;
    }

    protected static void setCommand(Context context, String string, String string2, String string3) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            arrayList.add(string2);
        }
        if (COMMAND_SET_ALIAS.equalsIgnoreCase(string) && Math.abs(System.currentTimeMillis() - MiPushClient.aliasSetTime(context, string2)) < 3600000L) {
            if (1 == PushMessageHelper.getPushMode(context)) {
                PushMessageHandler.a(context, string3, string, 0L, null, arrayList);
            } else {
                MiPushCommandMessage miPushCommandMessage = PushMessageHelper.generateCommandMessage(COMMAND_SET_ALIAS, arrayList, 0L, null, null);
                PushMessageHelper.sendCommandMessageBroadcast(context, miPushCommandMessage);
            }
        } else if (COMMAND_UNSET_ALIAS.equalsIgnoreCase(string) && MiPushClient.aliasSetTime(context, string2) < 0L) {
            b.a("Don't cancel alias for " + arrayList + " is unseted");
        } else if (COMMAND_SET_ACCOUNT.equalsIgnoreCase(string) && Math.abs(System.currentTimeMillis() - MiPushClient.accountSetTime(context, string2)) < 3600000L) {
            if (1 == PushMessageHelper.getPushMode(context)) {
                PushMessageHandler.a(context, string3, string, 0L, null, arrayList);
            } else {
                MiPushCommandMessage miPushCommandMessage = PushMessageHelper.generateCommandMessage(COMMAND_SET_ACCOUNT, arrayList, 0L, null, null);
                PushMessageHelper.sendCommandMessageBroadcast(context, miPushCommandMessage);
            }
        } else if (COMMAND_UNSET_ACCOUNT.equalsIgnoreCase(string) && MiPushClient.accountSetTime(context, string2) < 0L) {
            b.a("Don't cancel account for " + arrayList + " is unseted");
        } else {
            MiPushClient.setCommand(context, string, arrayList, string3);
        }
    }

    protected static void setCommand(Context context, String string, ArrayList<String> arrayList, String string2) {
        if (TextUtils.isEmpty((CharSequence)a.a(context).c())) {
            return;
        }
        com.xiaomi.xmpush.thrift.z z2 = new com.xiaomi.xmpush.thrift.z();
        z2.a(MiPushClient.generatePacketID());
        z2.b(a.a(context).c());
        z2.c(string);
        for (String string3 : arrayList) {
            z2.d(string3);
        }
        z2.f(string2);
        z2.e(context.getPackageName());
        u.a(context).a(z2, com.xiaomi.xmpush.thrift.a.j, null);
    }

    public static void setAcceptTime(Context context, int n2, int n3, int n4, int n5, String string) {
        if (n2 < 0 || n2 >= 24 || n4 < 0 || n4 >= 24 || n3 < 0 || n3 >= 60 || n5 < 0 || n5 >= 60) {
            throw new IllegalArgumentException("the input parameter is not valid.");
        }
        TimeZone timeZone = TimeZone.getTimeZone("GMT+08");
        TimeZone timeZone2 = TimeZone.getDefault();
        long l2 = 1440L;
        long l3 = (timeZone.getRawOffset() - timeZone2.getRawOffset()) / 1000 / 60;
        long l4 = ((long)(n2 * 60 + n3) + l3 + l2) % l2;
        long l5 = ((long)(n4 * 60 + n5) + l3 + l2) % l2;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(String.format("%1$02d:%2$02d", l4 / 60L, l4 % 60L));
        arrayList.add(String.format("%1$02d:%2$02d", l5 / 60L, l5 % 60L));
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(String.format("%1$02d:%2$02d", n2, n3));
        arrayList2.add(String.format("%1$02d:%2$02d", n4, n5));
        if (MiPushClient.acceptTimeSet(context, (String)arrayList.get(0), (String)arrayList.get(1))) {
            if (1 == PushMessageHelper.getPushMode(context)) {
                PushMessageHandler.a(context, string, COMMAND_SET_ACCEPT_TIME, 0L, null, arrayList2);
            } else {
                MiPushCommandMessage miPushCommandMessage = PushMessageHelper.generateCommandMessage(COMMAND_SET_ACCEPT_TIME, arrayList2, 0L, null, null);
                PushMessageHelper.sendCommandMessageBroadcast(context, miPushCommandMessage);
            }
        } else {
            MiPushClient.setCommand(context, COMMAND_SET_ACCEPT_TIME, arrayList, string);
        }
    }

    protected static synchronized String generatePacketID() {
        String string = com.xiaomi.channel.commonutils.string.d.a(4) + sCurMsgId;
        ++sCurMsgId;
        return string;
    }

    private static void checkNotNull(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException("param " + string + " is not nullable");
        }
    }

    static synchronized void addAlias(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().putLong("alias_" + string, System.currentTimeMillis()).commit();
    }

    static synchronized void removeAlias(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().remove("alias_" + string).commit();
    }

    static synchronized void removeAllAliases(Context context) {
        List<String> list = MiPushClient.getAllAlias(context);
        for (String string : list) {
            MiPushClient.removeAlias(context, string);
        }
    }

    static synchronized void addAccount(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().putLong("account_" + string, System.currentTimeMillis()).commit();
    }

    static synchronized void removeAccount(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().remove("account_" + string).commit();
    }

    static synchronized void removeAllAccounts(Context context) {
        List<String> list = MiPushClient.getAllUserAccount(context);
        for (String string : list) {
            MiPushClient.removeAccount(context, string);
        }
    }

    static synchronized void addTopic(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().putLong("topic_" + string, System.currentTimeMillis()).commit();
    }

    static synchronized void removeTopic(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().remove("topic_" + string).commit();
    }

    static synchronized void removeAllTopics(Context context) {
        List<String> list = MiPushClient.getAllTopic(context);
        for (String string : list) {
            MiPushClient.removeTopic(context, string);
        }
    }

    static synchronized void addAcceptTime(Context context, String string, String string2) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().putString("accept_time", string + "," + string2).commit();
    }

    static synchronized void removeAcceptTime(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().remove("accept_time").commit();
    }

    public static long topicSubscribedTime(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return sharedPreferences.getLong("topic_" + string, -1L);
    }

    public static long accountSetTime(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return sharedPreferences.getLong("account_" + string, -1L);
    }

    public static long aliasSetTime(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return sharedPreferences.getLong("alias_" + string, -1L);
    }

    private static boolean acceptTimeSet(Context context, String string, String string2) {
        String string3 = MiPushClient.getAcceptTime(context);
        return TextUtils.equals((CharSequence)string3, (CharSequence)(string + "," + string2));
    }

    protected static String getAcceptTime(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return sharedPreferences.getString("accept_time", "00:00-23:59");
    }

    private static void addPullNotificationTime(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().putLong("last_pull_notification", System.currentTimeMillis()).commit();
    }

    private static boolean shouldPullNotification(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return Math.abs(System.currentTimeMillis() - sharedPreferences.getLong("last_pull_notification", -1L)) > 300000L;
    }

    private static void addRegRequestTime(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().putLong("last_reg_request", System.currentTimeMillis()).commit();
    }

    private static boolean shouldSendRegRequest(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return Math.abs(System.currentTimeMillis() - sharedPreferences.getLong("last_reg_request", -1L)) > 5000L;
    }

    static /* synthetic */ Context access$000() {
        return sContext;
    }

    static /* synthetic */ void access$100(Context context, PackageInfo packageInfo) {
        MiPushClient.awakePushServiceByPackageInfo(context, packageInfo);
    }

    static {
        sCurMsgId = System.currentTimeMillis();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static abstract class MiPushClientCallback {
        private String category;

        protected String getCategory() {
            return this.category;
        }

        protected void setCategory(String string) {
            this.category = string;
        }

        public void onReceiveMessage(String string, String string2, String string3, boolean bl2) {
        }

        public void onReceiveMessage(MiPushMessage miPushMessage) {
        }

        public void onInitializeResult(long l2, String string, String string2) {
        }

        public void onSubscribeResult(long l2, String string, String string2) {
        }

        public void onUnsubscribeResult(long l2, String string, String string2) {
        }

        public void onCommandResult(String string, long l2, String string2, List<String> list) {
        }
    }
}

