/*
 * Decompiled with CFR 0.152.
 */
package com.peng.one.push.xiaomi;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.text.TextUtils;
import com.peng.one.push.cache.OnePushCache;
import com.peng.one.push.core.IPushClient;
import com.peng.one.push.log.OneLog;
import com.xiaomi.channel.commonutils.logger.LoggerInterface;
import com.xiaomi.mipush.sdk.Logger;
import com.xiaomi.mipush.sdk.MiPushClient;

public class XiaomiPushClient
implements IPushClient {
    public static final String MI_PUSH_APP_ID = "MI_PUSH_APP_ID";
    public static final String MI_PUSH_APP_KEY = "MI_PUSH_APP_KEY";
    private String mAppId;
    private String mAppKey;
    private Context mContext;

    public void initContext(Context context) {
        if (OneLog.isDebug()) {
            Logger.setLogger((Context)context, (LoggerInterface)new LoggerInterface(){

                public void setTag(String s) {
                }

                public void log(String s) {
                    OneLog.i((String)s);
                }

                public void log(String s, Throwable throwable) {
                    OneLog.e((String)s, (Throwable)throwable);
                }
            });
        }
        this.mContext = context.getApplicationContext();
        try {
            Bundle metaData = context.getPackageManager().getApplicationInfo((String)context.getPackageName(), (int)128).metaData;
            this.mAppId = metaData.getString(MI_PUSH_APP_ID).trim();
            this.mAppKey = metaData.getString(MI_PUSH_APP_KEY).trim();
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            OneLog.i((String)"can't find MI_PUSH_APP_ID or MI_PUSH_APP_KEY in AndroidManifest.xml");
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            OneLog.i((String)"can't find MI_PUSH_APP_ID or MI_PUSH_APP_KEY in AndroidManifest.xml");
        }
    }

    public void register() {
        if (TextUtils.isEmpty((CharSequence)this.mAppId) || TextUtils.isEmpty((CharSequence)this.mAppKey)) {
            throw new IllegalArgumentException("xiaomi push appId or appKey is not init,check you AndroidManifest.xml is has MI_PUSH_APP_ID or MI_PUSH_APP_KEY meta-data flag please");
        }
        MiPushClient.registerPush((Context)this.mContext, (String)this.mAppId, (String)this.mAppKey);
    }

    public void unRegister() {
        String token = OnePushCache.getToken((Context)this.mContext);
        if (!TextUtils.isEmpty((CharSequence)token)) {
            MiPushClient.unregisterPush((Context)this.mContext);
            OnePushCache.delToken((Context)this.mContext);
        }
    }

    public void bindAlias(String alias) {
        MiPushClient.setAlias((Context)this.mContext, (String)alias, null);
    }

    public void unBindAlias(String alias) {
        MiPushClient.unsetAlias((Context)this.mContext, (String)alias, null);
    }

    public void addTag(String tag) {
        MiPushClient.subscribe((Context)this.mContext, (String)tag, null);
    }

    public void deleteTag(String tag) {
        MiPushClient.unsubscribe((Context)this.mContext, (String)tag, null);
    }
}

