/*
 * Decompiled with CFR 0.152.
 */
package com.peng.one.push.xiaomi;

import android.content.Context;
import android.util.Log;
import com.peng.one.push.OneRepeater;
import com.peng.one.push.cache.OnePushCache;
import com.peng.one.push.log.OneLog;
import com.peng.one.push.xiaomi.R;
import com.xiaomi.mipush.sdk.MiPushCommandMessage;
import com.xiaomi.mipush.sdk.MiPushMessage;
import com.xiaomi.mipush.sdk.PushMessageReceiver;
import java.util.List;
import java.util.Map;

public class XiaomiPushReceiver
extends PushMessageReceiver {
    private static final String TAG = "XiaomiPushReceiver";
    private String mRegId;
    private String mTopic;
    private String mAlias;
    private String mAccount;
    private String mStartTime;
    private String mEndTime;

    public void onReceivePassThroughMessage(Context context, MiPushMessage message) {
        OneLog.i((String)TAG, (String)("onReceivePassThroughMessage() called with: context = [" + context + "], message = [" + message + "]"));
        OneRepeater.transmitMessage((Context)context, (String)message.getContent(), (String)message.getDescription(), (Map)message.getExtra());
    }

    public void onNotificationMessageClicked(Context context, MiPushMessage message) {
        OneLog.i((String)TAG, (String)("onNotificationMessageClicked() called with: context = [" + context + "], message = [" + message + "]"));
        OneRepeater.transmitNotificationClick((Context)context, (int)message.getNotifyId(), (String)message.getTitle(), (String)message.getDescription(), (String)message.getContent(), (Map)message.getExtra());
    }

    public void onNotificationMessageArrived(Context context, MiPushMessage message) {
        OneLog.i((String)TAG, (String)("onNotificationMessageArrived() called with: context = [" + context + "], message = [" + message + "]"));
        OneRepeater.transmitNotification((Context)context, (int)message.getNotifyId(), (String)message.getTitle(), (String)message.getDescription(), (String)message.getContent(), (Map)message.getExtra());
    }

    public void onCommandResult(Context context, MiPushCommandMessage message) {
        String log;
        String command = message.getCommand();
        List arguments = message.getCommandArguments();
        String cmdArg1 = arguments != null && arguments.size() > 0 ? (String)arguments.get(0) : null;
        String cmdArg2 = arguments != null && arguments.size() > 1 ? (String)arguments.get(1) : null;
        int commandType = -1;
        if ("register".equals(command)) {
            if (message.getResultCode() == 0L) {
                this.mRegId = cmdArg1;
                log = context.getString(R.string.register_success);
            } else {
                log = context.getString(R.string.register_fail);
            }
        } else if ("set-alias".equals(command)) {
            commandType = 2025;
            if (message.getResultCode() == 0L) {
                this.mAlias = cmdArg1;
                log = context.getString(R.string.set_alias_success, new Object[]{this.mAlias});
            } else {
                log = context.getString(R.string.set_alias_fail, new Object[]{message.getReason()});
            }
        } else if ("unset-alias".equals(command)) {
            commandType = 2026;
            if (message.getResultCode() == 0L) {
                this.mAlias = cmdArg1;
                log = context.getString(R.string.unset_alias_success, new Object[]{this.mAlias});
            } else {
                log = context.getString(R.string.unset_alias_fail, new Object[]{message.getReason()});
            }
        } else if ("set-account".equals(command)) {
            if (message.getResultCode() == 0L) {
                this.mAccount = cmdArg1;
                log = context.getString(R.string.set_account_success, new Object[]{this.mAccount});
            } else {
                log = context.getString(R.string.set_account_fail, new Object[]{message.getReason()});
            }
        } else if ("unset-account".equals(command)) {
            if (message.getResultCode() == 0L) {
                this.mAccount = cmdArg1;
                log = context.getString(R.string.unset_account_success, new Object[]{this.mAccount});
            } else {
                log = context.getString(R.string.unset_account_fail, new Object[]{message.getReason()});
            }
        } else if ("subscribe-topic".equals(command)) {
            commandType = 2023;
            if (message.getResultCode() == 0L) {
                this.mTopic = cmdArg1;
                log = context.getString(R.string.subscribe_topic_success, new Object[]{this.mTopic});
            } else {
                log = context.getString(R.string.subscribe_topic_fail, new Object[]{message.getReason()});
            }
        } else if ("unsubscibe-topic".equals(command)) {
            commandType = 2024;
            if (message.getResultCode() == 0L) {
                this.mTopic = cmdArg1;
                log = context.getString(R.string.unsubscribe_topic_success, new Object[]{this.mTopic});
            } else {
                log = context.getString(R.string.unsubscribe_topic_fail, new Object[]{message.getReason()});
            }
        } else if ("accept-time".equals(command)) {
            if (message.getResultCode() == 0L) {
                this.mStartTime = cmdArg1;
                this.mEndTime = cmdArg2;
                log = context.getString(R.string.set_accept_time_success, new Object[]{this.mStartTime, this.mEndTime});
            } else {
                log = context.getString(R.string.set_accept_time_fail, new Object[]{message.getReason()});
            }
        } else {
            log = message.getReason();
        }
        if (commandType != -1) {
            OneRepeater.transmitCommandResult((Context)context, (int)commandType, (int)(message.getResultCode() == 0L ? 200 : 400), null, (String)cmdArg1, (String)message.getReason());
        }
        OneLog.i((String)TAG, (String)("onCommandResult is called. " + message.toString() + " reason:" + log));
    }

    public void onReceiveRegisterResult(Context context, MiPushCommandMessage message) {
        String log;
        String command = message.getCommand();
        List arguments = message.getCommandArguments();
        String cmdArg1 = arguments != null && arguments.size() > 0 ? (String)arguments.get(0) : null;
        OneRepeater.transmitCommandResult((Context)context, (int)2021, (int)("register".equals(command) ? 200 : 400), (String)cmdArg1, null, (String)message.getReason());
        OnePushCache.putToken((Context)context, (String)cmdArg1);
        if ("register".equals(command)) {
            if (message.getResultCode() == 0L) {
                this.mRegId = cmdArg1;
                log = context.getString(R.string.register_success);
            } else {
                log = context.getString(R.string.register_fail) + cmdArg1;
            }
        } else {
            log = message.getReason();
        }
        Log.d((String)TAG, (String)("onReceiveRegisterResult is called.  reason:" + log));
    }
}

