/*
 * Decompiled with CFR 0.152.
 */
package com.peng.one.push.umeng;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import com.peng.one.push.OneRepeater;
import com.peng.one.push.core.IPushClient;
import com.peng.one.push.umeng.OnePushMessageHandler;
import com.peng.one.push.umeng.OnePushNotificationClickHandler;
import com.umeng.message.IUmengCallback;
import com.umeng.message.IUmengRegisterCallback;
import com.umeng.message.PushAgent;
import com.umeng.message.UHandler;
import com.umeng.message.UTrack;
import com.umeng.message.common.inter.ITagManager;
import com.umeng.message.tag.TagManager;

public class UMengPushClient
implements IPushClient {
    public static final String ONE_PUSH_ALIAS = "ONE_PUSH";
    private PushAgent mPushAgent;
    private String deviceToken;
    private Application app;
    private Context context;
    private Application.ActivityLifecycleCallbacks lifecycleCallbacks = new Application.ActivityLifecycleCallbacks(){

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
            UMengPushClient.this.mPushAgent.onAppStart();
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        public void onActivityDestroyed(Activity activity) {
        }
    };

    public void initContext(Context context) {
        if (!(context instanceof Application)) {
            throw new IllegalArgumentException("UMengPush must init by Application,you can call OnePush.init() method at Application onCreate that you custom application class!");
        }
        this.app = (Application)context;
        this.context = context.getApplicationContext();
        this.mPushAgent = PushAgent.getInstance((Context)context);
        this.mPushAgent.setNotificationClickHandler((UHandler)new OnePushNotificationClickHandler());
        this.mPushAgent.setMessageHandler((UHandler)new OnePushMessageHandler());
        this.mPushAgent.setDebugMode(false);
        this.mPushAgent.setDisplayNotificationNumber(0);
    }

    public void register() {
        this.app.registerActivityLifecycleCallbacks(this.lifecycleCallbacks);
        new Thread(){

            @Override
            public void run() {
                UMengPushClient.this.mPushAgent.register(new IUmengRegisterCallback(){

                    public void onSuccess(String deviceToken) {
                        UMengPushClient.this.deviceToken = deviceToken;
                        OneRepeater.transmitCommandResult((Context)UMengPushClient.this.context, (int)2021, (int)200, (String)deviceToken, null, (String)"success");
                        UMengPushClient.this.mPushAgent.enable(null);
                    }

                    public void onFailure(String s, String s1) {
                        OneRepeater.transmitCommandResult((Context)UMengPushClient.this.context, (int)2021, (int)400, null, (String)s, (String)s1);
                    }
                });
            }
        }.start();
    }

    public void unRegister() {
        this.app.unregisterActivityLifecycleCallbacks(this.lifecycleCallbacks);
        this.mPushAgent.disable(new IUmengCallback(){

            public void onSuccess() {
                OneRepeater.transmitCommandResult((Context)UMengPushClient.this.context, (int)2022, (int)200, (String)UMengPushClient.this.deviceToken, null, null);
            }

            public void onFailure(String s, String s1) {
                OneRepeater.transmitCommandResult((Context)UMengPushClient.this.context, (int)2022, (int)400, (String)UMengPushClient.this.deviceToken, null, null);
            }
        });
    }

    public void bindAlias(final String alias) {
        this.mPushAgent.addAlias(alias, ONE_PUSH_ALIAS, new UTrack.ICallBack(){

            public void onMessage(boolean isSuccess, String message) {
                OneRepeater.transmitCommandResult((Context)UMengPushClient.this.context, (int)2025, (int)(isSuccess ? 200 : 400), null, (String)alias, (String)message);
            }
        });
    }

    public void unBindAlias(final String alias) {
        this.mPushAgent.removeAlias(alias, ONE_PUSH_ALIAS, new UTrack.ICallBack(){

            public void onMessage(boolean isSuccess, String message) {
                OneRepeater.transmitCommandResult((Context)UMengPushClient.this.context, (int)2026, (int)(isSuccess ? 200 : 400), null, (String)alias, (String)message);
            }
        });
    }

    public void addTag(final String tag) {
        this.mPushAgent.getTagManager().add(new TagManager.TCallBack(){

            public void onMessage(boolean isSuccess, ITagManager.Result result) {
                OneRepeater.transmitCommandResult((Context)UMengPushClient.this.context, (int)2023, (int)(isSuccess ? 200 : 400), null, (String)tag, (String)(result == null ? "" : result.errors));
            }
        }, new String[]{tag});
    }

    public void deleteTag(final String tag) {
        this.mPushAgent.getTagManager().delete(new TagManager.TCallBack(){

            public void onMessage(boolean isSuccess, ITagManager.Result result) {
                OneRepeater.transmitCommandResult((Context)UMengPushClient.this.context, (int)2024, (int)(isSuccess ? 200 : 400), null, (String)tag, (String)(result == null ? "" : result.errors));
            }
        }, new String[]{tag});
    }
}

