/*
 * Decompiled with CFR 0.152.
 */
package org.android.spdy;

import android.os.Handler;
import android.os.HandlerThread;
import java.util.concurrent.atomic.AtomicBoolean;
import org.android.spdy.Intenalcb;
import org.android.spdy.NetSparseArray;
import org.android.spdy.SessionCb;
import org.android.spdy.SpdyAgent;
import org.android.spdy.SpdyDataProvider;
import org.android.spdy.SpdyErrorException;
import org.android.spdy.SpdyRequest;
import org.android.spdy.SpdySessionCallBack;
import org.android.spdy.SpdyStreamContext;
import org.android.spdy.Spdycb;
import org.android.spdy.spduLog;

public final class SpdySession {
    private static volatile int count = 0;
    private SpdyAgent agent;
    private volatile long sessionNativePtr;
    private AtomicBoolean closed = new AtomicBoolean();
    private boolean sessionClearedFromSessionMgr = false;
    Intenalcb intenalcb;
    private HandlerThread thread;
    private Handler handler;
    private String authority;
    private String domain;
    private Object lock = new Object();
    private int streamcount = 1;
    private NetSparseArray<SpdyStreamContext> spdyStream = null;
    SessionCb sessionCallBack = null;
    private int pubkey_seqnum = 0;
    private Object userData = null;
    volatile int refcount = 1;
    private int mode;

    SpdySession(long l2, SpdyAgent spdyAgent, String string, String string2, SessionCb sessionCb, int n2, int n3, Object object) {
        this.sessionNativePtr = l2;
        this.agent = spdyAgent;
        this.authority = string;
        this.intenalcb = new SpdySessionCallBack();
        this.domain = string2;
        this.spdyStream = new NetSparseArray(5);
        this.sessionCallBack = sessionCb;
        this.pubkey_seqnum = n3;
        this.mode = n2;
        this.userData = object;
        this.closed.set(false);
    }

    public int getRefCount() {
        return this.refcount;
    }

    void increRefCount() {
        ++this.refcount;
    }

    private String getAuthority() {
        return this.authority;
    }

    public String getDomain() {
        return this.domain;
    }

    public Object getUserData() {
        return this.userData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int putSpdyStreamCtx(SpdyStreamContext spdyStreamContext) {
        int n2 = 0;
        Object object = this.lock;
        synchronized (object) {
            n2 = this.streamcount++;
            this.spdyStream.put(n2, spdyStreamContext);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SpdyStreamContext getSpdyStream(int n2) {
        SpdyStreamContext spdyStreamContext = null;
        if (n2 > 0) {
            Object object = this.lock;
            synchronized (object) {
                spdyStreamContext = this.spdyStream.get(n2);
            }
        }
        return spdyStreamContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSpdyStream(int n2) {
        if (n2 > 0) {
            Object object = this.lock;
            synchronized (object) {
                this.spdyStream.remove(n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpdyStreamContext[] getAllStreamCb() {
        int n2 = 0;
        SpdyStreamContext[] spdyStreamContextArray = null;
        Object object = this.lock;
        synchronized (object) {
            n2 = this.spdyStream.size();
            if (n2 > 0) {
                spdyStreamContextArray = new SpdyStreamContext[n2];
                this.spdyStream.toArray((SpdyStreamContext[])spdyStreamContextArray);
            }
        }
        return spdyStreamContextArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllStreamCb() {
        spduLog.Logd("tnet-jni", "[SpdySession.clearAllStreamCb] - ");
        Object object = this.lock;
        synchronized (object) {
            this.spdyStream.clear();
        }
    }

    SpdyAgent getSpdyAgent() {
        return this.agent;
    }

    Handler getMsgHandler() {
        return this.handler;
    }

    long getSessionNativePtr() {
        return this.sessionNativePtr;
    }

    void setSessionNativePtr(long l2) {
        this.sessionNativePtr = l2;
    }

    public int setOption(int n2, int n3) throws SpdyErrorException {
        this.sessionIsOpen();
        int n4 = this.setOptionN(this.sessionNativePtr, n2, n3);
        if (n4 != 0) {
            throw new SpdyErrorException("setOption error: " + n4, n4);
        }
        return n4;
    }

    public int submitPing() throws SpdyErrorException {
        this.sessionIsOpen();
        int n2 = this.submitPingN(this.sessionNativePtr);
        if (n2 != 0) {
            throw new SpdyErrorException("submitPing error: " + n2, n2);
        }
        return n2;
    }

    @Deprecated
    public int submitBioPing() throws SpdyErrorException {
        this.sessionIsOpen();
        int n2 = this.submitBioPingN(this.sessionNativePtr);
        if (n2 != 0) {
            throw new SpdyErrorException("submitBioPing error: " + n2, n2);
        }
        return n2;
    }

    public int streamReset(long l2, int n2) throws SpdyErrorException {
        this.sessionIsOpen();
        spduLog.Logd("tnet-jni", "[SpdySession.streamReset] - ");
        int n3 = this.streamCloseN(this.sessionNativePtr, (int)l2, n2);
        if (n3 != 0) {
            throw new SpdyErrorException("streamReset error: " + n3, n3);
        }
        return n3;
    }

    public int sendCustomControlFrame(int n2, int n3, int n4, int n5, byte[] byArray) throws SpdyErrorException {
        this.sessionIsOpen();
        if (byArray != null && byArray.length <= 0) {
            byArray = null;
        }
        spduLog.Logi("tnet-jni", "[sendCustomControlFrame] - type: " + n3);
        int n6 = this.sendCustomControlFrameN(this.sessionNativePtr, n2, n3, n4, n5, byArray);
        if (n6 != 0) {
            throw new SpdyErrorException("sendCustomControlFrame error: " + n6, n6);
        }
        return n6;
    }

    public int submitRequest(SpdyRequest spdyRequest, SpdyDataProvider spdyDataProvider, Object object, Spdycb spdycb) throws SpdyErrorException {
        if (spdyRequest == null || object == null || spdyRequest.getAuthority() == null) {
            throw new SpdyErrorException("submitRequest error: -1102", -1102);
        }
        this.sessionIsOpen();
        byte[] byArray = SpdyAgent.dataproviderToByteArray(spdyRequest, spdyDataProvider);
        if (byArray != null && byArray.length <= 0) {
            byArray = null;
        }
        boolean bl = true;
        if (spdyDataProvider != null) {
            bl = spdyDataProvider.finished;
        }
        SpdyStreamContext spdyStreamContext = new SpdyStreamContext(object, spdycb);
        int n2 = this.putSpdyStreamCtx(spdyStreamContext);
        String[] stringArray = SpdyAgent.mapToByteArray(spdyRequest.getHeaders());
        spduLog.Logi("tnet-jni", "index=" + n2 + "  " + "starttime=" + System.currentTimeMillis());
        int n3 = this.submitRequestN(this.sessionNativePtr, spdyRequest.getUrlPath(), (byte)spdyRequest.getPriority(), stringArray, byArray, bl, n2, spdyRequest.getRequestTimeoutMs());
        spduLog.Logi("tnet-jni", "index=" + n2 + "  " + " calltime=" + System.currentTimeMillis());
        if (n3 < 0) {
            this.removeSpdyStream(n2);
            throw new SpdyErrorException("submitRequest error: " + n3, n3);
        }
        spdyStreamContext.streamId = n3;
        return n3;
    }

    void sessionIsOpen() {
        if (this.closed.get()) {
            throw new SpdyErrorException("session is already closed: -1104", -1104);
        }
    }

    public int cleanUp() {
        spduLog.Logd("tnet-jni", "[SpdySession.cleanUp] - ");
        int n2 = 0;
        if (!this.closed.getAndSet(true)) {
            this.agent.removeSession(this);
            n2 = this.closeprivate();
        }
        return n2;
    }

    int closeInternal() {
        int n2 = 0;
        if (!this.closed.getAndSet(true)) {
            n2 = this.closeprivate();
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int closeSession() {
        spduLog.Logd("tnet-jni", "[SpdySession.closeSession] - ");
        int n2 = 0;
        Object object = this.lock;
        synchronized (object) {
            if (!this.sessionClearedFromSessionMgr) {
                spduLog.Logd("tnet-jni", "[SpdySession.closeSession] - " + this.authority);
                this.agent.clearSpdySession(this.authority, this.domain, this.mode);
                this.sessionClearedFromSessionMgr = true;
                try {
                    n2 = this.agent.closeSession(this.sessionNativePtr);
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    unsatisfiedLinkError.printStackTrace();
                }
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int closeprivate() {
        int n2 = 0;
        Object object = this.lock;
        synchronized (object) {
            if (!this.sessionClearedFromSessionMgr) {
                this.agent.clearSpdySession(this.authority, this.domain, this.mode);
                this.sessionClearedFromSessionMgr = true;
            }
        }
        this.sessionNativePtr = 0L;
        object = this.lock;
        synchronized (object) {
            SpdyStreamContext[] spdyStreamContextArray = this.getAllStreamCb();
            if (spdyStreamContextArray != null) {
                for (SpdyStreamContext spdyStreamContext : spdyStreamContextArray) {
                    spduLog.Logi("tnet-jni", "[SpdySessionCallBack.spdyStreamCloseCallback] unfinished stm=" + spdyStreamContext.streamId);
                    spdyStreamContext.callBack.spdyStreamCloseCallback(this, spdyStreamContext.streamId, -2001, spdyStreamContext.streamContext, null);
                }
            }
            this.spdyStream.clear();
        }
        return n2;
    }

    private native int submitRequestN(long var1, String var3, byte var4, String[] var5, byte[] var6, boolean var7, int var8, int var9);

    private native int sendCustomControlFrameN(long var1, int var3, int var4, int var5, int var6, byte[] var7);

    private native int sendHeadersN(long var1, int var3, String[] var4, boolean var5);

    private native int streamSendDataN(long var1, int var3, byte[] var4, int var5, int var6, boolean var7);

    private native int setOptionN(long var1, int var3, int var4);

    private native int submitPingN(long var1);

    private native int submitBioPingN(long var1);

    private native int streamCloseN(long var1, int var3, int var4);
}

