/*
 * Decompiled with CFR 0.152.
 */
package org.android.agoo.control;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import com.taobao.accs.ACCSManager;
import com.taobao.accs.IACCSManager;
import com.taobao.accs.base.TaoBaseService;
import com.taobao.accs.utl.ALog;
import com.taobao.accs.utl.UTMini;
import com.taobao.accs.utl.a;
import com.taobao.accs.utl.b;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.android.agoo.common.MsgDO;
import org.android.agoo.common.e;
import org.android.agoo.control.g;
import org.json.JSONObject;

public class NotifManager {
    private static final String TAG = "NotifManager";
    private static final String ACK_MESSAGE = "accs.ackMessage";
    private static Context mContext = null;
    private ScheduledThreadPoolExecutor mThreadPool;
    private static final int EVENT_ID = 66001;

    public void init(Context context) {
        mContext = context;
        this.mThreadPool = e.a();
    }

    public void handlerACKMessage(MsgDO msgDO, TaoBaseService.ExtraInfo extraInfo) {
        if (msgDO == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)msgDO.msgIds) && TextUtils.isEmpty((CharSequence)msgDO.removePacks) && TextUtils.isEmpty((CharSequence)msgDO.errorCode)) {
            UTMini.getInstance().commitEvent(66002, ACK_MESSAGE, a.b(mContext), "handlerACKMessageRetuen", "msgids=" + msgDO.msgIds + ",removePacks=" + msgDO.removePacks + ",errorCode=" + msgDO.errorCode);
            return;
        }
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("api", "agooAck");
            hashMap.put("id", msgDO.msgIds + "@" + msgDO.messageSource);
            if (!TextUtils.isEmpty((CharSequence)msgDO.removePacks)) {
                hashMap.put("del_pack", msgDO.removePacks);
            }
            if (!TextUtils.isEmpty((CharSequence)msgDO.errorCode)) {
                hashMap.put("ec", msgDO.errorCode);
            }
            if (!TextUtils.isEmpty((CharSequence)msgDO.type)) {
                hashMap.put("type", msgDO.type);
            }
            if (!TextUtils.isEmpty((CharSequence)msgDO.extData)) {
                hashMap.put("ext", msgDO.extData);
            }
            hashMap.put("appkey", org.android.agoo.common.b.a(mContext));
            hashMap.put("utdid", a.b(mContext));
            JSONObject jSONObject = new JSONObject(hashMap);
            byte[] byArray = jSONObject.toString().getBytes("UTF-8");
            UTMini.getInstance().commitEvent(66002, ACK_MESSAGE, a.b(mContext), "handlerACKMessageSendData", msgDO.msgIds);
            b.a("accs", "agoo_ack", "handlerACKMessage", 0.0);
            ACCSManager.AccsRequest accsRequest = new ACCSManager.AccsRequest(null, "agooAck", byArray, null, null, null, null);
            if (msgDO != null) {
                accsRequest.setTag(msgDO.msgIds);
            }
            String string = ACCSManager.getAccsInstance(mContext, org.android.agoo.common.b.a(mContext)).sendPushResponse(mContext, accsRequest, extraInfo);
            ALog.i(TAG, "handlerACKMessage,endRequest,dataId=" + string, new Object[0]);
        }
        catch (Throwable throwable) {
            if (ALog.isPrintLog(ALog.Level.E)) {
                ALog.e(TAG, "handlerACKMessage Throwable,msgIds=" + msgDO.msgIds + ",type=" + msgDO.type + ",e=" + throwable.toString(), new Object[0]);
            }
            UTMini.getInstance().commitEvent(66002, ACK_MESSAGE, a.b(mContext), "handlerACKMessageExceptionFailed", throwable.toString());
        }
    }

    public void report(MsgDO msgDO, TaoBaseService.ExtraInfo extraInfo) {
        if (!TextUtils.isEmpty((CharSequence)msgDO.reportStr)) {
            int n2 = 0;
            try {
                n2 = Integer.parseInt(msgDO.reportStr);
                if (n2 >= -1) {
                    this.reportMethod(msgDO, extraInfo);
                    if (!msgDO.isFromCache) {
                        b.a("accs", "agoo_ack", msgDO.msgStatus, 0.0);
                    }
                }
            }
            catch (Throwable throwable) {
                ALog.e(TAG, "[report] is error", throwable, new Object[0]);
            }
        }
    }

    public void reportNotifyMessage(MsgDO msgDO) {
        try {
            if (msgDO != null) {
                b.a("accs", "agoo_report_id", msgDO.msgIds, 0.0);
                byte[] byArray = this.convertMsgToBytes(msgDO);
                ACCSManager.AccsRequest accsRequest = new ACCSManager.AccsRequest(null, "agooAck", byArray, null, null, null, null);
                String string = ACCSManager.getAccsInstance(mContext, org.android.agoo.common.b.a(mContext)).sendRequest(mContext, accsRequest);
                if (ALog.isPrintLog(ALog.Level.E)) {
                    ALog.e(TAG, "reportNotifyMessage", "dataId", string, "status", msgDO.msgStatus);
                }
                b.a("accs", "agoo_click", msgDO.msgStatus, 0.0);
                b.a("accs", "agoo_ack", msgDO.msgStatus, 0.0);
            }
        }
        catch (Throwable throwable) {
            ALog.e(TAG, "[reportNotifyMessage] is error", throwable, new Object[0]);
            UTMini.getInstance().commitEvent(66002, "reportMethod", a.b(mContext), throwable.toString());
        }
    }

    private byte[] convertMsgToBytes(MsgDO msgDO) throws UnsupportedEncodingException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("api", "agooReport");
        hashMap.put("id", msgDO.msgIds + "@" + msgDO.messageSource);
        hashMap.put("ext", msgDO.extData);
        hashMap.put("status", msgDO.msgStatus);
        if (!TextUtils.isEmpty((CharSequence)msgDO.errorCode)) {
            hashMap.put("ec", msgDO.errorCode);
        }
        if (!TextUtils.isEmpty((CharSequence)msgDO.type)) {
            hashMap.put("type", msgDO.type);
        }
        if (!TextUtils.isEmpty((CharSequence)msgDO.fromPkg)) {
            hashMap.put("fromPkg", msgDO.fromPkg);
        }
        if (!TextUtils.isEmpty((CharSequence)msgDO.fromAppkey)) {
            hashMap.put("fromAppkey", msgDO.fromAppkey);
        }
        if (!TextUtils.isEmpty((CharSequence)msgDO.notifyEnable)) {
            hashMap.put("notifyEnable", msgDO.notifyEnable);
        }
        if (!TextUtils.isEmpty((CharSequence)msgDO.extData)) {
            hashMap.put("ext", msgDO.extData);
        }
        hashMap.put("isStartProc", Boolean.toString(msgDO.isStartProc));
        hashMap.put("appkey", org.android.agoo.common.b.a(mContext));
        hashMap.put("utdid", a.b(mContext));
        JSONObject jSONObject = new JSONObject(hashMap);
        byte[] byArray = jSONObject.toString().getBytes("UTF-8");
        return byArray;
    }

    private void reportMethod(MsgDO msgDO, TaoBaseService.ExtraInfo extraInfo) {
        try {
            byte[] byArray = this.convertMsgToBytes(msgDO);
            ACCSManager.AccsRequest accsRequest = new ACCSManager.AccsRequest(null, "agooAck", byArray, null, null, null, null);
            if (msgDO != null) {
                accsRequest.setTag(msgDO.msgIds);
            }
            String string = ACCSManager.getAccsInstance(mContext, org.android.agoo.common.b.a(mContext)).sendPushResponse(mContext, accsRequest, extraInfo);
            if (ALog.isPrintLog(ALog.Level.E)) {
                ALog.e(TAG, "report", "dataId", string, "status", msgDO.msgStatus, "errorcode", msgDO.errorCode);
            }
        }
        catch (Throwable throwable) {
            UTMini.getInstance().commitEvent(66002, "reportMethod", a.b(mContext), throwable.toString());
        }
    }

    public void reportThirdPushToken(String string, String string2, boolean bl) {
        block3: {
            try {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("thirdTokenType", string2);
                hashMap.put("token", string);
                hashMap.put("appkey", org.android.agoo.common.b.a(mContext));
                hashMap.put("utdid", a.b(mContext));
                ALog.d(TAG, "report,utdid=" + a.b(mContext) + ",regId=" + string + ",type=" + string2, new Object[0]);
                JSONObject jSONObject = new JSONObject(hashMap);
                byte[] byArray = jSONObject.toString().getBytes("UTF-8");
                ACCSManager.AccsRequest accsRequest = new ACCSManager.AccsRequest(null, "agooTokenReport", byArray, null, null, null, null);
                IACCSManager iACCSManager = ACCSManager.getAccsInstance(mContext, org.android.agoo.common.b.a(mContext));
                String string3 = bl ? iACCSManager.sendData(mContext, accsRequest) : iACCSManager.sendPushResponse(mContext, accsRequest, new TaoBaseService.ExtraInfo());
                if (ALog.isPrintLog(ALog.Level.D)) {
                    ALog.i(TAG, "reportThirdPushToken,dataId=" + string3 + ",regId=" + string + ",type=" + string2, new Object[0]);
                }
            }
            catch (Throwable throwable) {
                UTMini.getInstance().commitEvent(66002, "reportThirdPushToken", a.b(mContext), throwable.toString());
                if (!ALog.isPrintLog(ALog.Level.E)) break block3;
                ALog.e(TAG, "[report] is error", throwable, new Object[0]);
            }
        }
    }

    public void reportThirdPushToken(String string, String string2) {
        this.reportThirdPushToken(string, string2, true);
    }

    public void doUninstall(String string, boolean bl) {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("pack", string);
            hashMap.put("appkey", org.android.agoo.common.b.a(mContext));
            hashMap.put("utdid", a.b(mContext));
            JSONObject jSONObject = new JSONObject(hashMap);
            byte[] byArray = jSONObject.toString().getBytes("UTF-8");
            ACCSManager.AccsRequest accsRequest = new ACCSManager.AccsRequest(null, "agooKick", byArray, null, null, null, null);
            ACCSManager.getAccsInstance(mContext, org.android.agoo.common.b.a(mContext)).sendPushResponse(mContext, accsRequest, new TaoBaseService.ExtraInfo());
        }
        catch (Throwable throwable) {
            ALog.e(TAG, "[doUninstall] is error", throwable, new Object[0]);
        }
    }

    public void pingApp(String string, String string2, String string3, int n2) {
        if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2) || TextUtils.isEmpty((CharSequence)string3)) {
            return;
        }
        if (ALog.isPrintLog(ALog.Level.I)) {
            ALog.i(TAG, "pingApp [print param],percent=" + n2 + ",pack=" + string2 + ",service=" + string3 + ",action=" + string, new Object[0]);
        }
        this.mThreadPool.execute(new g(this, n2, string2, string, string3));
    }

    private boolean isAppInstalled(String string) {
        PackageInfo packageInfo;
        try {
            if (TextUtils.isEmpty((CharSequence)string)) {
                return false;
            }
            packageInfo = mContext.getPackageManager().getPackageInfo(string, 0);
        }
        catch (Throwable throwable) {
            packageInfo = null;
        }
        if (packageInfo == null) {
            return false;
        }
        ALog.i(TAG, "isAppInstalled true..", new Object[0]);
        return true;
    }

    private String getVersion(String string) {
        try {
            if (TextUtils.isEmpty((CharSequence)string)) {
                return "null";
            }
            PackageManager packageManager = mContext.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(string, 0);
            String string2 = packageInfo.versionName;
            ALog.d(TAG, "getVersion###\u7248\u672c\u53f7\u4e3a : " + string2, new Object[0]);
            return string2;
        }
        catch (Throwable throwable) {
            return "null";
        }
    }

    static /* synthetic */ Context access$000() {
        return mContext;
    }

    static /* synthetic */ boolean access$100(NotifManager notifManager, String string) {
        return notifManager.isAppInstalled(string);
    }

    static /* synthetic */ String access$200(NotifManager notifManager, String string) {
        return notifManager.getVersion(string);
    }
}

