/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.message.common;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Configuration;
import android.location.Location;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.ta.utdid2.device.UTDevice;
import com.umeng.message.MessageSharedPrefs;
import com.umeng.message.UTrack;
import com.umeng.message.common.UmLog;
import com.umeng.message.proguard.h;
import com.umeng.message.util.a;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.NetworkInterface;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.microedition.khronos.opengles.GL10;
import org.json.JSONException;
import org.json.JSONObject;

public class UmengMessageDeviceConfig {
    private static final String b = UmengMessageDeviceConfig.class.getSimpleName();
    protected static final String a = "Unknown";
    private static final String c = "2G/3G";
    private static final String d = "Wi-Fi";
    public static final int DEFAULT_TIMEZONE = 8;
    private static boolean e = false;

    public static boolean isAppInstalled(String string, Context context) {
        PackageManager packageManager = context.getPackageManager();
        boolean bl = false;
        try {
            packageManager.getPackageInfo(string, 1);
            bl = true;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            bl = false;
        }
        return bl;
    }

    public static boolean isChinese(Context context) {
        Locale locale = context.getResources().getConfiguration().locale;
        return locale.toString().equals(Locale.CHINA.toString());
    }

    public static boolean isScreenPortrait(Context context) {
        return context.getResources().getConfiguration().orientation == 1;
    }

    public static String getAppVersionCode(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            int n2 = packageInfo.versionCode;
            return String.valueOf(n2);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return a;
        }
    }

    public static String getAppVersionName(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return a;
        }
    }

    public static boolean checkPermission(Context context, String string) {
        PackageManager packageManager = context.getPackageManager();
        return packageManager.checkPermission(string, context.getPackageName()) == 0;
    }

    public static String getAppLabel(Context context) {
        ApplicationInfo applicationInfo;
        PackageManager packageManager = context.getPackageManager();
        try {
            applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            applicationInfo = null;
        }
        String string = applicationInfo != null ? packageManager.getApplicationLabel(applicationInfo) : "";
        return string;
    }

    public static String[] getGPU(GL10 gL10) {
        try {
            String[] stringArray = new String[2];
            String string = gL10.glGetString(7936);
            String string2 = gL10.glGetString(7937);
            stringArray[0] = string;
            stringArray[1] = string2;
            return stringArray;
        }
        catch (Exception exception) {
            UmLog.e(b, "Could not read gpu infor:", exception);
            return new String[0];
        }
    }

    public static String getCPU() {
        String string = null;
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        try {
            fileReader = new FileReader("/proc/cpuinfo");
            if (fileReader != null) {
                try {
                    bufferedReader = new BufferedReader(fileReader, 1024);
                    string = bufferedReader.readLine();
                    bufferedReader.close();
                    fileReader.close();
                }
                catch (IOException iOException) {
                    UmLog.e(b, "Could not read from file /proc/cpuinfo", iOException);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            UmLog.e(b, "Could not open file /proc/cpuinfo", fileNotFoundException);
        }
        if (string != null) {
            int n2 = string.indexOf(58) + 1;
            string = string.substring(n2).trim();
        }
        return string;
    }

    public static String getDeviceId(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager == null) {
            UmLog.w(b, "No IMEI.");
        }
        String string = "";
        try {
            if (UmengMessageDeviceConfig.checkPermission(context, "android.permission.READ_PHONE_STATE")) {
                string = telephonyManager.getDeviceId();
            }
        }
        catch (Exception exception) {
            UmLog.w(b, "No IMEI.", exception);
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            UmLog.w(b, "No IMEI.");
            string = UmengMessageDeviceConfig.getMac(context);
            if (TextUtils.isEmpty((CharSequence)string)) {
                UmLog.w(b, "Failed to take mac as IMEI. Try to use Secure.ANDROID_ID instead.");
                string = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
                UmLog.i(b, "getDeviceId: Secure.ANDROID_ID: " + string);
                if (TextUtils.isEmpty((CharSequence)string)) {
                    UmLog.w(b, "Failed to take Secure.ANDROID_ID as IMEI. Try to use Serial_number instead.");
                    string = UmengMessageDeviceConfig.getSerial_number();
                    UmLog.i(b, "getDeviceId: Serial_number: " + string);
                    return string;
                }
            }
        }
        return string;
    }

    public static String getDIN(Context context) {
        String string = "";
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager == null) {
            UmLog.w(b, "No IMEI.");
        }
        try {
            if (UmengMessageDeviceConfig.checkPermission(context, "android.permission.READ_PHONE_STATE") && !TextUtils.isEmpty((CharSequence)(string = telephonyManager.getDeviceId()))) {
                return string;
            }
        }
        catch (Exception exception) {
            UmLog.w(b, "No IMEI.", exception);
        }
        return "";
    }

    public static String getAndroidId(Context context) {
        String string = Settings.System.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        if (string == null) {
            string = "";
        }
        return string;
    }

    public static String getSerial_number() {
        String string = Build.SERIAL;
        if (string == null) {
            string = "";
        }
        return string;
    }

    public static String getDeviceIdUmengMD5(Context context) {
        return h.b(UmengMessageDeviceConfig.getDeviceId(context));
    }

    public static String getDeviceIdMD5(Context context) {
        return h.a(UmengMessageDeviceConfig.getDeviceId(context));
    }

    public static String getNetworkOperatorName(Context context) {
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            if (telephonyManager == null) {
                return a;
            }
            return telephonyManager.getNetworkOperatorName();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return a;
        }
    }

    public static String getDisplayResolution(Context context) {
        try {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            windowManager.getDefaultDisplay().getMetrics(displayMetrics);
            int n2 = displayMetrics.widthPixels;
            int n3 = displayMetrics.heightPixels;
            String string = String.valueOf(n3) + "*" + String.valueOf(n2);
            return string;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return a;
        }
    }

    public static String[] getNetworkAccessMode(Context context) {
        String[] stringArray = new String[]{a, a};
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (connectivityManager == null) {
                return stringArray;
            }
            NetworkInfo networkInfo = connectivityManager.getNetworkInfo(1);
            if (networkInfo != null && networkInfo.getState() == NetworkInfo.State.CONNECTED) {
                stringArray[0] = d;
                return stringArray;
            }
            NetworkInfo networkInfo2 = connectivityManager.getNetworkInfo(0);
            if (networkInfo2 != null && networkInfo2.getState() == NetworkInfo.State.CONNECTED) {
                stringArray[0] = c;
                stringArray[1] = networkInfo2.getSubtypeName();
                return stringArray;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringArray;
    }

    public static boolean isWiFiAvailable(Context context) {
        return d.equals(UmengMessageDeviceConfig.getNetworkAccessMode(context)[0]);
    }

    public static Location getLocation(Context context) {
        LocationManager locationManager = null;
        try {
            Location location;
            locationManager = (LocationManager)context.getSystemService("location");
            if (UmengMessageDeviceConfig.checkPermission(context, "android.permission.ACCESS_FINE_LOCATION") && (location = locationManager.getLastKnownLocation("gps")) != null) {
                UmLog.d(b, "get location from gps:" + location.getLatitude() + "," + location.getLongitude());
                return location;
            }
            if (UmengMessageDeviceConfig.checkPermission(context, "android.permission.ACCESS_COARSE_LOCATION") && (location = locationManager.getLastKnownLocation("network")) != null) {
                UmLog.d(b, "get location from network:" + location.getLatitude() + "," + location.getLongitude());
                return location;
            }
            UmLog.d(b, "Could not get location from GPS or Cell-id, lack ACCESS_COARSE_LOCATION or ACCESS_COARSE_LOCATION permission?");
            return null;
        }
        catch (Exception exception) {
            UmLog.e(b, exception.getMessage());
            return null;
        }
    }

    public static boolean isOnline(Context context) {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null) {
                return networkInfo.isConnectedOrConnecting();
            }
            return false;
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static boolean isSdCardWrittenable() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    public static int getTimeZone(Context context) {
        try {
            Locale locale = UmengMessageDeviceConfig.a(context);
            Calendar calendar = Calendar.getInstance(locale);
            if (calendar != null) {
                return calendar.getTimeZone().getRawOffset() / 3600000;
            }
        }
        catch (Exception exception) {
            UmLog.i(b, "error in getTimeZone", exception);
        }
        return 8;
    }

    public static String[] getLocaleInfo(Context context) {
        String[] stringArray = new String[2];
        try {
            Locale locale = UmengMessageDeviceConfig.a(context);
            if (locale != null) {
                stringArray[0] = locale.getCountry();
                stringArray[1] = locale.getLanguage();
            }
            if (TextUtils.isEmpty((CharSequence)stringArray[0])) {
                stringArray[0] = a;
            }
            if (TextUtils.isEmpty((CharSequence)stringArray[1])) {
                stringArray[1] = a;
            }
            return stringArray;
        }
        catch (Exception exception) {
            UmLog.e(b, "error in getLocaleInfo", exception);
            return stringArray;
        }
    }

    private static Locale a(Context context) {
        Locale locale = null;
        try {
            Configuration configuration = new Configuration();
            Settings.System.getConfiguration((ContentResolver)context.getContentResolver(), (Configuration)configuration);
            if (configuration != null) {
                locale = configuration.locale;
            }
        }
        catch (Exception exception) {
            UmLog.e(b, "fail to read user config locale");
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public static String getAppkey(Context context) {
        return UmengMessageDeviceConfig.getMetaData(context, "UMENG_APPKEY");
    }

    public static String getMetaData(Context context, String string) {
        try {
            String string2;
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128);
            if (applicationInfo != null && (string2 = applicationInfo.metaData.getString(string)) != null) {
                return string2.trim();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        UmLog.e(b, String.format("Could not read meta-data %s from AndroidManifest.xml.", string));
        return null;
    }

    public static String getMac(Context context) {
        if (Build.VERSION.SDK_INT <= 22) {
            try {
                WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
                if (UmengMessageDeviceConfig.checkPermission(context, "android.permission.ACCESS_WIFI_STATE")) {
                    WifiInfo wifiInfo = wifiManager.getConnectionInfo();
                    return wifiInfo.getMacAddress();
                }
                UmLog.w(b, "Could not get mac address.[no permission android.permission.ACCESS_WIFI_STATE");
            }
            catch (Exception exception) {
                UmLog.w(b, "Could not get mac address." + exception.toString());
            }
        } else {
            try {
                ArrayList<NetworkInterface> arrayList = Collections.list(NetworkInterface.getNetworkInterfaces());
                for (NetworkInterface networkInterface : arrayList) {
                    if (!networkInterface.getName().equalsIgnoreCase("wlan0")) continue;
                    byte[] byArray = networkInterface.getHardwareAddress();
                    if (byArray == null) {
                        return "";
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    for (byte by : byArray) {
                        stringBuilder.append(String.format("%02X:", by));
                    }
                    if (stringBuilder.length() > 0) {
                        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                    }
                    return stringBuilder.toString();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return "";
    }

    public static String getUmid(final Context context) {
        String string = MessageSharedPrefs.getInstance(context).getUmid();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        if (!e) {
            e = true;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    String string = "";
                    try {
                        FileInputStream fileInputStream = context.openFileInput("exid.dat");
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        byte[] byArray = new byte[1024];
                        while (fileInputStream.read(byArray) != -1) {
                            byteArrayOutputStream.write(byArray, 0, byArray.length);
                        }
                        String string2 = new String(byteArrayOutputStream.toByteArray());
                        fileInputStream.close();
                        byteArrayOutputStream.close();
                        JSONObject jSONObject = new JSONObject(string2);
                        string = jSONObject.optString("umid", "");
                        if (!TextUtils.isEmpty((CharSequence)string)) {
                            MessageSharedPrefs.getInstance(context).setUmid(string);
                            UTrack.getInstance(context).updateHeader();
                        }
                    }
                    catch (IOException | JSONException throwable) {
                        UmLog.i(b, "no umid");
                    }
                }
            }).start();
        }
        return "";
    }

    public static String getResolution(Context context) {
        try {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            windowManager.getDefaultDisplay().getMetrics(displayMetrics);
            int n2 = -1;
            int n3 = -1;
            if ((context.getApplicationInfo().flags & 0x2000) == 0) {
                n2 = UmengMessageDeviceConfig.a(displayMetrics, "noncompatWidthPixels");
                n3 = UmengMessageDeviceConfig.a(displayMetrics, "noncompatHeightPixels");
            }
            if (n2 == -1 || n3 == -1) {
                n2 = displayMetrics.widthPixels;
                n3 = displayMetrics.heightPixels;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(n2);
            stringBuffer.append("*");
            stringBuffer.append(n3);
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            UmLog.e(b, "read resolution fail", exception);
            return a;
        }
    }

    private static int a(Object object, String string) {
        try {
            Field field = DisplayMetrics.class.getDeclaredField(string);
            if (field != null) {
                field.setAccessible(true);
                return field.getInt(object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return -1;
    }

    public static String getOperator(Context context) {
        try {
            return ((TelephonyManager)context.getSystemService("phone")).getNetworkOperatorName();
        }
        catch (Exception exception) {
            UmLog.i(b, "read carrier fail", exception);
            return a;
        }
    }

    public static String getTimeString(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
        String string = simpleDateFormat.format(date);
        return string;
    }

    public static String getToday() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
        String string = simpleDateFormat.format(date);
        return string;
    }

    public static Date toTime(String string) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = simpleDateFormat.parse(string);
            return date;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static int getIntervalSeconds(Date date, Date date2) {
        if (date.after(date2)) {
            Date date3 = date;
            date = date2;
            date2 = date3;
        }
        long l2 = date.getTime();
        long l3 = date2.getTime();
        long l4 = l3 - l2;
        return (int)(l4 / 1000L);
    }

    public static String getChannel(Context context) {
        String string = a;
        try {
            Object object;
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128);
            if (applicationInfo != null && applicationInfo.metaData != null && (object = applicationInfo.metaData.get("UMENG_CHANNEL")) != null) {
                String string2 = object.toString();
                if (string2 != null) {
                    string = string2;
                } else {
                    UmLog.i(b, "Could not read UMENG_CHANNEL meta-data from AndroidManifest.xml.");
                }
            }
        }
        catch (Exception exception) {
            UmLog.i(b, "Could not read UMENG_CHANNEL meta-data from AndroidManifest.xml.");
            exception.printStackTrace();
        }
        return string;
    }

    public static String getPackageName(Context context) {
        return context.getPackageName();
    }

    public static String getApplicationLable(Context context) {
        return context.getPackageManager().getApplicationLabel(context.getApplicationInfo()).toString();
    }

    public static boolean isDebug(Context context) {
        try {
            return (context.getApplicationInfo().flags & 2) != 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String getUtdid(Context context) {
        try {
            return UTDevice.getUtdid((Context)context);
        }
        catch (Throwable throwable) {
            UmLog.e(b, "fail to get utdid. " + throwable.getMessage());
            return "";
        }
    }

    public static boolean isServiceWork(Context context, String string, String string2) {
        boolean bl = false;
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List list = activityManager.getRunningServices(Integer.MAX_VALUE);
        if (list.size() <= 0) {
            return false;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String string3 = ((ActivityManager.RunningServiceInfo)list.get((int)i2)).service.getClassName().toString();
            String string4 = ((ActivityManager.RunningServiceInfo)list.get((int)i2)).service.getPackageName().toString();
            if (!string3.equals(string) || !string4.equals(string2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean isIntentExist(Context context, String string, String string2) {
        Intent intent;
        boolean bl = false;
        PackageManager packageManager = context.getPackageManager();
        List list = packageManager.queryIntentActivities(intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string)), 0);
        if (!list.isEmpty()) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                if (!((ResolveInfo)list.get((int)i2)).activityInfo.packageName.equalsIgnoreCase(string2)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static boolean getDataData(String string) {
        File file = null;
        boolean bl = false;
        file = new File("/data/app/" + string + "-1.apk");
        bl = file.exists();
        if (!bl) {
            file = new File("/data/app/" + string + "-2.apk");
            bl = file.exists();
        }
        if (!bl) {
            file = new File("/data/app/" + string + ".apk");
            bl = file.exists();
        }
        if (!bl) {
            file = new File("/data/app/" + string + "-1");
            bl = file.exists();
        }
        if (!bl) {
            file = new File("/data/app/" + string + "-2");
            bl = file.exists();
        }
        return bl;
    }

    public static boolean isMIUI() {
        String string = "ro.miui.ui.version.code";
        String string2 = "ro.miui.ui.version.name";
        String string3 = "ro.miui.internal.storage";
        try {
            a a2 = com.umeng.message.util.a.g();
            return a2.a("ro.miui.ui.version.code", null) != null || a2.a("ro.miui.ui.version.name", null) != null || a2.a("ro.miui.internal.storage", null) != null;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean isMiui8() {
        boolean bl;
        block3: {
            bl = false;
            try {
                a a2 = com.umeng.message.util.a.g();
                String string = a2.a("ro.miui.ui.version.name");
                if (string != null && string.contains("8")) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                if (exception == null) break block3;
                exception.printStackTrace();
            }
        }
        return bl;
    }
}

