/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tlog.adapter;

import android.taobao.windvane.jsbridge.WVApiPlugin;
import android.taobao.windvane.jsbridge.WVCallBackContext;
import android.taobao.windvane.jsbridge.WVPluginManager;
import android.text.TextUtils;
import com.taobao.tlog.adapter.AdapterForTLog;
import org.json.JSONException;
import org.json.JSONObject;

public class JSLogBridge
extends WVApiPlugin {
    private static final String LOGV = "logv";
    private static final String LOGD = "logd";
    private static final String LOGI = "logi";
    private static final String LOGW = "logw";
    private static final String LOGE = "loge";
    private static final String GETLOGLEVEL = "getLogLevel";
    private static final String tlogBridgeName = "tlogBridge";

    public static void init() {
        WVPluginManager.registerPlugin((String)tlogBridgeName, JSLogBridge.class, (boolean)true);
    }

    public boolean execute(String string, String string2, WVCallBackContext wVCallBackContext) {
        if (!TextUtils.isEmpty((CharSequence)string) && wVCallBackContext != null) {
            if (GETLOGLEVEL.equals(string)) {
                wVCallBackContext.success(AdapterForTLog.getLogLevel());
            } else if (LOGV.equals(string)) {
                this.logv(string2, wVCallBackContext);
            } else if (LOGD.equals(string)) {
                this.logd(string2, wVCallBackContext);
            } else if (LOGI.equals(string)) {
                this.logi(string2, wVCallBackContext);
            } else if (LOGW.equals(string)) {
                this.logw(string2, wVCallBackContext);
            } else if (LOGE.equals(string)) {
                this.loge(string2, wVCallBackContext);
            } else {
                return false;
            }
            return true;
        }
        return false;
    }

    public void logv(String string, WVCallBackContext wVCallBackContext) {
        LogBody logBody = this.getLog(string);
        if (logBody != null) {
            AdapterForTLog.logv(logBody.tag, string);
            wVCallBackContext.success();
        } else {
            wVCallBackContext.error("the tag is null!");
        }
    }

    public void logd(String string, WVCallBackContext wVCallBackContext) {
        LogBody logBody = this.getLog(string);
        if (logBody != null) {
            AdapterForTLog.logd(logBody.tag, string);
            wVCallBackContext.success();
        } else {
            wVCallBackContext.error("the tag is null!");
        }
    }

    public void logi(String string, WVCallBackContext wVCallBackContext) {
        LogBody logBody = this.getLog(string);
        if (logBody != null) {
            AdapterForTLog.logi(logBody.tag, string);
            wVCallBackContext.success();
        } else {
            wVCallBackContext.error("the tag is null!");
        }
    }

    public void logw(String string, WVCallBackContext wVCallBackContext) {
        LogBody logBody = this.getLog(string);
        if (logBody != null) {
            AdapterForTLog.logw(logBody.tag, string);
            wVCallBackContext.success();
        } else {
            wVCallBackContext.error("the tag is null!");
        }
    }

    public void loge(String string, WVCallBackContext wVCallBackContext) {
        LogBody logBody = this.getLog(string);
        if (logBody != null) {
            AdapterForTLog.loge(logBody.tag, string);
            wVCallBackContext.success();
        } else {
            wVCallBackContext.error("the tag is null!");
        }
    }

    private LogBody getLog(String string) {
        try {
            LogBody logBody = new LogBody();
            JSONObject jSONObject = new JSONObject(string);
            logBody.tag = jSONObject.optString("tag", "jsTag");
            logBody.data = jSONObject.optString("content", "");
            return logBody;
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    class LogBody {
        String tag;
        String module;
        String data;

        LogBody() {
        }
    }
}

