/*
 * Decompiled with CFR 0.152.
 */
package anetwork.channel.unified;

import android.content.Context;
import android.os.RemoteException;
import anet.channel.a.a;
import anet.channel.a.b;
import anet.channel.util.ALog;
import anetwork.channel.aidl.Connection;
import anetwork.channel.aidl.NetworkResponse;
import anetwork.channel.aidl.ParcelableFuture;
import anetwork.channel.aidl.ParcelableInputStream;
import anetwork.channel.aidl.ParcelableNetworkListener;
import anetwork.channel.aidl.ParcelableRequest;
import anetwork.channel.aidl.RemoteNetwork;
import anetwork.channel.aidl.adapter.ConnectionDelegate;
import anetwork.channel.aidl.adapter.ParcelableFutureResponse;
import anetwork.channel.aidl.adapter.ParcelableNetworkListenerWrapper;
import anetwork.channel.entity.Repeater;
import anetwork.channel.entity.RequestConfig;
import anetwork.channel.http.NetworkSdkSetting;
import anetwork.channel.unified.UnifiedRequestTask;
import java.io.ByteArrayOutputStream;

public abstract class UnifiedNetworkDelegate
extends RemoteNetwork.Stub {
    public static final int HTTP = 0;
    public static final int DEGRADABLE = 1;
    private static final String TAG = "anet.UnifiedNetworkDelegate";
    protected int type = 1;

    public UnifiedNetworkDelegate(Context context) {
        NetworkSdkSetting.init(context);
    }

    @Override
    public NetworkResponse syncSend(ParcelableRequest parcelableRequest) throws RemoteException {
        return this.convertToSync(parcelableRequest);
    }

    @Override
    public ParcelableFuture asyncSend(ParcelableRequest parcelableRequest, ParcelableNetworkListener parcelableNetworkListener) throws RemoteException {
        try {
            return this.asyncSend(new RequestConfig(parcelableRequest, this.type), parcelableNetworkListener);
        }
        catch (Exception exception) {
            ALog.e(TAG, "asyncSend failed", parcelableRequest.getSeqNo(), exception, new Object[0]);
            throw new RemoteException(exception.getMessage());
        }
    }

    private ParcelableFuture asyncSend(RequestConfig requestConfig, ParcelableNetworkListener parcelableNetworkListener) throws RemoteException {
        UnifiedRequestTask unifiedRequestTask = new UnifiedRequestTask(requestConfig, new Repeater(parcelableNetworkListener, requestConfig));
        return new ParcelableFutureResponse(unifiedRequestTask.request());
    }

    @Override
    public Connection getConnection(ParcelableRequest parcelableRequest) throws RemoteException {
        try {
            RequestConfig requestConfig = new RequestConfig(parcelableRequest, this.type);
            ConnectionDelegate connectionDelegate = new ConnectionDelegate(requestConfig);
            ParcelableNetworkListenerWrapper parcelableNetworkListenerWrapper = new ParcelableNetworkListenerWrapper(connectionDelegate, null, null);
            connectionDelegate.setFuture(this.asyncSend(requestConfig, (ParcelableNetworkListener)parcelableNetworkListenerWrapper));
            return connectionDelegate;
        }
        catch (Exception exception) {
            ALog.e(TAG, "asyncSend failed", parcelableRequest.getSeqNo(), exception, new Object[0]);
            throw new RemoteException(exception.getMessage());
        }
    }

    private NetworkResponse convertToSync(ParcelableRequest parcelableRequest) {
        NetworkResponse networkResponse = new NetworkResponse();
        try {
            ConnectionDelegate connectionDelegate = (ConnectionDelegate)this.getConnection(parcelableRequest);
            networkResponse.setStatusCode(connectionDelegate.getStatusCode());
            networkResponse.setConnHeadFields(connectionDelegate.getConnHeadFields());
            ParcelableInputStream parcelableInputStream = connectionDelegate.getInputStream();
            if (parcelableInputStream != null) {
                int n2;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(connectionDelegate.getInputStream().length());
                a a2 = b.a.a.a(2048);
                while ((n2 = parcelableInputStream.read(a2.a())) != -1) {
                    byteArrayOutputStream.write(a2.a(), 0, n2);
                }
                networkResponse.setBytedata(byteArrayOutputStream.toByteArray());
                networkResponse.setStatisticData(connectionDelegate.getStatisticData());
            }
            return networkResponse;
        }
        catch (RemoteException remoteException) {
            networkResponse.setStatusCode(-103);
        }
        catch (Exception exception) {
            networkResponse.setStatusCode(-201);
        }
        return networkResponse;
    }
}

