/*
 * Decompiled with CFR 0.152.
 */
package anetwork.channel.stat;

import anet.channel.util.StringUtils;
import anetwork.channel.stat.INetworkStat;
import anetwork.channel.statist.StatisticData;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

class NetworkStatCache
implements INetworkStat {
    private static final int MAX_SIZE = 100;
    private Map<String, String> lruCache = Collections.synchronizedMap(new LinkedHashMap<String, String>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, String> entry) {
            return this.size() > 100;
        }
    });
    private static final String RESET_STAT = "{\"oneWayTime\" : 0, \"totalSize\" : 0}";

    public static NetworkStatCache getInstance() {
        return holder.instance;
    }

    private NetworkStatCache() {
    }

    @Override
    public void put(String string, StatisticData statisticData) {
        if (StringUtils.isBlank(string)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(48);
        stringBuilder.append("{\"oneWayTime\" : ").append(statisticData.oneWayTime_ANet).append(", \"totalSize\" : ").append(statisticData.totalSize).append("}");
        this.lruCache.put(string, stringBuilder.toString());
    }

    @Override
    public void reset(String string) {
        if (this.lruCache.containsKey(string)) {
            this.lruCache.put(string, RESET_STAT);
        }
    }

    @Override
    public String get(String string) {
        return this.lruCache.get(string);
    }

    private static class holder {
        public static NetworkStatCache instance = new NetworkStatCache();

        private holder() {
        }
    }
}

