/*
 * Decompiled with CFR 0.152.
 */
package anetwork.channel.download;

import android.content.Context;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.SparseArray;
import anet.channel.util.ALog;
import anet.channel.util.StringUtils;
import anet.channel.util.c;
import anetwork.channel.Header;
import anetwork.channel.aidl.Connection;
import anetwork.channel.http.NetworkSdkSetting;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class DownloadManager {
    public static final String TAG = "ANet.DownloadManager";
    private static final String DOWNLOAD_FOLDER = "downloads";
    public static final int ERROR_URL_INVALID = -100;
    public static final int ERROR_FILE_FOLDER_INVALID = -101;
    public static final int ERROR_REQUEST_FAIL = -102;
    public static final int ERROR_IO_EXCEPTION = -103;
    public static final int ERROR_EXCEPTION_HAPPEN = -104;
    public static final int ERROR_DOWNLOAD_CANCELLED = -105;
    private SparseArray<DownloadTask> taskMap = new SparseArray(6);
    private AtomicInteger taskIdGen = new AtomicInteger(0);
    private ThreadPoolExecutor executor = new ThreadPoolExecutor(2, 2, 30L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>());
    private Context context = NetworkSdkSetting.getContext();

    public static DownloadManager getInstance() {
        return ClassHolder.instance;
    }

    private DownloadManager() {
        this.executor.allowCoreThreadTimeOut(true);
        this.prepareDownloadFolder();
    }

    public int enqueue(String string, String string2, DownloadListener downloadListener) {
        return this.enqueue(string, null, string2, downloadListener);
    }

    public int enqueue(String string, String string2, String string3, DownloadListener downloadListener) {
        if (ALog.isPrintLog(2)) {
            ALog.i(TAG, "enqueue", null, "folder", string2, "filename", string3, "url", string);
        }
        if (this.context == null) {
            ALog.e(TAG, "network not initial.", null, new Object[0]);
            return -1;
        }
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            ALog.e(TAG, "url invalid.", null, malformedURLException, new Object[0]);
            if (downloadListener != null) {
                downloadListener.onFail(-1, -100, "url invalid");
            }
            return -1;
        }
        if (!TextUtils.isEmpty((CharSequence)string2) && !this.prepareFolder(string2)) {
            ALog.e(TAG, "file folder invalid.", null, new Object[0]);
            if (downloadListener != null) {
                downloadListener.onFail(-1, -101, "file folder path invalid");
            }
            return -1;
        }
        SparseArray<DownloadTask> sparseArray = this.taskMap;
        synchronized (sparseArray) {
            int n2 = this.taskMap.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                DownloadTask downloadTask = (DownloadTask)this.taskMap.valueAt(i2);
                if (!uRL.equals(downloadTask.url)) continue;
                if (!downloadTask.attachListener(downloadListener)) break;
                return downloadTask.taskId;
            }
            DownloadTask downloadTask = new DownloadTask(uRL, string2, string3, downloadListener);
            this.taskMap.put(downloadTask.taskId, (Object)downloadTask);
            this.executor.submit(downloadTask);
            return downloadTask.taskId;
        }
    }

    public void cancel(int n2) {
        SparseArray<DownloadTask> sparseArray = this.taskMap;
        synchronized (sparseArray) {
            DownloadTask downloadTask = (DownloadTask)this.taskMap.get(n2);
            if (downloadTask != null) {
                if (ALog.isPrintLog(2)) {
                    ALog.i(TAG, "try cancel task" + n2 + " url=" + downloadTask.url.toString(), null, new Object[0]);
                }
                this.taskMap.remove(n2);
                downloadTask.cancel();
            }
        }
    }

    private void prepareDownloadFolder() {
        File file;
        if (this.context != null && !(file = new File(this.context.getExternalFilesDir(null), DOWNLOAD_FOLDER)).exists()) {
            file.mkdir();
        }
    }

    private boolean prepareFolder(String string) {
        if (this.context != null) {
            try {
                File file = new File(string);
                if (!file.exists()) {
                    return file.mkdir();
                }
                return true;
            }
            catch (Exception exception) {
                ALog.e(TAG, "create folder failed", null, "folder", string);
            }
        }
        return false;
    }

    private String getDownloadFilePath(String string) {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(this.context.getExternalFilesDir(null)).append("/").append(DOWNLOAD_FOLDER).append("/").append(string);
        return stringBuilder.toString();
    }

    private String getTempFile(String string) {
        String string2 = StringUtils.md5ToHex(string);
        if (string2 == null) {
            string2 = string;
        }
        return this.context.getExternalCacheDir() + "/" + string2;
    }

    static /* synthetic */ String access$300(DownloadManager downloadManager, String string) {
        return downloadManager.getTempFile(string);
    }

    static /* synthetic */ Context access$400(DownloadManager downloadManager) {
        return downloadManager.context;
    }

    static /* synthetic */ SparseArray access$500(DownloadManager downloadManager) {
        return downloadManager.taskMap;
    }

    public static interface DownloadListener {
        public void onSuccess(int var1, String var2);

        public void onFail(int var1, int var2, String var3);

        public void onProgress(int var1, long var2, long var4);
    }

    class DownloadTask
    implements Runnable {
        final int taskId;
        final URL url;
        private final String filePath;
        private final CopyOnWriteArrayList<DownloadListener> listenerList;
        private final AtomicBoolean isCancelled = new AtomicBoolean(false);
        private final AtomicBoolean isFinish = new AtomicBoolean(false);
        private volatile Connection conn = null;

        DownloadTask(URL uRL, String string, String string2, DownloadListener downloadListener) {
            this.taskId = DownloadManager.this.taskIdGen.getAndIncrement();
            this.url = uRL;
            if (TextUtils.isEmpty((CharSequence)string2)) {
                string2 = this.parseFileNameForURL(uRL);
            }
            this.filePath = TextUtils.isEmpty((CharSequence)string) ? DownloadManager.this.getDownloadFilePath(string2) : (string.endsWith("/") ? string + string2 : string + '/' + string2);
            this.listenerList = new CopyOnWriteArrayList();
            this.listenerList.add(downloadListener);
        }

        public boolean attachListener(DownloadListener downloadListener) {
            if (this.isFinish.get()) {
                return false;
            }
            this.listenerList.add(downloadListener);
            return true;
        }

        public void cancel() {
            this.isCancelled.set(true);
            this.notifyFail(-105, "download canceled.");
            if (this.conn != null) {
                try {
                    this.conn.cancel();
                }
                catch (RemoteException remoteException) {}
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [20[TRYBLOCK]], but top level block is 91[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void notifySuccess(String string) {
            if (this.isFinish.compareAndSet(false, true)) {
                for (DownloadListener downloadListener : this.listenerList) {
                    downloadListener.onSuccess(this.taskId, string);
                }
            }
        }

        private void notifyFail(int n2, String string) {
            if (this.isFinish.compareAndSet(false, true)) {
                for (DownloadListener downloadListener : this.listenerList) {
                    downloadListener.onFail(this.taskId, n2, string);
                }
            }
        }

        private void notifyProgress(long l2, long l3) {
            if (!this.isFinish.get()) {
                for (DownloadListener downloadListener : this.listenerList) {
                    downloadListener.onProgress(this.taskId, l2, l3);
                }
            }
        }

        private long parseContentLength(int n2, Map<String, List<String>> map, long l2) {
            long l3 = 0L;
            try {
                if (n2 == 200) {
                    l3 = Long.parseLong(c.b(map, "Content-Length"));
                } else if (n2 == 206) {
                    int n3;
                    String string = c.b(map, "Content-Range");
                    if (string != null && (n3 = string.lastIndexOf(47)) != -1) {
                        l3 = Long.parseLong(string.substring(n3 + 1));
                    }
                    if (l3 == 0L) {
                        l3 = Long.parseLong(c.b(map, "Content-Length"));
                        l3 += l2;
                    }
                }
            }
            catch (Exception exception) {}
            return l3;
        }

        private void removeRangeHeader(List<Header> list) {
            if (list != null) {
                ListIterator<Header> listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    if (!"Range".equalsIgnoreCase(listIterator.next().getName())) continue;
                    listIterator.remove();
                    break;
                }
            }
        }

        private String parseFileNameForURL(URL uRL) {
            String string = uRL.getPath();
            int n2 = string.lastIndexOf(47);
            String string2 = null;
            if (n2 != -1) {
                string2 = string.substring(n2 + 1, string.length());
            }
            if (TextUtils.isEmpty(string2) && (string2 = StringUtils.md5ToHex(uRL.toString())) == null) {
                string2 = uRL.getFile();
            }
            return string2;
        }
    }

    private static class ClassHolder {
        static DownloadManager instance = new DownloadManager();

        private ClassHolder() {
        }
    }
}

