/*
 * Decompiled with CFR 0.152.
 */
package anetwork.channel.cache;

import anet.channel.c.c;
import anetwork.channel.cache.AVFSCacheImpl;
import anetwork.channel.cache.Cache;
import anetwork.channel.cache.CachePrediction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class CacheManager {
    private static List<CacheItem> cacheList = new ArrayList<CacheItem>();
    private static final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private static final ReentrantReadWriteLock.ReadLock readLock = lock.readLock();
    private static final ReentrantReadWriteLock.WriteLock writeLock = lock.writeLock();

    public static void addCache(Cache cache, CachePrediction cachePrediction, int n2) {
        try {
            if (cache == null) {
                throw new IllegalArgumentException("cache is null");
            }
            if (cachePrediction == null) {
                throw new IllegalArgumentException("prediction is null");
            }
            writeLock.lock();
            cacheList.add(new CacheItem(cache, cachePrediction, n2));
            Collections.sort(cacheList);
        }
        finally {
            writeLock.unlock();
        }
    }

    public static void removeCache(Cache cache) {
        try {
            writeLock.lock();
            ListIterator<CacheItem> listIterator = cacheList.listIterator();
            while (listIterator.hasNext()) {
                if (listIterator.next().cache != cache) continue;
                listIterator.remove();
                break;
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    public static Cache getCache(String string, Map<String, String> map) {
        try {
            readLock.lock();
            for (CacheItem cacheItem : cacheList) {
                CachePrediction cachePrediction = cacheItem.prediction;
                if (!cachePrediction.handleCache(string, map)) continue;
                Cache cache = cacheItem.cache;
                readLock.unlock();
                return cache;
            }
            Iterator<CacheItem> iterator = null;
            readLock.unlock();
            return iterator;
        }
        catch (Throwable throwable) {
            readLock.unlock();
            throw throwable;
        }
    }

    static {
        c.a(new Runnable(){

            @Override
            public void run() {
                try {
                    AVFSCacheImpl aVFSCacheImpl = new AVFSCacheImpl();
                    aVFSCacheImpl.initialize();
                    CacheManager.addCache(aVFSCacheImpl, new CachePrediction(){

                        @Override
                        public boolean handleCache(String string, Map<String, String> map) {
                            return "weex".equals(map.get("f-refer"));
                        }
                    }, 1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private static class CacheItem
    implements Comparable<CacheItem> {
        final Cache cache;
        final CachePrediction prediction;
        final int priority;

        CacheItem(Cache cache, CachePrediction cachePrediction, int n2) {
            this.cache = cache;
            this.prediction = cachePrediction;
            this.priority = n2;
        }

        @Override
        public int compareTo(CacheItem cacheItem) {
            return this.priority - cacheItem.priority;
        }
    }
}

