/*
 * Decompiled with CFR 0.152.
 */
package anetwork.channel.aidl.adapter;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import anet.channel.util.ALog;
import anet.channel.util.Utils;
import anetwork.channel.aidl.IRemoteNetworkGetter;
import anetwork.channel.aidl.NetworkService;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class RemoteGetterHelper {
    private static final String TAG = "ANet.RemoteGetter";
    private static volatile IRemoteNetworkGetter mGetter;
    private static volatile boolean bBindFailed;
    private static volatile boolean bBinding;
    private static volatile CountDownLatch mServiceBindLock;
    private static Handler handler;
    private static ServiceConnection conn;

    public static void initRemoteGetterAndWait(Context context, boolean bl) {
        if (mGetter != null) {
            return;
        }
        if (!bBindFailed) {
            RemoteGetterHelper.asyncBindService(context);
            if (!bBindFailed && bl) {
                try {
                    Class<RemoteGetterHelper> clazz = RemoteGetterHelper.class;
                    synchronized (RemoteGetterHelper.class) {
                        if (mGetter != null) {
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return;
                        }
                        if (mServiceBindLock == null) {
                            mServiceBindLock = new CountDownLatch(1);
                        }
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        ALog.i(TAG, "[initRemoteGetterAndWait]begin to wait 10s", null, new Object[0]);
                        if (mServiceBindLock.await(10L, TimeUnit.SECONDS)) {
                            ALog.i(TAG, "mServiceBindLock count down to 0", null, new Object[0]);
                        } else {
                            ALog.i(TAG, "mServiceBindLock wait timeout", null, new Object[0]);
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    ALog.e(TAG, "mServiceBindLock wait interrupt", null, new Object[0]);
                }
            }
        }
    }

    public static IRemoteNetworkGetter getRemoteGetter() {
        return mGetter;
    }

    private static void asyncBindService(Context context) {
        block8: {
            if (ALog.isPrintLog(2)) {
                ALog.i(TAG, "[asyncBindService] mContext:" + context + " bBindFailed:" + bBindFailed + " bBinding:" + bBinding, null, new Object[0]);
            }
            if (context == null) {
                return;
            }
            if (bBindFailed) {
                return;
            }
            if (bBinding) {
                return;
            }
            bBinding = true;
            try {
                Class[] classArray = new Class[]{Context.class, Class.class, ServiceConnection.class};
                Object[] objectArray = new Object[]{context.getApplicationContext(), IRemoteNetworkGetter.class, conn};
                bBindFailed = Boolean.valueOf(Utils.invokeStaticMethodThrowException("com.taobao.android.service.Services", "bind", classArray, objectArray) + "") == false;
            }
            catch (Exception exception) {
                ALog.w(TAG, "[asyncBindService]use taobao framwork start service error", null, exception, new Object[0]);
                bBindFailed = true;
                if (!(exception instanceof ClassNotFoundException) && !(exception instanceof NoSuchMethodException)) break block8;
                ALog.i(TAG, "[asyncBindService]Cannot found Service Farmwork,User System intent start Anet service", null, new Object[0]);
                Intent intent = new Intent(context, NetworkService.class);
                intent.setAction(IRemoteNetworkGetter.class.getName());
                intent.addCategory("android.intent.category.DEFAULT");
                boolean bl = bBindFailed = !context.bindService(intent, conn, 1);
            }
        }
        if (bBindFailed) {
            bBinding = false;
            ALog.w(TAG, "[asyncBindService]ANet_Service start not success.ANet run with local mode!", null, new Object[0]);
        }
        handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (bBinding) {
                    bBinding = false;
                    ALog.w(RemoteGetterHelper.TAG, "binding service timeout. reset status!", null, new Object[0]);
                }
            }
        }, 15000L);
        if (ALog.isPrintLog(2)) {
            ALog.i(TAG, "[asyncBindService] end", null, new Object[0]);
        }
    }

    static {
        bBindFailed = false;
        bBinding = false;
        mServiceBindLock = null;
        handler = new Handler(Looper.getMainLooper());
        conn = new ServiceConnection(){

            public void onServiceDisconnected(ComponentName componentName) {
                if (ALog.isPrintLog(2)) {
                    ALog.i(RemoteGetterHelper.TAG, "ANet_Service Disconnected", null, new Object[0]);
                }
                mGetter = null;
                bBinding = false;
                if (mServiceBindLock != null) {
                    mServiceBindLock.countDown();
                }
            }

            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                if (ALog.isPrintLog(2)) {
                    ALog.i(RemoteGetterHelper.TAG, "[onServiceConnected]ANet_Service start success. ANet run with service mode", null, new Object[0]);
                }
                Class<RemoteGetterHelper> clazz = RemoteGetterHelper.class;
                synchronized (RemoteGetterHelper.class) {
                    mGetter = IRemoteNetworkGetter.Stub.asInterface(iBinder);
                    if (mServiceBindLock != null) {
                        mServiceBindLock.countDown();
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    bBindFailed = false;
                    bBinding = false;
                    return;
                }
            }
        };
    }
}

