/*
 * Decompiled with CFR 0.152.
 */
package anet.channel.session;

import android.content.Context;
import android.text.TextUtils;
import anet.channel.Config;
import anet.channel.GlobalAppRuntimeInfo;
import anet.channel.RequestCb;
import anet.channel.Session;
import anet.channel.a.b;
import anet.channel.appmonitor.AppMonitor;
import anet.channel.entity.ConnType;
import anet.channel.entity.EventType;
import anet.channel.entity.c;
import anet.channel.entity.d;
import anet.channel.request.Cancelable;
import anet.channel.request.Request;
import anet.channel.request.TnetCancelable;
import anet.channel.security.ISecurity;
import anet.channel.session.b;
import anet.channel.session.l;
import anet.channel.statist.ExceptionStatistic;
import anet.channel.statist.RequestStatistic;
import anet.channel.status.NetworkStatusHelper;
import anet.channel.util.ALog;
import anet.channel.util.ErrorConstant;
import anet.channel.util.Utils;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.android.spdy.RequestPriority;
import org.android.spdy.SessionCb;
import org.android.spdy.SessionInfo;
import org.android.spdy.SpdyAgent;
import org.android.spdy.SpdyByteArray;
import org.android.spdy.SpdyDataProvider;
import org.android.spdy.SpdyErrorException;
import org.android.spdy.SpdyRequest;
import org.android.spdy.SpdySession;
import org.android.spdy.SpdySessionKind;
import org.android.spdy.SpdyVersion;
import org.android.spdy.SuperviseConnectInfo;
import org.android.spdy.SuperviseData;

public abstract class k
extends Session
implements SessionCb {
    private static final String TAG = "awcn.TnetSpdySession";
    private static final String SSL_TIKET_KEY2 = "accs_ssl_key2_";
    protected SpdyAgent mAgent;
    protected SpdySession mSession;
    protected volatile boolean mHasUnrevPing = false;
    protected long mLastPingTime;
    protected long mConnectedTime = 0L;
    private int requestTimeoutCount = 0;
    protected int tnetPublicKey = -1;
    protected String mAppkey = GlobalAppRuntimeInfo.getAppKey();
    protected ISecurity iSecurity = GlobalAppRuntimeInfo.getSecurity();

    public k(Context context, anet.channel.entity.a a2, ConnType connType) {
        super(context, a2, connType);
        this.init();
    }

    @Override
    public Cancelable request(Request request, RequestCb requestCb) {
        TnetCancelable tnetCancelable = TnetCancelable.NULL;
        RequestStatistic requestStatistic = request != null ? request.rs : new RequestStatistic(this.mRealHost, null);
        requestStatistic.setConnType(this.mConnType);
        requestStatistic.setIPAndPort(this.mIp, this.mPort);
        if (requestStatistic.start == 0L) {
            requestStatistic.start = System.currentTimeMillis();
        }
        if (request == null || requestCb == null) {
            if (requestCb != null) {
                requestCb.onFinish(-102, ErrorConstant.getErrMsg(-102), requestStatistic);
            }
            return tnetCancelable;
        }
        try {
            if (this.mSession != null && this.isAvailable()) {
                if (ALog.isPrintLog(2)) {
                    ALog.i(TAG, "", request.getSeq(), "request URL", request.getUrlString());
                    ALog.i(TAG, "", request.getSeq(), "request headers", request.getHeaders());
                }
                URL uRL = request.getUrl();
                SpdyRequest spdyRequest = TextUtils.isEmpty((CharSequence)this.mProxyIp) || this.mProxyPort <= 0 ? new SpdyRequest(uRL, request.getMethod(), RequestPriority.DEFAULT_PRIORITY, request.getReadTimeout(), request.getConnectTimeout()) : new SpdyRequest(uRL, uRL.getHost(), uRL.getPort(), this.mProxyIp, this.mProxyPort, request.getMethod(), RequestPriority.DEFAULT_PRIORITY, request.getReadTimeout(), request.getConnectTimeout(), 0);
                spdyRequest.addHeaders(request.getHeaders());
                spdyRequest.addHeader(":host", request.getHost());
                byte[] byArray = request.getBody();
                SpdyDataProvider spdyDataProvider = new SpdyDataProvider(byArray);
                int n2 = this.mSession.submitRequest(spdyRequest, spdyDataProvider, this, new a(request, requestCb));
                if (ALog.isPrintLog(1)) {
                    ALog.d(TAG, "", request.getSeq(), "streamId", n2);
                }
                tnetCancelable = new TnetCancelable(this.mSession, n2, request.getSeq());
                ++this.mSessionStat.requestCount;
                ++this.mSessionStat.stdRCount;
                this.mLastPingTime = System.currentTimeMillis();
            } else {
                requestCb.onFinish(-301, "Session\u4e0d\u53ef\u7528", request.rs);
            }
        }
        catch (SpdyErrorException spdyErrorException) {
            if (spdyErrorException.SpdyErrorGetCode() == -1104 || spdyErrorException.SpdyErrorGetCode() == -1103) {
                ALog.e(TAG, "Send request on closed session!!!", this.mSeq, new Object[0]);
                c c2 = new c(EventType.DISCONNECTED, false, -1104, "Session is closed!");
                this.notifyStatus(Session.Status.DISCONNECTED, c2);
            }
            requestCb.onFinish(-300, ErrorConstant.formatMsg(-300, spdyErrorException.toString()), requestStatistic);
        }
        catch (Exception exception) {
            requestCb.onFinish(-101, ErrorConstant.formatMsg(-101, exception.toString()), requestStatistic);
        }
        return tnetCancelable;
    }

    @Override
    public void sendCustomFrame(int n2, byte[] byArray, int n3) {
    }

    @Override
    protected void connect() {
        if (this.mStatus == Session.Status.CONNECTING || this.mStatus == Session.Status.CONNECTED || this.mStatus == Session.Status.AUTH_SUCC) {
            return;
        }
        try {
            if (this.mAgent != null) {
                String string = String.valueOf(System.currentTimeMillis());
                ALog.e(TAG, "[connect]", this.mSeq, "host", this.mHost, "connect ", this.mIp + ":" + this.mPort, "sessionId", string, "SpdyProtocol,", this.mConnType.toProtocol(), "proxyIp,", this.mProxyIp, "proxyPort,", this.mProxyPort);
                SessionInfo sessionInfo = new SessionInfo(this.mIp, this.mPort, this.mHost + "_" + this.mAppkey, this.mProxyIp, this.mProxyPort, string, this, this.mConnType.getTnetConType());
                sessionInfo.setPubKeySeqNum(Utils.getPublicKey(this.mConnType, this.iSecurity.isSecOff(), this.tnetPublicKey));
                this.mSession = this.mAgent.createSession(sessionInfo);
                if (this.mSession.getRefCount() > 1) {
                    ALog.e(TAG, "get session ref count > 1!!!", this.mSeq, new Object[0]);
                    this.notifyStatus(Session.Status.CONNECTED, new anet.channel.entity.b(EventType.CONNECTED));
                    this.auth();
                    return;
                }
                this.notifyStatus(Session.Status.CONNECTING, null);
                this.mLastPingTime = System.currentTimeMillis();
                this.mSessionStat.isProxy = !TextUtils.isEmpty((CharSequence)this.mProxyIp) + "";
                this.mSessionStat.isTunnel = "false";
                this.mSessionStat.isBackground = GlobalAppRuntimeInfo.isAppBackground();
                this.mConnectedTime = 0L;
            }
        }
        catch (Throwable throwable) {
            this.notifyStatus(Session.Status.CONNETFAIL, null);
            ALog.e(TAG, "connect exception ", this.mSeq, throwable, new Object[0]);
        }
    }

    @Override
    public void close() {
        ALog.e(TAG, "force close!", this.mSeq, "session", this);
        this.notifyStatus(Session.Status.DISCONNECTING, null);
        try {
            if (this.mSession != null) {
                this.mSession.closeSession();
            }
        }
        catch (Exception exception) {}
    }

    @Override
    protected void onDisconnect() {
        this.mHasUnrevPing = false;
    }

    @Override
    public void ping(boolean bl) {
        if (ALog.isPrintLog(1)) {
            ALog.d(TAG, "ping", this.mSeq, "host", this.mHost, "thread", Thread.currentThread().getName());
        }
        try {
            if (bl) {
                if (this.mSession != null) {
                    if (this.mStatus == Session.Status.CONNECTED || this.mStatus == Session.Status.AUTH_SUCC) {
                        this.handleCallbacks(EventType.PING_SEND, null);
                        this.mHasUnrevPing = true;
                        ++this.mSessionStat.ppkgCount;
                        this.mSession.submitPing();
                        if (ALog.isPrintLog(1)) {
                            ALog.d(TAG, this.mHost + " submit ping ms:" + (System.currentTimeMillis() - this.mLastPingTime) + " force:" + bl, this.mSeq, new Object[0]);
                        }
                        this.setPingTimeout();
                        this.mLastPingTime = System.currentTimeMillis();
                    }
                } else {
                    if (this.mSessionStat != null) {
                        this.mSessionStat.closeReason = "session null";
                    }
                    ALog.e(TAG, this.mHost + " session null", this.mSeq, new Object[0]);
                    this.close();
                }
            }
        }
        catch (SpdyErrorException spdyErrorException) {
            if (spdyErrorException.SpdyErrorGetCode() == -1104 || spdyErrorException.SpdyErrorGetCode() == -1103) {
                ALog.e(TAG, "Send request on closed session!!!", this.mSeq, new Object[0]);
                c c2 = new c(EventType.DISCONNECTED, false, -1104, "Session is closed!");
                this.notifyStatus(Session.Status.DISCONNECTED, c2);
            }
            ALog.e(TAG, "ping", this.mSeq, spdyErrorException, new Object[0]);
        }
        catch (Exception exception) {
            ALog.e(TAG, "ping", this.mSeq, exception, new Object[0]);
        }
    }

    protected void auth() {
    }

    @Override
    public boolean isAvailable() {
        return this.mStatus == Session.Status.AUTH_SUCC;
    }

    public void setConfig(Config config) {
        this.mAppkey = config.getAppkey();
        this.iSecurity = config.getSecurity();
        this.tnetPublicKey = config.getAccsPublicKey();
    }

    private void init() {
        try {
            SpdyAgent.enableDebug = false;
            this.mAgent = SpdyAgent.getInstance(this.mContext, SpdyVersion.SPDY3, SpdySessionKind.NONE_SESSION);
            if (!this.iSecurity.isSecOff()) {
                this.mAgent.setAccsSslCallback(new l(this));
            }
        }
        catch (Exception exception) {
            ALog.e(TAG, "Init failed.", null, exception, new Object[0]);
        }
    }

    @Override
    public void spdySessionConnectCB(SpdySession spdySession, SuperviseConnectInfo superviseConnectInfo) {
        anet.channel.entity.b b2 = new anet.channel.entity.b(EventType.CONNECTED);
        b2.a = superviseConnectInfo.connectTime;
        b2.b = superviseConnectInfo.handshakeTime;
        this.mSessionStat.connectionTime = superviseConnectInfo.connectTime;
        this.mSessionStat.sslTime = superviseConnectInfo.handshakeTime;
        this.mSessionStat.sslCalTime = superviseConnectInfo.doHandshakeTime;
        this.mSessionStat.netType = NetworkStatusHelper.b();
        this.mConnectedTime = System.currentTimeMillis();
        this.notifyStatus(Session.Status.CONNECTED, b2);
        this.auth();
        ALog.e(TAG, "spdySessionConnectCB connect", this.mSeq, "connectTime", superviseConnectInfo.connectTime, "sslTime:", superviseConnectInfo.handshakeTime);
    }

    @Override
    public void spdyPingRecvCallback(SpdySession spdySession, long l2, Object object) {
        if (ALog.isPrintLog(2)) {
            ALog.i(TAG, "ping receive", this.mSeq, "Host", this.mHost, "id", l2);
        }
        if (l2 < 0L) {
            return;
        }
        this.mHasUnrevPing = false;
        this.handleCallbacks(EventType.PIND_RECEIVE, null);
    }

    @Override
    public void bioPingRecvCallback(SpdySession spdySession, int n2) {
        if (ALog.isPrintLog(2)) {
            ALog.i(TAG, this.mHost + " ping receive " + n2, this.mSeq, new Object[0]);
        }
    }

    @Override
    public void spdyCustomControlFrameRecvCallback(SpdySession spdySession, Object object, int n2, int n3, int n4, int n5, byte[] byArray) {
    }

    @Override
    public void spdySessionFailedError(SpdySession spdySession, int n2, Object object) {
        try {
            if (spdySession != null) {
                spdySession.cleanUp();
            }
        }
        catch (Exception exception) {
            ALog.e(TAG, "[spdySessionFailedError]session clean up failed!", null, exception, new Object[0]);
        }
        this.notifyStatus(Session.Status.CONNETFAIL, new d(EventType.CONNECT_FAIL, n2, "tnet connect fail"));
        ALog.e(TAG, null, this.mSeq, " errorId:", n2);
        this.mSessionStat.errorCode = n2;
        this.mSessionStat.ret = 0;
        this.mSessionStat.netType = NetworkStatusHelper.b();
        if (!this.isHorseRide) {
            AppMonitor.getInstance().commitStat(this.mSessionStat);
            AppMonitor.getInstance().commitAlarm(this.mSessionStat.getAlarmObject());
        }
    }

    @Override
    public void spdySessionCloseCallback(SpdySession spdySession, Object object, SuperviseConnectInfo superviseConnectInfo, int n2) {
        ALog.e(TAG, "spdySessionCloseCallback", this.mSeq, " errorCode:", n2);
        try {
            if (spdySession != null) {
                spdySession.cleanUp();
            }
        }
        catch (Exception exception) {
            ALog.e(TAG, "[spdySessionCloseCallback]session clean up failed!", null, exception, new Object[0]);
        }
        String string = TextUtils.isEmpty((CharSequence)this.mSessionStat.closeReason) ? "tnet close error:" + n2 : this.mSessionStat.closeReason + ":" + this.mSessionStat.errorCode;
        c c2 = new c(EventType.DISCONNECTED, false, n2, string);
        this.notifyStatus(Session.Status.DISCONNECTED, c2);
        if (superviseConnectInfo != null) {
            this.mSessionStat.requestCount = superviseConnectInfo.reused_counter;
            this.mSessionStat.liveTime = superviseConnectInfo.keepalive_period_second;
        }
        if (this.mSessionStat.errorCode == 0L) {
            this.mSessionStat.errorCode = n2;
        }
        this.mSessionStat.lastPingInterval = (int)(System.currentTimeMillis() - this.mLastPingTime);
        if (!this.isHorseRide) {
            AppMonitor.getInstance().commitStat(this.mSessionStat);
            AppMonitor.getInstance().commitAlarm(this.mSessionStat.getAlarmObject());
        }
    }

    @Override
    public void spdyCustomControlFrameFailCallback(SpdySession spdySession, Object object, int n2, int n3) {
    }

    @Override
    public byte[] getSSLMeta(SpdySession spdySession) {
        byte[] byArray = null;
        String string = spdySession.getDomain();
        if (TextUtils.isEmpty((CharSequence)string)) {
            ALog.i(TAG, "get sslticket host is null", null, new Object[0]);
            return byArray;
        }
        try {
            byArray = this.iSecurity.dynamicGetBytes(this.mContext, SSL_TIKET_KEY2 + string);
        }
        catch (Throwable throwable) {
            ALog.e(TAG, "getSSLMeta", null, throwable, new Object[0]);
        }
        return byArray;
    }

    @Override
    public int putSSLMeta(SpdySession spdySession, byte[] byArray) {
        int n2 = -1;
        String string = spdySession.getDomain();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return n2;
        }
        try {
            n2 = this.iSecurity.dynamicPutBytes(this.mContext, SSL_TIKET_KEY2 + string, byArray) ? 0 : -1;
        }
        catch (Throwable throwable) {
            ALog.e(TAG, "putSSLMeta", null, throwable, new Object[0]);
        }
        return n2;
    }

    static /* synthetic */ Context access$000(k k2) {
        return k2.mContext;
    }

    private class a
    extends b {
        private Request b;
        private RequestCb c;
        private long d = 0L;
        private long e = 0L;
        private long f = 0L;

        public a(Request request, RequestCb requestCb) {
            this.b = request;
            this.c = requestCb;
            this.d = System.currentTimeMillis();
        }

        @Override
        public void spdyDataChunkRecvCB(SpdySession spdySession, boolean bl, long l2, SpdyByteArray spdyByteArray, Object object) {
            ALog.d(k.TAG, "spdyDataChunkRecvCB", this.b.getSeq(), "len", spdyByteArray.getDataLength(), "fin", bl);
            if (this.b.rs.firstDataTime == 0L) {
                this.b.rs.firstDataTime = System.currentTimeMillis();
            }
            if (this.c != null) {
                anet.channel.a.a a2 = b.a.a.a(spdyByteArray.getByteArray(), spdyByteArray.getDataLength());
                spdyByteArray.recycle();
                this.c.onDataReceive(a2, bl);
            }
            k.this.handleCallbacks(EventType.DATA_RECEIVE, null);
        }

        @Override
        public void spdyStreamCloseCallback(SpdySession spdySession, long l2, int n2, Object object, SuperviseData superviseData) {
            ALog.d(k.TAG, "spdyStreamCloseCallback", this.b.getSeq(), "streamId", l2);
            this.e = System.currentTimeMillis();
            this.a(superviseData);
            String string = "SUCCESS";
            if (n2 != 0) {
                if (n2 != -2005) {
                    string = ErrorConstant.formatMsg(-300, "statusCode=" + n2);
                    AppMonitor.getInstance().commitStat(new ExceptionStatistic(-300, string, this.b.rs, null));
                }
                ALog.e(k.TAG, "spdyStreamCloseCallback error", this.b.getSeq(), "status code", n2);
            }
            if (this.c != null) {
                this.c.onFinish(n2, string, this.b.rs);
            }
            if (n2 == -2004 && ++k.this.requestTimeoutCount >= 3) {
                k.this.close(true);
            }
            if (n2 <= -3000 && n2 > -4000) {
                anet.channel.b.b.a().a(3, this.b.getHost());
            }
        }

        private void a(SuperviseData superviseData) {
            try {
                if (this.e <= 0L || this.d <= 0L) {
                    return;
                }
                this.b.rs.serverRT = this.f;
                this.b.rs.recDataTime = this.b.rs.firstDataTime != 0L ? this.e - this.b.rs.firstDataTime : 0L;
                this.b.rs.waitingTime = this.b.rs.oneWayTime = this.e - this.b.rs.start;
                if (superviseData != null) {
                    this.b.rs.firstDataTime = superviseData.responseStart - superviseData.sendStart;
                    this.b.rs.recDataTime = superviseData.responseEnd - superviseData.responseStart;
                    this.b.rs.sendBeforeTime = superviseData.sendStart - this.d;
                    this.b.rs.sendDataTime = superviseData.sendEnd - superviseData.sendStart;
                    this.b.rs.sendDataSize = superviseData.bodySize + superviseData.compressSize;
                    this.b.rs.recDataSize = superviseData.recvBodySize + superviseData.recvCompressSize;
                    k.this.mSessionStat.recvSizeCount += (long)(superviseData.recvBodySize + superviseData.recvCompressSize);
                    k.this.mSessionStat.sendSizeCount += (long)(superviseData.bodySize + superviseData.compressSize);
                }
            }
            catch (Exception exception) {}
        }

        @Override
        public void spdyOnStreamResponse(SpdySession spdySession, long l2, Map<String, List<String>> map, Object object) {
            int n2 = 0;
            List<String> list = null;
            try {
                list = map.get(":status");
                if (list != null && !list.isEmpty()) {
                    n2 = Integer.parseInt(list.get(0));
                }
            }
            catch (NumberFormatException numberFormatException) {}
            if (n2 > 0) {
                this.b.rs.ret = true;
                k.this.requestTimeoutCount = 0;
            }
            ALog.i(k.TAG, "", this.b.getSeq(), "httpStatusCode", n2);
            ALog.i(k.TAG, "", this.b.getSeq(), "response headers", map);
            if (this.c != null) {
                this.c.onResponseCode(n2, anet.channel.util.c.a(map));
            }
            k.this.handleCallbacks(EventType.HEADER_RECEIVE, null);
            try {
                list = map.get("s-rt");
                if (list != null && !list.isEmpty()) {
                    this.f = Long.parseLong(list.get(0));
                }
            }
            catch (NumberFormatException numberFormatException) {}
            if (anet.channel.strategy.a.d(k.this.mRealHost)) {
                anet.channel.b.b.a().a(0, k.this.mRealHost, n2);
            }
        }
    }
}

