/*
 * Decompiled with CFR 0.152.
 */
package anet.channel.request;

import android.text.TextUtils;
import anet.channel.request.BodyEntry;
import anet.channel.request.ByteArrayEntry;
import anet.channel.statist.RequestStatistic;
import anet.channel.util.StringUtils;
import anet.channel.util.e;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Request {
    public static final String DEFAULT_CHARSET = "UTF-8";
    private e httpUrl;
    private URL url;
    private String method = "GET";
    private Map<String, String> headers;
    private Map<String, String> params;
    private String charset;
    private BodyEntry body;
    private boolean isRedirectEnable = true;
    private boolean isHostnameVerifyEnable = true;
    private String bizId;
    private String seq;
    private int redirectTimes = 0;
    private int connectTimeout = 10000;
    private int readTimeout = 10000;
    public final RequestStatistic rs;

    private Request(Builder builder) {
        this.method = builder.method;
        this.headers = builder.headers;
        this.params = builder.params;
        this.body = builder.body;
        this.charset = builder.charset;
        this.isRedirectEnable = builder.isRedirectEnable;
        this.redirectTimes = builder.redirectTimes;
        this.isHostnameVerifyEnable = builder.isHostnameVerifyEnable;
        this.bizId = builder.bizId;
        this.seq = builder.seq;
        this.connectTimeout = builder.connectTimeout;
        this.readTimeout = builder.readTimeout;
        this.httpUrl = builder.httpUrl;
        this.httpUrl.g();
        this.rs = builder.rs != null ? builder.rs : new RequestStatistic(this.getHost(), this.bizId);
        this.formatUrl();
    }

    public Builder newBuilder() {
        Builder builder = new Builder();
        builder.method = this.method;
        builder.headers = this.headers;
        builder.params = this.params;
        builder.body = this.body;
        builder.charset = this.charset;
        builder.isRedirectEnable = this.isRedirectEnable;
        builder.redirectTimes = this.redirectTimes;
        builder.isHostnameVerifyEnable = this.isHostnameVerifyEnable;
        builder.httpUrl = this.httpUrl;
        builder.bizId = this.bizId;
        builder.seq = this.seq;
        builder.connectTimeout = this.connectTimeout;
        builder.readTimeout = this.readTimeout;
        builder.rs = this.rs;
        return builder;
    }

    public e getHttpUrl() {
        return this.httpUrl;
    }

    public String getUrlString() {
        return this.httpUrl.d();
    }

    public URL getUrl() {
        if (this.url == null) {
            this.url = this.httpUrl.e();
        }
        return this.url;
    }

    public void setDnsOptimize(String string, int n2) {
        this.httpUrl.a(string, n2);
        this.rs.setIPAndPort(string, n2);
    }

    public int getRedirectTimes() {
        return this.redirectTimes;
    }

    public String getHost() {
        return this.httpUrl.b();
    }

    public String getMethod() {
        return this.method;
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public String getContentEncoding() {
        return this.charset != null ? this.charset : DEFAULT_CHARSET;
    }

    public boolean isRedirectEnable() {
        return this.isRedirectEnable;
    }

    public boolean isHostnameVerifyEnable() {
        return this.isHostnameVerifyEnable;
    }

    public int postBody(OutputStream outputStream) throws IOException {
        int n2 = 0;
        if (this.body != null) {
            n2 = this.body.writeTo(outputStream);
        }
        return n2;
    }

    public byte[] getBody() {
        if (this.body != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(128);
            try {
                this.postBody(byteArrayOutputStream);
            }
            catch (IOException iOException) {}
            return byteArrayOutputStream.toByteArray();
        }
        return null;
    }

    public String getBizId() {
        return this.bizId;
    }

    public String getSeq() {
        return this.seq;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    private void formatUrl() {
        String string = StringUtils.encodeQueryParams(this.params, this.getContentEncoding());
        if (!TextUtils.isEmpty((CharSequence)string)) {
            if (this.method == "GET" || this.method == "POST" && this.body != null) {
                String string2 = this.httpUrl.d();
                StringBuilder stringBuilder = new StringBuilder(this.httpUrl.d());
                if (stringBuilder.indexOf("?") == -1) {
                    stringBuilder.append('?');
                } else if (string2.charAt(string2.length() - 1) != '&') {
                    stringBuilder.append('&');
                }
                stringBuilder.append(string);
                e e2 = e.a(stringBuilder.toString());
                if (e2 != null) {
                    this.httpUrl = e2;
                }
            } else {
                try {
                    this.body = new ByteArrayEntry(string.getBytes(this.getContentEncoding()));
                    this.headers.put("Content-Type", "application/x-www-form-urlencoded; charset=" + this.getContentEncoding());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
        }
    }

    public static class Builder {
        private e httpUrl;
        private String method = "GET";
        private Map<String, String> headers = new HashMap<String, String>();
        private Map<String, String> params;
        private String charset;
        private BodyEntry body;
        private boolean isRedirectEnable = true;
        private int redirectTimes = 0;
        private boolean isHostnameVerifyEnable = true;
        private String bizId;
        private String seq;
        private int connectTimeout = 0;
        private int readTimeout = 0;
        private RequestStatistic rs = null;

        public Builder setUrl(e e2) {
            this.httpUrl = e2;
            return this;
        }

        public Builder setUrl(String string) {
            this.httpUrl = e.a(string);
            if (this.httpUrl == null) {
                throw new IllegalArgumentException("url is invalid! url = " + string);
            }
            return this;
        }

        public Builder setMethod(String string) {
            this.method = "POST".equalsIgnoreCase(string) ? "POST" : "GET";
            return this;
        }

        public Builder setHeaders(Map<String, String> map) {
            this.headers.clear();
            if (map != null) {
                this.headers.putAll(map);
            }
            return this;
        }

        public Builder addHeader(String string, String string2) {
            this.headers.put(string, string2);
            return this;
        }

        public Builder setParams(Map<String, String> map) {
            this.params = map;
            return this;
        }

        public Builder addParam(String string, String string2) {
            if (this.params == null) {
                this.params = new HashMap<String, String>();
            }
            this.params.put(string, string2);
            return this;
        }

        public Builder setCharset(String string) {
            this.charset = string;
            return this;
        }

        public Builder setBody(BodyEntry bodyEntry) {
            this.body = bodyEntry;
            return this;
        }

        public Builder setRedirectEnable(boolean bl) {
            this.isRedirectEnable = bl;
            return this;
        }

        public Builder setRedirectTimes(int n2) {
            this.redirectTimes = n2;
            return this;
        }

        public Builder setHostnameVerifyEnable(boolean bl) {
            this.isHostnameVerifyEnable = bl;
            return this;
        }

        public Builder setBizId(String string) {
            this.bizId = string;
            return this;
        }

        public Builder setSeq(String string) {
            this.seq = string;
            return this;
        }

        public Builder setReadTimeout(int n2) {
            this.readTimeout = n2;
            return this;
        }

        public Builder setConnectTimeout(int n2) {
            this.connectTimeout = n2;
            return this;
        }

        public Builder setRequestStatistic(RequestStatistic requestStatistic) {
            this.rs = requestStatistic;
            return this;
        }

        public Request build() {
            return new Request(this);
        }
    }

    public static final class Method {
        public static final String GET = "GET";
        public static final String POST = "POST";
    }
}

