/*
 * Decompiled with CFR 0.152.
 */
package anet.channel.heartbeat;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import anet.channel.Session;
import anet.channel.heartbeat.DefaultHeartbeatImpl;
import anet.channel.heartbeat.IHeartbeat;
import anet.channel.heartbeat.IHeartbeatFactory;

public class HeartbeatManager {
    private static volatile IHeartbeatFactory heartbeatFactory = new IHeartbeatFactory(){

        @Override
        public IHeartbeat createHeartbeat(Session session) {
            if (session == null || session.getConnStrategy() == null || session.getConnStrategy().getHeartbeat() <= 0) {
                return null;
            }
            return new DefaultHeartbeatImpl(session);
        }
    };

    public static IHeartbeatFactory getHeartbeatFactory() {
        return heartbeatFactory;
    }

    public static void setHeartbeatFactory(IHeartbeatFactory iHeartbeatFactory) {
        heartbeatFactory = iHeartbeatFactory;
    }

    @Deprecated
    public static class Receiver
    extends BroadcastReceiver {
        public void onReceive(Context context, Intent intent) {
        }
    }
}

