/*
 * Decompiled with CFR 0.152.
 */
package anet.channel.heartbeat;

import anet.channel.GlobalAppRuntimeInfo;
import anet.channel.Session;
import anet.channel.c.c;
import anet.channel.heartbeat.IHeartbeat;
import anet.channel.util.ALog;
import java.util.concurrent.TimeUnit;

public class DefaultHeartbeatImpl
implements IHeartbeat,
Runnable {
    private static final String TAG = "awcn.DefaultHeartbeatImpl";
    private final Session session;
    protected long interval = 0L;
    private volatile long executeTime = 0L;
    private volatile boolean isCancelled = false;
    private int bgHeartbeatCount = 0;

    public DefaultHeartbeatImpl(Session session) {
        this.session = session;
        this.interval = session.getConnStrategy().getHeartbeat();
    }

    @Override
    public void start() {
        ALog.i(TAG, "heartbeat start", null, "session", this.session);
        this.executeTime = System.currentTimeMillis() + this.interval;
        this.submit(this.interval);
    }

    @Override
    public void stop() {
        ALog.i(TAG, "heartbeat stop", null, "session", this.session);
        this.isCancelled = true;
    }

    @Override
    public void delay() {
        long l2 = System.currentTimeMillis() + this.interval;
        if (this.executeTime + 1000L < l2) {
            if (ALog.isPrintLog(1)) {
                ALog.d(TAG, "setNextHeartbeat", null, "session", this.session, "offset", l2 - this.executeTime);
            }
            this.executeTime = l2;
        }
    }

    @Override
    public void run() {
        if (this.isCancelled) {
            return;
        }
        long l2 = System.currentTimeMillis();
        if (l2 < this.executeTime) {
            this.submit(this.executeTime - l2);
            return;
        }
        boolean bl = GlobalAppRuntimeInfo.isAppBackground();
        if (!bl) {
            if (ALog.isPrintLog(1)) {
                ALog.d(TAG, "heartbeat", null, "session", this.session);
            }
        } else {
            ALog.e(TAG, "close session in background", null, "session", this.session);
            this.session.close(false);
            return;
        }
        this.session.ping(true);
        this.bgHeartbeatCount = bl ? this.bgHeartbeatCount + 1 : 0;
        this.executeTime = l2 + this.interval;
        this.submit(this.interval);
    }

    private void submit(long l2) {
        try {
            c.a(this, l2 + 50L, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            ALog.e(TAG, "Submit heartbeat task to thread pool failed.", null, exception, new Object[0]);
        }
    }
}

