/*
 * Decompiled with CFR 0.152.
 */
package anet.channel.entity;

import android.text.TextUtils;
import anet.channel.strategy.l;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ConnType
implements Serializable {
    private static final long serialVersionUID = 4362386279661117076L;
    public static final String SPDY_STR = "spdy";
    public static final String HTTP2 = "http2";
    public static final String RTT_0 = "0rtt";
    public static final String RTT_1 = "1rtt";
    public static final String ACS = "acs";
    public static final String CDN = "cdn";
    public static final String OPEN = "open";
    public static ConnType HTTP = new ConnType("http");
    public static ConnType HTTPS = new ConnType("https");
    public static ConnType ACCS_0RTT = new ConnType("spdy_0rtt_acs", 4226, "acs");
    public static ConnType ACCS_1RTT = new ConnType("spdy_1rtt_acs", 8322, "acs");
    public static ConnType H2_ACCS_0RTT = new ConnType("http2_0rtt_acs", 4232, "acs");
    public static ConnType H2_ACCS_1RTT = new ConnType("http2_1rtt_acs", 8328, "acs");
    public static ConnType SPDY = new ConnType("spdy", 2, null);
    private static Map<String, ConnType> connTypeMap = new HashMap<String, ConnType>();
    private int spdyProtocol;
    private String publicKey;
    private String name = "";

    private ConnType(String string) {
        this.name = string;
    }

    private ConnType(String string, int n2, String string2) {
        this.spdyProtocol = n2;
        this.publicKey = string2;
        this.name = string;
    }

    public int getTnetConType() {
        return this.spdyProtocol;
    }

    public boolean isHttpType() {
        return this.equals(HTTP) || this.equals(HTTPS);
    }

    public boolean isSSL() {
        return this.equals(HTTPS) || (this.spdyProtocol & 0x80) != 0;
    }

    public String toProtocol() {
        return this.name;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public static ConnType valueOf(l.a a2) {
        if (TextUtils.isEmpty((CharSequence)a2.b) || "http".equals(a2.b)) {
            return HTTP;
        }
        if ("https".equals(a2.b)) {
            return HTTPS;
        }
        String string = ConnType.buildKey(a2);
        Map<String, ConnType> map = connTypeMap;
        synchronized (map) {
            if (connTypeMap.containsKey(string)) {
                return connTypeMap.get(string);
            }
            ConnType connType = new ConnType(string);
            connType.publicKey = a2.j;
            if (HTTP2.equals(a2.b)) {
                connType.spdyProtocol |= 8;
            } else if (SPDY_STR.equals(a2.b)) {
                connType.spdyProtocol |= 2;
            }
            if (connType.spdyProtocol == 0) {
                return null;
            }
            if (!TextUtils.isEmpty((CharSequence)a2.j)) {
                connType.spdyProtocol |= 0x80;
                connType.spdyProtocol = RTT_1.equals(a2.g) ? (connType.spdyProtocol |= 0x2000) : (connType.spdyProtocol |= 0x1000);
                if (a2.i) {
                    connType.spdyProtocol |= 0x4000;
                }
            }
            connTypeMap.put(string, connType);
            return connType;
        }
    }

    private static String buildKey(l.a a2) {
        if (TextUtils.isEmpty((CharSequence)a2.j)) {
            return a2.b;
        }
        StringBuilder stringBuilder = new StringBuilder(18);
        stringBuilder.append(a2.b);
        if (!TextUtils.isEmpty((CharSequence)a2.g)) {
            stringBuilder.append("_").append(a2.g);
        } else {
            stringBuilder.append("_0rtt");
        }
        stringBuilder.append("_");
        stringBuilder.append(a2.j);
        if (a2.i) {
            stringBuilder.append("_l7");
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ConnType)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        return this.name.equals(((ConnType)object).name);
    }

    public TypeLevel getTypeLevel() {
        if (this.isHttpType()) {
            return TypeLevel.HTTP;
        }
        return TypeLevel.SPDY;
    }

    private int getPriority() {
        if (this.isHttpType()) {
            return 1;
        }
        if ((this.spdyProtocol & 8) == 0) {
            return 0;
        }
        return -1;
    }

    public static int compare(ConnType connType, ConnType connType2) {
        return connType.getPriority() - connType2.getPriority();
    }

    static {
        connTypeMap.put("spdy_0rtt_acs", ACCS_0RTT);
        connTypeMap.put("spdy_1rtt_acs", ACCS_1RTT);
        connTypeMap.put("http2_0rtt_acs", H2_ACCS_0RTT);
        connTypeMap.put("http2_1rtt_acs", H2_ACCS_1RTT);
        connTypeMap.put(SPDY_STR, SPDY);
    }

    public static enum TypeLevel {
        SPDY,
        HTTP;

    }
}

