/*
 * Decompiled with CFR 0.152.
 */
package anet.channel.appmonitor;

import android.text.TextUtils;
import anet.channel.appmonitor.IAppMonitor;
import anet.channel.statist.AlarmObject;
import anet.channel.statist.AmdcStatistic;
import anet.channel.statist.CountObject;
import anet.channel.statist.Dimension;
import anet.channel.statist.ExceptionStatistic;
import anet.channel.statist.Measure;
import anet.channel.statist.Monitor;
import anet.channel.statist.RequestStatistic;
import anet.channel.statist.SessionStatistic;
import anet.channel.statist.StatObject;
import anet.channel.util.ALog;
import anet.channel.util.StringUtils;
import com.alibaba.mtl.appmonitor.AppMonitor;
import com.alibaba.mtl.appmonitor.model.DimensionSet;
import com.alibaba.mtl.appmonitor.model.DimensionValueSet;
import com.alibaba.mtl.appmonitor.model.MeasureSet;
import com.alibaba.mtl.appmonitor.model.MeasureValueSet;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

class DefaultAppMonitor
implements IAppMonitor {
    private static final String TAG = "awcn.DefaultAppMonitor";
    private static boolean mAppMonitorValid = false;
    private static AtomicBoolean isRegistered = new AtomicBoolean(false);
    private static Map<Class<?>, List<Field>> dimensionFieldsCache = new HashMap();
    private static Map<Class<?>, List<Field>> measureFieldsCache = new HashMap();

    DefaultAppMonitor() {
        try {
            Class.forName("com.alibaba.mtl.appmonitor.AppMonitor");
            mAppMonitorValid = true;
        }
        catch (Exception exception) {
            mAppMonitorValid = false;
        }
    }

    @Override
    public void register() {
        if (mAppMonitorValid) {
            if (isRegistered.compareAndSet(false, true)) {
                this.register(RequestStatistic.class);
                this.register(SessionStatistic.class);
                this.register(ExceptionStatistic.class);
                this.register(AmdcStatistic.class);
            }
        } else {
            ALog.w(TAG, "no appmonitor sdk", null, new Object[0]);
        }
    }

    @Override
    public void commitStat(StatObject statObject) {
        if (!mAppMonitorValid || statObject == null) {
            return;
        }
        Class<?> clazz = statObject.getClass();
        Monitor monitor = clazz.getAnnotation(Monitor.class);
        if (monitor == null) {
            return;
        }
        if (!statObject.beforeCommit()) {
            return;
        }
        try {
            DimensionValueSet dimensionValueSet = DimensionValueSet.create();
            MeasureValueSet measureValueSet = MeasureValueSet.create();
            List<Field> list = dimensionFieldsCache.get(clazz);
            HashMap<String, Object> hashMap = null;
            if (ALog.isPrintLog(1)) {
                hashMap = new HashMap<String, Object>();
            }
            if (list != null) {
                Object object;
                for (Field field : list) {
                    object = field.get(statObject);
                    dimensionValueSet.setValue(field.getName(), object == null ? "" : object.toString());
                }
                for (Field field : measureFieldsCache.get(clazz)) {
                    object = field.getDouble(statObject);
                    measureValueSet.setValue(field.getName(), ((Double)object).doubleValue());
                    if (hashMap == null) continue;
                    hashMap.put(field.getName(), object);
                }
            } else {
                Field[] fieldArray = clazz.getDeclaredFields();
                for (int i2 = 0; i2 < fieldArray.length; ++i2) {
                    Object object;
                    Field field = fieldArray[i2];
                    field.setAccessible(true);
                    if (field.isAnnotationPresent(Dimension.class)) {
                        object = field.get(statObject);
                        dimensionValueSet.setValue(field.getName(), object == null ? "" : object.toString());
                        continue;
                    }
                    if (!field.isAnnotationPresent(Measure.class)) continue;
                    object = field.getDouble(statObject);
                    measureValueSet.setValue(field.getName(), ((Double)object).doubleValue());
                    if (hashMap == null) continue;
                    hashMap.put(field.getName(), object);
                }
            }
            AppMonitor.Stat.commit((String)monitor.module(), (String)monitor.monitorPoint(), (DimensionValueSet)dimensionValueSet, (MeasureValueSet)measureValueSet);
            if (ALog.isPrintLog(1)) {
                ALog.d(TAG, "commit monitor point: " + monitor.monitorPoint(), null, "\nDimensions", dimensionValueSet.getMap().toString(), "\nMeasures", ((Object)hashMap).toString());
            }
        }
        catch (Throwable throwable) {
            ALog.e(TAG, "commit monitor point failed", null, throwable, new Object[0]);
        }
    }

    @Override
    public void commitAlarm(AlarmObject alarmObject) {
        if (!mAppMonitorValid || alarmObject == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)alarmObject.module) || TextUtils.isEmpty((CharSequence)alarmObject.modulePoint)) {
            return;
        }
        if (!alarmObject.isSuccess) {
            AppMonitor.Alarm.commitFail((String)alarmObject.module, (String)alarmObject.modulePoint, (String)StringUtils.stringNull2Empty(alarmObject.arg), (String)StringUtils.stringNull2Empty(alarmObject.errorCode), (String)StringUtils.stringNull2Empty(alarmObject.errorMsg));
        } else {
            AppMonitor.Alarm.commitSuccess((String)alarmObject.module, (String)alarmObject.modulePoint, (String)StringUtils.stringNull2Empty(alarmObject.arg));
        }
    }

    @Override
    public void commitCount(CountObject countObject) {
        if (!mAppMonitorValid || countObject == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)countObject.module) || TextUtils.isEmpty((CharSequence)countObject.modulePoint)) {
            return;
        }
        AppMonitor.Counter.commit((String)countObject.module, (String)countObject.modulePoint, (String)StringUtils.stringNull2Empty(countObject.arg), (double)countObject.value);
    }

    @Override
    public void register(Class<?> clazz) {
        if (clazz == null || !mAppMonitorValid) {
            return;
        }
        Monitor monitor = clazz.getAnnotation(Monitor.class);
        if (monitor == null) {
            return;
        }
        Field[] fieldArray = clazz.getDeclaredFields();
        ArrayList<Field> arrayList = new ArrayList<Field>();
        ArrayList<Field> arrayList2 = new ArrayList<Field>();
        DimensionSet dimensionSet = DimensionSet.create();
        MeasureSet measureSet = MeasureSet.create();
        for (int i2 = 0; i2 < fieldArray.length; ++i2) {
            Field field = fieldArray[i2];
            Dimension dimension = field.getAnnotation(Dimension.class);
            if (dimension != null) {
                field.setAccessible(true);
                arrayList.add(field);
                dimensionSet.addDimension(field.getName());
                continue;
            }
            Measure measure = field.getAnnotation(Measure.class);
            if (measure == null) continue;
            field.setAccessible(true);
            arrayList2.add(field);
            if (measure.max() != Double.MAX_VALUE) {
                measureSet.addMeasure(new com.alibaba.mtl.appmonitor.model.Measure(field.getName(), Double.valueOf(measure.constantValue()), Double.valueOf(measure.min()), Double.valueOf(measure.max())));
                continue;
            }
            measureSet.addMeasure(field.getName());
        }
        dimensionFieldsCache.put(clazz, arrayList);
        measureFieldsCache.put(clazz, arrayList2);
        AppMonitor.register((String)monitor.module(), (String)monitor.monitorPoint(), (MeasureSet)measureSet, (DimensionSet)dimensionSet);
    }
}

