/*
 * Decompiled with CFR 0.152.
 */
package anet.channel;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import anet.channel.GlobalAppRuntimeInfo;
import anet.channel.NoAvailStrategyException;
import anet.channel.NoNetworkException;
import anet.channel.Session;
import anet.channel.SessionCenter;
import anet.channel.appmonitor.AppMonitor;
import anet.channel.c.c;
import anet.channel.e;
import anet.channel.entity.ConnType;
import anet.channel.entity.EventType;
import anet.channel.f;
import anet.channel.g;
import anet.channel.h;
import anet.channel.session.AccsSession;
import anet.channel.session.i;
import anet.channel.session.k;
import anet.channel.statist.AlarmObject;
import anet.channel.status.NetworkStatusHelper;
import anet.channel.strategy.IConnStrategy;
import anet.channel.strategy.StrategyCenter;
import anet.channel.util.ALog;
import anet.channel.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class SessionRequest {
    String a;
    private String g;
    SessionCenter b;
    e c;
    volatile boolean d = false;
    volatile Session e;
    private volatile Future h;
    volatile boolean f = false;
    private Object i = new Object();

    SessionRequest(String string, SessionCenter sessionCenter) {
        this.a = string;
        this.g = this.a.substring(this.a.indexOf("://") + 3);
        this.b = sessionCenter;
        this.c = sessionCenter.sessionPool;
    }

    protected String a() {
        return this.a;
    }

    protected String b() {
        return this.g;
    }

    void a(boolean bl) {
        this.d = bl;
        if (!bl) {
            if (this.h != null) {
                this.h.cancel(true);
                this.h = null;
            }
            this.e = null;
        }
    }

    protected synchronized void a(Context context, ConnType.TypeLevel typeLevel, String string) throws NoNetworkException, NoAvailStrategyException {
        Object object;
        Object object2;
        Session session = this.c.a(this, typeLevel);
        if (session != null) {
            ALog.d("awcn.SessionRequest", "Available Session exist!!!", string, new Object[0]);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = anet.channel.util.i.a(null);
        }
        ALog.d("awcn.SessionRequest", "SessionRequest start", string, new Object[]{"host", this.a, "type", typeLevel});
        if (this.d) {
            ALog.d("awcn.SessionRequest", "session is connecting, return", string, "host", this.a());
            return;
        }
        this.a(true);
        this.h = anet.channel.c.c.a(new b(string), 45L, TimeUnit.SECONDS);
        if (!NetworkStatusHelper.f()) {
            if (ALog.isPrintLog(1)) {
                ALog.d("awcn.SessionRequest", "network is not available, can't create session", string, "NetworkStatusHelper.isConnected()", NetworkStatusHelper.f());
            }
            this.c();
            throw new NoNetworkException(this);
        }
        List<IConnStrategy> list = this.a(typeLevel, string);
        if (list.isEmpty()) {
            ALog.i("awcn.SessionRequest", "no strategy, can't create session", string, new Object[]{"host", this.a, "type", typeLevel});
            this.c();
            throw new NoAvailStrategyException(this);
        }
        if (typeLevel == ConnType.TypeLevel.HTTP) {
            object2 = list.listIterator();
            while (object2.hasNext()) {
                object = (IConnStrategy)object2.next();
                if (!anet.channel.session.e.a(this.a, object.getIp(), object.getPort())) continue;
                object2.remove();
            }
            if (list.isEmpty()) {
                ALog.i("awcn.SessionRequest", "all http strategies are removed.", null, new Object[0]);
                this.c();
            }
        }
        object2 = this.a(list, string);
        try {
            object = (anet.channel.entity.a)object2.remove(0);
            this.a(context, (anet.channel.entity.a)object, new a(context, (List<anet.channel.entity.a>)object2, (anet.channel.entity.a)object), ((anet.channel.entity.a)object).i());
        }
        catch (Throwable throwable) {
            this.c();
        }
    }

    private List<IConnStrategy> a(ConnType.TypeLevel typeLevel, String string) {
        List<IConnStrategy> list = Collections.EMPTY_LIST;
        try {
            String[] stringArray = StringUtils.parseURL(this.a());
            if (stringArray == null) {
                return Collections.EMPTY_LIST;
            }
            list = StrategyCenter.getInstance().getConnStrategyListByHost(stringArray[1]);
            if (!list.isEmpty()) {
                boolean bl = "https".equalsIgnoreCase(stringArray[0]);
                ListIterator<IConnStrategy> listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    IConnStrategy iConnStrategy = listIterator.next();
                    if (iConnStrategy.getConnType().isSSL() == bl && (typeLevel == null || iConnStrategy.getConnType().getTypeLevel() == typeLevel)) continue;
                    listIterator.remove();
                }
            }
            if (ALog.isPrintLog(1)) {
                ALog.d("awcn.SessionRequest", "[getAvailStrategy]", string, "strategies", list);
            }
        }
        catch (Throwable throwable) {
            ALog.e("awcn.SessionRequest", "", string, throwable, new Object[0]);
        }
        return list;
    }

    private List<anet.channel.entity.a> a(List<IConnStrategy> list, String string) {
        if (list.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<anet.channel.entity.a> arrayList = new ArrayList<anet.channel.entity.a>();
        int n2 = 0;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            IConnStrategy iConnStrategy = list.get(i2);
            int n3 = iConnStrategy.getRetryTimes();
            int n4 = 0;
            while (n4 <= n3) {
                anet.channel.entity.a a2 = new anet.channel.entity.a(this.a(), string + "_" + ++n2, iConnStrategy);
                a2.b = n4++;
                a2.c = n3;
                arrayList.add(a2);
            }
        }
        return arrayList;
    }

    private void a(Context context, anet.channel.entity.a a2, IConnCb iConnCb, String string) {
        ConnType connType = a2.c();
        if (context != null && !connType.isHttpType()) {
            if (a2.f()) {
                this.e = new AccsSession(context, a2);
                ((AccsSession)this.e).setFrameCb(this.b.accsFrameCb);
            } else {
                this.e = new i(context, a2);
            }
            ((k)this.e).setConfig(this.b.config);
        } else {
            this.e = new anet.channel.session.e(context, a2);
        }
        ALog.i("awcn.SessionRequest", "create connection...", string, "Host", this.a(), "Type", a2.c(), "IP", a2.a(), "Port", a2.b(), "heartbeat", a2.h(), "session", this.e);
        this.a(this.e, iConnCb, System.currentTimeMillis());
        this.e.connect();
    }

    private void a(Session session, IConnCb iConnCb, long l2) {
        if (iConnCb == null) {
            return;
        }
        session.registerEventcb(EventType.ALL.getType(), new f(this, iConnCb, l2));
        session.registerEventcb(EventType.CONNECTED.getType() | EventType.CONNECT_FAIL.getType() | EventType.AUTH_SUCC.getType() | EventType.AUTH_FAIL.getType(), new g(this, session));
    }

    protected void b(boolean bl) {
        List<Session> list;
        ALog.d("awcn.SessionRequest", "closeSessions", null, "host", this.a, "autoCreate", bl);
        if (!bl && this.e != null) {
            this.e.tryNextWhenFail = false;
            this.e.close(false);
        }
        if ((list = this.c.a(this)) != null) {
            for (Session session : list) {
                if (session == null) continue;
                session.close(bl);
            }
        }
    }

    protected void a(String string) {
        ALog.d("awcn.SessionRequest", "reCreateSession", string, "host", this.a);
        this.b(true);
    }

    protected void a(long l2) throws InterruptedException, TimeoutException {
        ALog.d("awcn.SessionRequest", "[await]", null, "timeoutMs", l2);
        if (l2 <= 0L) {
            return;
        }
        Object object = this.i;
        synchronized (object) {
            long l3;
            long l4 = System.currentTimeMillis() + l2;
            while (this.d && (l3 = System.currentTimeMillis()) < l4) {
                this.i.wait(l4 - l3);
            }
            if (this.d) {
                throw new TimeoutException();
            }
        }
    }

    protected void c() {
        this.a(false);
        Object object = this.i;
        synchronized (object) {
            this.i.notifyAll();
        }
    }

    protected void a(Session session, int n2, String string) {
        Context context = GlobalAppRuntimeInfo.getContext();
        if (context == null) {
            return;
        }
        String string2 = session.getRealHost();
        if (TextUtils.isEmpty((CharSequence)string2) || !string2.endsWith(this.b.config.getAccsHost())) {
            return;
        }
        try {
            Intent intent = new Intent("com.taobao.accs.intent.action.RECEIVE");
            intent.setPackage(context.getPackageName());
            intent.setClassName(context, "com.taobao.accs.data.MsgDistributeService");
            intent.putExtra("command", 103);
            intent.putExtra("host", session.getHost());
            intent.putExtra("is_center_host", string2.equals(this.b.config.getAccsHost()));
            boolean bl = session.isAvailable();
            if (!bl) {
                intent.putExtra("errorCode", n2);
                intent.putExtra("errorDetail", string);
            }
            intent.putExtra("connect_avail", bl);
            intent.putExtra("type_inapp", true);
            context.startService(intent);
        }
        catch (Throwable throwable) {
            ALog.e("awcn.SessionRequest", "sendConnectInfoBroadCastToAccs", null, throwable, new Object[0]);
        }
    }

    static class 1 {
        static final /* synthetic */ int[] a;

        static {
            a = new int[EventType.values().length];
            try {
                1.a[EventType.AUTH_SUCC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.a[EventType.DISCONNECTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.a[EventType.CONNECT_FAIL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
        }
    }

    private static interface IConnCb {
        public void onFailed(Session var1, long var2, EventType var4, int var5);

        public void onSuccess(Session var1, long var2);

        public void onDisConnect(Session var1, long var2, EventType var4);
    }

    class a
    implements IConnCb {
        private Context c;
        private List<anet.channel.entity.a> d;
        private anet.channel.entity.a e;
        boolean a = false;

        a(Context context, List<anet.channel.entity.a> list, anet.channel.entity.a a2) {
            this.c = context;
            this.d = list;
            this.e = a2;
        }

        @Override
        public void onFailed(Session session, long l2, EventType eventType, int n2) {
            if (ALog.isPrintLog(1)) {
                ALog.d("awcn.SessionRequest", "Connect failed", this.e.i(), "session", session, "host", SessionRequest.this.a(), "isHandleFinish", this.a);
            }
            if (SessionRequest.this.f) {
                SessionRequest.this.f = false;
                return;
            }
            if (this.a) {
                return;
            }
            this.a = true;
            SessionRequest sessionRequest = SessionRequest.this;
            sessionRequest.c.b(SessionRequest.this, session);
            if (!session.tryNextWhenFail) {
                return;
            }
            if (NetworkStatusHelper.f()) {
                if (this.d.size() > 0) {
                    if (ALog.isPrintLog(1)) {
                        ALog.d("awcn.SessionRequest", "use next connInfo to create session", this.e.i(), "host", SessionRequest.this.a());
                    }
                    anet.channel.entity.a a2 = this.d.remove(0);
                    SessionRequest.this.a(this.c, a2, new a(this.c, this.d, a2), a2.i());
                } else {
                    if (ALog.isPrintLog(1)) {
                        ALog.d("awcn.SessionRequest", "connInfo has used up,finish", this.e.i(), "host", SessionRequest.this.a());
                    }
                    SessionRequest.this.c();
                    if (EventType.CONNECT_FAIL.equals((Object)eventType) && n2 != -2613 && n2 != -2601) {
                        AlarmObject alarmObject = new AlarmObject();
                        alarmObject.module = "networkPrefer";
                        alarmObject.modulePoint = "policy";
                        sessionRequest = SessionRequest.this;
                        alarmObject.arg = sessionRequest.a;
                        alarmObject.errorCode = String.valueOf(n2);
                        alarmObject.isSuccess = false;
                        AppMonitor.getInstance().commitAlarm(alarmObject);
                    }
                }
            } else {
                SessionRequest.this.c();
            }
        }

        @Override
        public void onSuccess(Session session, long l2) {
            ALog.d("awcn.SessionRequest", "Connect Success", this.e.i(), "session", session, "host", SessionRequest.this.a());
            try {
                if (SessionRequest.this.f) {
                    SessionRequest.this.f = false;
                    session.close(false);
                    return;
                }
                SessionRequest sessionRequest = SessionRequest.this;
                sessionRequest.c.a(SessionRequest.this, session);
                if (session != null && session instanceof AccsSession) {
                    sessionRequest = SessionRequest.this;
                    ((AccsSession)session).setFrameCb(sessionRequest.b.accsFrameCb);
                    ALog.d("awcn.SessionRequest", "set Framecb success", null, "session", session);
                }
                AlarmObject alarmObject = new AlarmObject();
                alarmObject.module = "networkPrefer";
                alarmObject.modulePoint = "policy";
                sessionRequest = SessionRequest.this;
                alarmObject.arg = sessionRequest.a;
                alarmObject.isSuccess = true;
                AppMonitor.getInstance().commitAlarm(alarmObject);
            }
            catch (Exception exception) {
                ALog.e("awcn.SessionRequest", "[onSuccess]:", this.e.i(), exception, new Object[0]);
            }
            finally {
                SessionRequest.this.c();
            }
        }

        @Override
        public void onDisConnect(Session session, long l2, EventType eventType) {
            boolean bl = GlobalAppRuntimeInfo.isAppBackground();
            ALog.d("awcn.SessionRequest", "Connect Disconnect", this.e.i(), "session", session, "host", SessionRequest.this.a(), "appIsBg", bl, "isHandleFinish", this.a);
            SessionRequest sessionRequest = SessionRequest.this;
            sessionRequest.c.b(SessionRequest.this, session);
            if (this.a) {
                return;
            }
            this.a = true;
            if (!session.autoReCreate) {
                return;
            }
            if (bl) {
                ALog.e("awcn.SessionRequest", "[onDisConnect]app background, don't Recreate", this.e.i(), "session", session);
                return;
            }
            if (!NetworkStatusHelper.f()) {
                ALog.e("awcn.SessionRequest", "[onDisConnect]no network, don't Recreate", this.e.i(), "session", session);
                return;
            }
            try {
                ALog.d("awcn.SessionRequest", "session disconnected, try to recreate session", this.e.i(), new Object[0]);
                anet.channel.c.c.a(new h(this, session), (long)(Math.random() * 10.0 * 1000.0), TimeUnit.MILLISECONDS);
            }
            catch (Exception exception) {}
        }

        static /* synthetic */ Context a(a a2) {
            return a2.c;
        }
    }

    private class b
    implements Runnable {
        String a = null;

        b(String string) {
            this.a = string;
        }

        @Override
        public void run() {
            if (SessionRequest.this.d) {
                ALog.e("awcn.SessionRequest", "Connecting timeout!!! reset status!", this.a, new Object[0]);
                if (SessionRequest.this.e != null) {
                    SessionRequest.this.e.tryNextWhenFail = false;
                    SessionRequest.this.e.close();
                }
                boolean bl = false;
                SessionRequest sessionRequest = SessionRequest.this;
                sessionRequest.a(bl);
            }
        }
    }
}

