/*
 * Decompiled with CFR 0.152.
 */
package anet.channel;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import anet.channel.AccsFrameCb;
import anet.channel.AccsSessionManager;
import anet.channel.Config;
import anet.channel.GlobalAppRuntimeInfo;
import anet.channel.NoAvailStrategyException;
import anet.channel.NoNetworkException;
import anet.channel.Session;
import anet.channel.SessionRequest;
import anet.channel.appmonitor.AppMonitor;
import anet.channel.b;
import anet.channel.c.c;
import anet.channel.e;
import anet.channel.entity.ConnType;
import anet.channel.entity.ENV;
import anet.channel.session.AccsSession;
import anet.channel.status.NetworkStatusHelper;
import anet.channel.strategy.IStrategyListener;
import anet.channel.strategy.StrategyCenter;
import anet.channel.strategy.a;
import anet.channel.strategy.l;
import anet.channel.util.ALog;
import anet.channel.util.AppLifecycle;
import anet.channel.util.LruCache;
import anet.channel.util.StringUtils;
import anet.channel.util.Utils;
import anet.channel.util.i;
import java.net.ConnectException;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.android.spdy.SpdyAgent;
import org.android.spdy.SpdySessionKind;
import org.android.spdy.SpdyVersion;

public class SessionCenter {
    public static final String TAG = "awcn.SessionCenter";
    static Map<Config, SessionCenter> instancesMap = new HashMap<Config, SessionCenter>();
    private static boolean mInit = false;
    Context context;
    String seqNum;
    Config config;
    AccsFrameCb accsFrameCb;
    final e sessionPool = new e();
    final LruCache<String, SessionRequest> srCache = new LruCache(32);
    final AccsSessionManager accsSessionManager;
    final InnerListener innerListener = new InnerListener();

    public static synchronized void init(Context context) {
        if (context == null) {
            ALog.e(TAG, "paramter context is null!", null, new Object[0]);
            throw new NullPointerException("init failed. paramter context is null");
        }
        GlobalAppRuntimeInfo.setContext(context.getApplicationContext());
        if (!mInit) {
            instancesMap.put(Config.DEFAULT_CONFIG, new SessionCenter(Config.DEFAULT_CONFIG));
            AppLifecycle.a();
            StrategyCenter.getInstance().initialize();
            AppMonitor.getInstance().register();
            mInit = true;
        }
    }

    @Deprecated
    public static synchronized void init(Context context, String string) {
        SessionCenter.init(context, string, GlobalAppRuntimeInfo.getEnv());
    }

    public static synchronized void init(Context context, String string, ENV eNV) {
        if (context == null) {
            ALog.e(TAG, "paramter context is null!", null, new Object[0]);
            throw new NullPointerException("init failed. paramter context is null");
        }
        Config config = Config.getConfig(string, eNV);
        if (config == null) {
            config = new Config.Builder().setAppkey(string).setEnv(eNV).build();
        }
        SessionCenter.init(context, config);
    }

    public static synchronized void init(Context context, Config config) {
        if (context == null) {
            ALog.e(TAG, "paramter context is null!", null, new Object[0]);
            throw new NullPointerException("init failed. paramter context is null");
        }
        SessionCenter.init(context);
        if (!instancesMap.containsKey(config)) {
            SessionCenter sessionCenter = new SessionCenter(config);
            instancesMap.put(config, sessionCenter);
        }
    }

    private SessionCenter(Config config) {
        this.context = GlobalAppRuntimeInfo.getContext();
        this.config = config;
        this.seqNum = config.getAppkey();
        this.innerListener.registerAll();
        this.accsSessionManager = new AccsSessionManager(this);
        a.a(config.getAccsHost());
        if (TextUtils.isEmpty((CharSequence)GlobalAppRuntimeInfo.getAppKey()) && !config.getAppkey().equals("[default]")) {
            GlobalAppRuntimeInfo.setAppKeyAndSecurity(config.getAppkey(), config.getSecurity());
        }
    }

    private void dispose() {
        ALog.i(TAG, "instance dispose", this.seqNum, new Object[0]);
        this.accsSessionManager.forceCloseSession(false);
        a.b(this.config.getAccsHost());
        this.innerListener.unRegisterAll();
    }

    @Deprecated
    public synchronized void switchEnv(ENV eNV) {
        SessionCenter.switchEnvironment(eNV);
    }

    public static synchronized void switchEnvironment(ENV eNV) {
        try {
            Object object;
            if (GlobalAppRuntimeInfo.getEnv() != eNV) {
                ALog.i(TAG, "switch env", null, new Object[]{"old", GlobalAppRuntimeInfo.getEnv(), "new", eNV});
                GlobalAppRuntimeInfo.setEnv(eNV);
                StrategyCenter.getInstance().switchEnv();
                object = SpdyAgent.getInstance(GlobalAppRuntimeInfo.getContext(), SpdyVersion.SPDY3, SpdySessionKind.NONE_SESSION);
                ((SpdyAgent)object).switchAccsServer(eNV == ENV.TEST ? 0 : 1);
            }
            object = instancesMap.entrySet().iterator();
            while (object.hasNext()) {
                SessionCenter sessionCenter = object.next().getValue();
                if (sessionCenter.config.getEnv() == eNV) continue;
                ALog.i(TAG, "remove instance", sessionCenter.seqNum, new Object[]{"ENVIRONMENT", sessionCenter.config.getEnv()});
                sessionCenter.dispose();
                object.remove();
            }
        }
        catch (Throwable throwable) {
            ALog.e(TAG, "switch env error.", null, throwable, new Object[0]);
        }
    }

    public static synchronized SessionCenter getInstance(String string) {
        Config config = Config.getConfigByTag(string);
        if (config == null) {
            throw new RuntimeException("tag not exist!");
        }
        return SessionCenter.getInstance(config);
    }

    public static synchronized SessionCenter getInstance(Config config) {
        Object object;
        if (config == null) {
            throw new NullPointerException("config is null!");
        }
        if (!mInit && (object = Utils.getAppContext()) != null) {
            SessionCenter.init(object);
        }
        if ((object = instancesMap.get(config)) == null) {
            object = new SessionCenter(config);
            instancesMap.put(config, (SessionCenter)object);
        }
        return object;
    }

    @Deprecated
    public static synchronized SessionCenter getInstance() {
        Object object;
        if (!mInit && (object = Utils.getAppContext()) != null) {
            SessionCenter.init(object);
        }
        object = null;
        for (Map.Entry<Config, SessionCenter> entry : instancesMap.entrySet()) {
            object = entry.getValue();
            if (entry.getKey() == Config.DEFAULT_CONFIG) continue;
            return object;
        }
        return object;
    }

    public Session getThrowsException(String string, long l2) throws Exception {
        return this.getThrowsException(string, null, l2);
    }

    public Session getThrowsException(String string, ConnType.TypeLevel typeLevel, long l2) throws Exception {
        return this.getInternal(anet.channel.util.e.a(string), typeLevel, l2);
    }

    public Session getThrowsException(anet.channel.util.e e2, ConnType.TypeLevel typeLevel, long l2) throws Exception {
        return this.getInternal(e2, typeLevel, l2);
    }

    public Session get(String string, long l2) {
        return this.get(string, null, l2);
    }

    public Session get(String string, ConnType.TypeLevel typeLevel, long l2) {
        return this.get(anet.channel.util.e.a(string), typeLevel, l2);
    }

    public Session get(anet.channel.util.e e2, ConnType.TypeLevel typeLevel, long l2) {
        Session session = null;
        try {
            session = this.getInternal(e2, typeLevel, l2);
        }
        catch (InvalidParameterException invalidParameterException) {
            ALog.e(TAG, "[Get]param url is invaild, return null", null, invalidParameterException, "url", e2.d());
        }
        catch (TimeoutException timeoutException) {
            ALog.e(TAG, "[Get]get session timeout exception return null", null, timeoutException, "url", e2.d());
        }
        catch (NoNetworkException noNetworkException) {
            ALog.e(TAG, "[Get]get session no network return null", null, "url", e2.d());
        }
        catch (NoAvailStrategyException noAvailStrategyException) {
            ALog.w(TAG, "[Get]get session no strategy", null, "url", e2.d());
        }
        catch (Exception exception) {
            ALog.e(TAG, "[Get]get session exception return null", null, exception, "url", e2.d());
        }
        return session;
    }

    public boolean setDataReceiveCb(AccsFrameCb accsFrameCb) {
        ALog.e(TAG, "setDataReceiveCb", this.seqNum, "AccsFrameCb", accsFrameCb);
        this.accsFrameCb = accsFrameCb;
        for (SessionRequest sessionRequest : this.sessionPool.a()) {
            List<Session> list;
            if (!a.d(sessionRequest.b()) || (list = this.sessionPool.a(sessionRequest)) == null || list.isEmpty()) continue;
            for (Session session : list) {
                if (!(session instanceof AccsSession)) continue;
                AccsSession accsSession = (AccsSession)session;
                accsSession.setFrameCb(this.accsFrameCb);
            }
        }
        return true;
    }

    public void setAccsSessionCb(AccsSessionManager.Callback callback) {
        this.accsSessionManager.setAccsSessionCb(callback);
    }

    public static void checkAndStartAccsSession() {
        for (SessionCenter sessionCenter : instancesMap.values()) {
            sessionCenter.accsSessionManager.checkAndStartAccsSession();
        }
    }

    public void forceRecreateAccsSession() {
        this.accsSessionManager.forceReCreateSession();
    }

    protected Session getInternal(anet.channel.util.e e2, ConnType.TypeLevel typeLevel, long l2) throws Exception {
        Object object;
        String string;
        if (!mInit) {
            ALog.e(TAG, "getInternal not inited!", this.seqNum, new Object[0]);
            return null;
        }
        ALog.d(TAG, "getInternal", this.seqNum, new Object[]{"u", e2.d(), "TypeClass", typeLevel, "timeout", l2});
        if (e2 == null) {
            return null;
        }
        ALog.d(TAG, "getInternal", null, new Object[]{"httpUrl", e2.d(), "TypeClass", typeLevel, "timeout", l2});
        String string2 = StrategyCenter.getInstance().getCNameByHost(e2.b());
        if (string2 == null) {
            e2.g();
            string = e2.c();
        } else {
            object = StrategyCenter.getInstance().getSchemeByHost(string2, null);
            string = StringUtils.concatString((String)(object == null ? e2.a() : object), "://", string2);
        }
        object = this.getSessionRequest(string);
        Session session = this.sessionPool.a((SessionRequest)object, typeLevel);
        if (session != null) {
            ALog.d(TAG, "get internal hit cache session", this.seqNum, "session", session);
        } else {
            ((SessionRequest)object).a(this.context, typeLevel, i.a(this.seqNum));
            if (l2 > 0L) {
                ((SessionRequest)object).a(l2);
                session = this.sessionPool.a((SessionRequest)object, typeLevel);
                if (session == null) {
                    throw new ConnectException();
                }
            }
        }
        return session;
    }

    @Deprecated
    public void enterBackground() {
        AppLifecycle.c();
    }

    @Deprecated
    public void enterForeground() {
        AppLifecycle.b();
    }

    private void checkEffectNow(l.c c2) {
        l.b[] bArray = c2.c;
        for (int i2 = 0; i2 < bArray.length; ++i2) {
            l.b b2 = bArray[i2];
            if (!b2.q) continue;
            ALog.i(TAG, "find effectNow", this.seqNum, "host", b2.a);
            Object[] objectArray = b2.f;
            Object[] objectArray2 = b2.e;
            List<Session> list = this.sessionPool.a(this.getSessionRequest(StringUtils.buildKey(b2.c, b2.a)));
            for (Session session : list) {
                int n2;
                if (session.getConnType().isHttpType()) continue;
                boolean bl = false;
                for (n2 = 0; n2 < objectArray2.length; ++n2) {
                    if (!session.getIp().equals(objectArray2[n2])) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    if (ALog.isPrintLog(2)) {
                        ALog.i(TAG, "ip not match", this.seqNum, "session ip", session.getIp(), "ips", Arrays.toString(objectArray2));
                    }
                    session.close(true);
                    continue;
                }
                n2 = 0;
                for (int i3 = 0; i3 < objectArray.length; ++i3) {
                    if (session.getPort() != objectArray[i3].a || !session.getConnType().equals(ConnType.valueOf(objectArray[i3]))) continue;
                    n2 = 1;
                    break;
                }
                if (n2 == 0) {
                    if (ALog.isPrintLog(2)) {
                        ALog.i(TAG, "aisle not match", this.seqNum, "port", session.getPort(), "connType", session.getConnType(), "aisle", Arrays.toString(objectArray));
                    }
                    session.close(true);
                    continue;
                }
                ALog.i(TAG, "session matches, do nothing", null, new Object[0]);
            }
        }
    }

    protected SessionRequest getSessionRequest(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        SessionRequest sessionRequest = null;
        LruCache<String, SessionRequest> lruCache = this.srCache;
        synchronized (lruCache) {
            sessionRequest = (SessionRequest)this.srCache.get(string);
            if (sessionRequest == null) {
                sessionRequest = new SessionRequest(string, this);
                this.srCache.put(string, sessionRequest);
            }
        }
        return sessionRequest;
    }

    private class InnerListener
    implements NetworkStatusHelper.INetworkStatusChangeListener,
    IStrategyListener,
    AppLifecycle.AppLifecycleListener {
        boolean foreGroundCheckRunning = false;

        private InnerListener() {
        }

        void registerAll() {
            AppLifecycle.a(this);
            NetworkStatusHelper.a(this);
            StrategyCenter.getInstance().registerListener(this);
        }

        void unRegisterAll() {
            StrategyCenter.getInstance().unregisterListener(this);
            AppLifecycle.b(this);
            NetworkStatusHelper.b(this);
        }

        @Override
        public void onNetworkStatusChanged(NetworkStatusHelper.NetworkStatus networkStatus) {
            ALog.d(SessionCenter.TAG, "onNetworkStatusChanged. reCreateSession", SessionCenter.this.seqNum, new Object[]{"networkStatus", networkStatus});
            List<SessionRequest> list = SessionCenter.this.sessionPool.a();
            if (!list.isEmpty()) {
                for (SessionRequest sessionRequest : list) {
                    ALog.d(SessionCenter.TAG, "network change, try recreate session", SessionCenter.this.seqNum, new Object[0]);
                    sessionRequest.a(null);
                }
            } else {
                ALog.i(SessionCenter.TAG, "recreate session failed: infos is empty", SessionCenter.this.seqNum, new Object[0]);
            }
            SessionCenter.this.accsSessionManager.checkAndStartAccsSession();
        }

        @Override
        public void onStrategyUpdated(l.c c2) {
            SessionCenter.this.checkEffectNow(c2);
            SessionCenter.this.accsSessionManager.checkAndStartAccsSession();
        }

        @Override
        public void forground() {
            ALog.i(SessionCenter.TAG, "[forground]", SessionCenter.this.seqNum, new Object[0]);
            if (SessionCenter.this.context == null) {
                return;
            }
            if (this.foreGroundCheckRunning) {
                return;
            }
            this.foreGroundCheckRunning = true;
            if (!mInit) {
                ALog.e(SessionCenter.TAG, "forground not inited!", SessionCenter.this.seqNum, new Object[0]);
                return;
            }
            try {
                c.a(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (AppLifecycle.a != 0L && System.currentTimeMillis() - AppLifecycle.a > 300000L) {
                                SessionCenter.this.accsSessionManager.forceCloseSession(true);
                            } else {
                                SessionCenter.this.accsSessionManager.checkAndStartAccsSession();
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        finally {
                            InnerListener.this.foreGroundCheckRunning = false;
                        }
                    }
                });
            }
            catch (Exception exception) {}
        }

        @Override
        public void background() {
            ALog.i(SessionCenter.TAG, "[background]", SessionCenter.this.seqNum, new Object[0]);
            if (!mInit) {
                ALog.e(SessionCenter.TAG, "background not inited!", SessionCenter.this.seqNum, new Object[0]);
                return;
            }
            try {
                c.a(new Runnable(){

                    @Override
                    public void run() {
                        ALog.d(SessionCenter.TAG, "horse serial ride start", SessionCenter.this.seqNum, new Object[0]);
                        b.a();
                    }
                });
                StrategyCenter.getInstance().saveData();
                if ("OPPO".equalsIgnoreCase(Build.BRAND)) {
                    SessionCenter.this.accsSessionManager.forceCloseSession(false);
                }
            }
            catch (Exception exception) {}
        }
    }
}

