/*
 * Decompiled with CFR 0.152.
 */
package anet.channel;

import android.content.Context;
import anet.channel.RequestCb;
import anet.channel.c.c;
import anet.channel.entity.ConnType;
import anet.channel.entity.EventCb;
import anet.channel.entity.EventType;
import anet.channel.entity.a;
import anet.channel.entity.d;
import anet.channel.request.Cancelable;
import anet.channel.request.Request;
import anet.channel.statist.SessionStatistic;
import anet.channel.strategy.IConnStrategy;
import anet.channel.util.ALog;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.android.spdy.SpdyAgent;
import org.android.spdy.SpdySessionKind;
import org.android.spdy.SpdyVersion;

public abstract class Session
implements Comparable<Session> {
    private static final String TAG = "awcn.Session";
    protected Context mContext;
    Map<EventCb, Integer> mEventCallBacks = new LinkedHashMap<EventCb, Integer>();
    private boolean mIsConnTimeOut = false;
    protected String mHost;
    protected String mRealHost;
    protected String mIp;
    protected int mPort;
    protected String mProxyIp;
    protected int mProxyPort;
    protected ConnType mConnType;
    protected IConnStrategy mConnStrategy;
    protected Status mStatus = Status.DISCONNECTED;
    protected Runnable mRecvTimeOutRunnable;
    private Future<?> timeoutTaskFuture;
    public SessionStatistic mSessionStat;
    protected int mConnTimeout;
    protected int mReqTimeout;
    protected boolean isHorseRide;
    protected String mSeq;
    protected boolean autoReCreate = false;
    protected boolean tryNextWhenFail = true;

    public boolean sameSession(Session session) {
        if (session == null || this.mIp == null) {
            return false;
        }
        return this.mPort == session.mPort && this.mConnType == session.mConnType && this.mIp.equals(session.mIp);
    }

    public void setIsHorseRide(boolean bl) {
        this.isHorseRide = bl;
    }

    @Override
    public int compareTo(Session session) {
        return ConnType.compare(this.mConnType, session.mConnType);
    }

    public Session(Context context, a a2, ConnType connType) {
        this.mContext = context;
        this.mIp = a2.a();
        this.mPort = a2.b();
        this.mConnType = connType;
        this.mHost = a2.g();
        this.mRealHost = this.mHost.substring(this.mHost.indexOf("://") + 3);
        this.mReqTimeout = a2.e();
        this.mConnTimeout = a2.d();
        this.mConnStrategy = a2.a;
        this.mSessionStat = new SessionStatistic(a2);
        this.mSeq = a2.i();
    }

    public abstract Cancelable request(Request var1, RequestCb var2);

    public void sendCustomFrame(int n2, byte[] byArray, int n3) {
    }

    public void checkAvailable() {
        this.ping(true);
    }

    public static void configTnetALog(Context context, String string, int n2, int n3) {
        SpdyAgent spdyAgent = SpdyAgent.getInstance(context, SpdyVersion.SPDY3, SpdySessionKind.NONE_SESSION);
        if (spdyAgent != null && SpdyAgent.checkLoadSucc()) {
            spdyAgent.configLogFile(string, n2, n3);
        } else {
            ALog.e("agent null or configTnetALog load so fail!!!", null, "loadso", SpdyAgent.checkLoadSucc());
        }
    }

    protected void connect() {
    }

    public void close(boolean bl) {
        this.autoReCreate = bl;
        this.close();
    }

    public abstract void close();

    protected abstract Runnable getRecvTimeOutRunnable();

    public void ping(boolean bl) {
    }

    public void registerEventcb(int n2, EventCb eventCb) {
        if (this.mEventCallBacks != null) {
            this.mEventCallBacks.put(eventCb, n2);
        }
    }

    protected void unReceiveEventCb(EventCb eventCb) {
        if (this.mEventCallBacks != null) {
            this.mEventCallBacks.remove(eventCb);
        }
    }

    public abstract boolean isAvailable();

    public String getIp() {
        return this.mIp;
    }

    public int getPort() {
        return this.mPort;
    }

    public ConnType getConnType() {
        return this.mConnType;
    }

    public String getHost() {
        return this.mHost;
    }

    public String getRealHost() {
        return this.mRealHost;
    }

    public IConnStrategy getConnStrategy() {
        return this.mConnStrategy;
    }

    protected void handleCallbacks(EventType eventType, d d2) {
        c.a(new anet.channel.d(this, eventType, d2));
    }

    protected void onDisconnect() {
    }

    protected synchronized void notifyStatus(Status status, d d2) {
        ALog.e(TAG, "notifyStatus", this.mSeq, "status", status.name());
        if (status.equals((Object)this.mStatus)) {
            ALog.i(TAG, "ignore notifyStatus", this.mSeq, new Object[0]);
            return;
        }
        this.mStatus = status;
        switch (this.mStatus) {
            case CONNECTING: {
                break;
            }
            case CONNECTED: {
                this.handleCallbacks(EventType.CONNECTED, d2);
                break;
            }
            case DISCONNECTING: {
                break;
            }
            case CONNETFAIL: {
                this.handleCallbacks(EventType.CONNECT_FAIL, d2);
                break;
            }
            case DISCONNECTED: {
                this.onDisconnect();
                if (this.mIsConnTimeOut) break;
                this.handleCallbacks(EventType.DISCONNECTED, d2);
                break;
            }
            case AUTHING: {
                break;
            }
            case AUTH_SUCC: {
                this.handleCallbacks(EventType.AUTH_SUCC, d2);
                break;
            }
            case AUTH_FAIL: {
                this.handleCallbacks(EventType.AUTH_FAIL, d2);
            }
        }
    }

    protected void setPingTimeout() {
        if (this.mRecvTimeOutRunnable == null) {
            this.mRecvTimeOutRunnable = this.getRecvTimeOutRunnable();
        }
        this.cancelTimeout();
        long l2 = 40000L;
        if (this.mRecvTimeOutRunnable != null) {
            this.timeoutTaskFuture = c.a(this.mRecvTimeOutRunnable, l2, TimeUnit.MILLISECONDS);
        }
    }

    protected void cancelTimeout() {
        if (this.mRecvTimeOutRunnable != null && this.timeoutTaskFuture != null) {
            this.timeoutTaskFuture.cancel(true);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Session@[");
        stringBuilder.append(this.mSeq).append('|').append(this.mConnType).append(']');
        return stringBuilder.toString();
    }

    public static enum Status {
        CONNECTED,
        CONNECTING,
        CONNETFAIL,
        AUTHING,
        AUTH_SUCC,
        AUTH_FAIL,
        DISCONNECTED,
        DISCONNECTING;

    }
}

