/*
 * Decompiled with CFR 0.152.
 */
package anet.channel;

import android.text.TextUtils;
import anet.channel.Config;
import anet.channel.GlobalAppRuntimeInfo;
import anet.channel.SessionCenter;
import anet.channel.SessionRequest;
import anet.channel.entity.ConnType;
import anet.channel.status.NetworkStatusHelper;
import anet.channel.strategy.StrategyCenter;
import anet.channel.util.ALog;
import anet.channel.util.StringUtils;
import java.util.Arrays;

public class AccsSessionManager {
    private static final String TAG = "awcn.AccsSessionManager";
    public static final Callback DISABLE_AUTO_CONNTION = new anet.channel.a();
    SessionCenter sessionCenter = null;
    String[] sessionKeyArray = new String[0];
    volatile Callback cb = null;

    AccsSessionManager(SessionCenter sessionCenter) {
        this.sessionCenter = sessionCenter;
        this.cb = sessionCenter.config.getAccsSessionCb();
        if (GlobalAppRuntimeInfo.isTargetProcess() && this.cb == null) {
            this.cb = new a(sessionCenter.config);
        }
    }

    public void setAccsSessionCb(Callback callback) {
        this.cb = callback == null ? DISABLE_AUTO_CONNTION : callback;
    }

    public synchronized void checkAndStartAccsSession() {
        if (this.cb == null) {
            ALog.w(TAG, "accs session cb is null.", null, new Object[0]);
            return;
        }
        int n2 = this.cb.getSessionCount();
        if (this.sessionKeyArray.length != n2) {
            this.sessionKeyArray = Arrays.copyOf(this.sessionKeyArray, n2);
        }
        boolean bl = this.isNeedCheckSession();
        for (int i2 = 0; i2 < this.sessionKeyArray.length; ++i2) {
            String string = this.sessionKeyArray[i2];
            String string2 = this.cb.getSessionKey(i2);
            if (string2 == null && string != null || string2 != null && !string2.equalsIgnoreCase(string)) {
                this.closeSessions(string);
                this.sessionKeyArray[i2] = string2;
            }
            if (!bl) continue;
            try {
                if (TextUtils.isEmpty((CharSequence)string2)) continue;
                this.sessionCenter.get(string2, ConnType.TypeLevel.SPDY, 0L);
                continue;
            }
            catch (Exception exception) {
                ALog.e("start unit session failed", null, "host", string2);
            }
        }
    }

    public synchronized void forceReCreateSession() {
        this.forceCloseSession(true);
    }

    public synchronized void forceCloseSession(boolean bl) {
        if (ALog.isPrintLog(1)) {
            ALog.d(TAG, "forceCloseSession", this.sessionCenter.seqNum, "reCreate", bl);
        }
        for (int i2 = 0; i2 < this.sessionKeyArray.length; ++i2) {
            this.closeSessions(this.sessionKeyArray[i2]);
            this.sessionKeyArray[i2] = null;
        }
        if (bl) {
            this.checkAndStartAccsSession();
        }
    }

    private boolean isNeedCheckSession() {
        if (GlobalAppRuntimeInfo.isAppBackground()) {
            ALog.d(TAG, "app is background not need check accs session, return", this.sessionCenter.seqNum, "bg", true);
            return false;
        }
        if (!NetworkStatusHelper.f()) {
            ALog.d(TAG, "network is not available, not need check accs session, return", this.sessionCenter.seqNum, "network", NetworkStatusHelper.f());
            return false;
        }
        return true;
    }

    private void closeSessions(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        ALog.d(TAG, "closeSessions", this.sessionCenter.seqNum, "host", string);
        SessionRequest sessionRequest = this.sessionCenter.getSessionRequest(string);
        sessionRequest.b(false);
    }

    protected static class a
    implements Callback {
        protected Config a = null;

        protected a(Config config) {
            this.a = config;
        }

        @Override
        public int getSessionCount() {
            return this.a.isUnitEnable() ? 2 : 1;
        }

        @Override
        public String getSessionKey(int n2) {
            String string;
            if (n2 >= this.getSessionCount()) {
                throw new IllegalArgumentException("index exceeds count!");
            }
            String string2 = null;
            String string3 = null;
            if (n2 == 0) {
                string3 = this.a.getAccsHost();
            } else if (n2 == 1 && !TextUtils.isEmpty((CharSequence)(string = StrategyCenter.getInstance().getUnitPrefix(GlobalAppRuntimeInfo.getUserId(), GlobalAppRuntimeInfo.getUtdid())))) {
                string3 = StringUtils.concatString(string, this.a.getAccsHost());
            }
            if (string3 != null) {
                string = StrategyCenter.getInstance().getSchemeByHost(string3, null);
                if (TextUtils.isEmpty((CharSequence)string)) {
                    string = "https";
                }
                string2 = StringUtils.buildKey(string, string3);
            }
            return string2;
        }
    }

    public static interface Callback {
        public int getSessionCount();

        public String getSessionKey(int var1);
    }
}

