/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.message.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;

public class HttpRequest {
    public static final String CHARSET_UTF8 = "UTF-8";
    public static final String CONTENT_TYPE_FORM = "application/x-www-form-urlencoded";
    public static final String CONTENT_TYPE_JSON = "application/json";
    public static final String ENCODING_GZIP = "gzip";
    public static final String HEADER_ACCEPT = "Accept";
    public static final String HEADER_ACCEPT_CHARSET = "Accept-Charset";
    public static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    public static final String HEADER_AUTHORIZATION = "Authorization";
    public static final String HEADER_CACHE_CONTROL = "Cache-Control";
    public static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    public static final String HEADER_CONTENT_LENGTH = "Content-Length";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_DATE = "Date";
    public static final String HEADER_ETAG = "ETag";
    public static final String HEADER_EXPIRES = "Expires";
    public static final String HEADER_IF_NONE_MATCH = "If-None-Match";
    public static final String HEADER_LAST_MODIFIED = "Last-Modified";
    public static final String HEADER_LOCATION = "Location";
    public static final String HEADER_PROXY_AUTHORIZATION = "Proxy-Authorization";
    public static final String HEADER_REFERER = "Referer";
    public static final String HEADER_SERVER = "Server";
    public static final String HEADER_USER_AGENT = "User-Agent";
    public static final String METHOD_DELETE = "DELETE";
    public static final String METHOD_GET = "GET";
    public static final String METHOD_HEAD = "HEAD";
    public static final String METHOD_OPTIONS = "OPTIONS";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_TRACE = "TRACE";
    public static final String PARAM_CHARSET = "charset";
    private static final String BOUNDARY = "00content0boundary00";
    private static final String CONTENT_TYPE_MULTIPART = "multipart/form-data; boundary=00content0boundary00";
    private static final String CRLF = "\r\n";
    private static final String[] EMPTY_STRINGS = new String[0];
    private static SSLSocketFactory TRUSTED_FACTORY;
    private static HostnameVerifier TRUSTED_VERIFIER;
    private static int readTimeOut;
    private static int connectTimeout;
    private static ConnectionFactory CONNECTION_FACTORY;
    private HttpURLConnection connection = null;
    private final URL url;
    private final String requestMethod;
    private e output;
    private boolean multipart;
    private boolean form;
    private boolean ignoreCloseExceptions = true;
    private boolean uncompress = false;
    private int bufferSize = 8192;
    private String httpProxyHost;
    private int httpProxyPort;

    private static String getValidCharset(String string) {
        if (string != null && string.length() > 0) {
            return string;
        }
        return CHARSET_UTF8;
    }

    private static HostnameVerifier getTrustedVerifier() {
        if (TRUSTED_VERIFIER == null) {
            TRUSTED_VERIFIER = new HostnameVerifier(){

                @Override
                public boolean verify(String string, SSLSession sSLSession) {
                    return true;
                }
            };
        }
        return TRUSTED_VERIFIER;
    }

    private static HostnameVerifier getTrustedVerifier(final HttpsURLConnection httpsURLConnection) {
        if (TRUSTED_VERIFIER == null) {
            TRUSTED_VERIFIER = new HostnameVerifier(){

                @Override
                public boolean verify(String string, SSLSession sSLSession) {
                    String string2 = httpsURLConnection.getRequestProperty("Host");
                    if (null == string2) {
                        string2 = httpsURLConnection.getURL().getHost();
                    }
                    return HttpsURLConnection.getDefaultHostnameVerifier().verify(string2, sSLSession);
                }
            };
        }
        return TRUSTED_VERIFIER;
    }

    private static StringBuilder addPathSeparator(String string, StringBuilder stringBuilder) {
        if (string.indexOf(58) + 2 == string.lastIndexOf(47)) {
            stringBuilder.append('/');
        }
        return stringBuilder;
    }

    private static StringBuilder addParamPrefix(String string, StringBuilder stringBuilder) {
        int n2 = string.indexOf(63);
        int n3 = stringBuilder.length() - 1;
        if (n2 == -1) {
            stringBuilder.append('?');
        } else if (n2 < n3 && string.charAt(n3) != '&') {
            stringBuilder.append('&');
        }
        return stringBuilder;
    }

    public static void setConnectionFactory(ConnectionFactory connectionFactory) {
        CONNECTION_FACTORY = connectionFactory == null ? ConnectionFactory.DEFAULT : connectionFactory;
    }

    public static String encode(CharSequence charSequence) throws HttpRequestException {
        URL uRL;
        try {
            uRL = new URL(charSequence.toString());
        }
        catch (IOException iOException) {
            throw new HttpRequestException(iOException);
        }
        String string = uRL.getHost();
        int n2 = uRL.getPort();
        if (n2 != -1) {
            string = string + ':' + Integer.toString(n2);
        }
        try {
            String string2 = new URI(uRL.getProtocol(), string, uRL.getPath(), uRL.getQuery(), null).toASCIIString();
            int n3 = string2.indexOf(63);
            if (n3 > 0 && n3 + 1 < string2.length()) {
                string2 = string2.substring(0, n3 + 1) + string2.substring(n3 + 1).replace("+", "%2B");
            }
            return string2;
        }
        catch (URISyntaxException uRISyntaxException) {
            IOException iOException = new IOException("Parsing URI failed");
            iOException.initCause(uRISyntaxException);
            throw new HttpRequestException(iOException);
        }
    }

    public static String append(CharSequence charSequence, Map<?, ?> map) {
        String string = charSequence.toString();
        if (map == null || map.isEmpty()) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        HttpRequest.addPathSeparator(string, stringBuilder);
        HttpRequest.addParamPrefix(string, stringBuilder);
        Iterator<Map.Entry<?, ?>> iterator = map.entrySet().iterator();
        Map.Entry<?, ?> entry = iterator.next();
        stringBuilder.append(entry.getKey().toString());
        stringBuilder.append('=');
        Object obj = entry.getValue();
        if (obj != null) {
            stringBuilder.append(obj);
        }
        while (iterator.hasNext()) {
            stringBuilder.append('&');
            entry = iterator.next();
            stringBuilder.append(entry.getKey().toString());
            stringBuilder.append('=');
            obj = entry.getValue();
            if (obj == null) continue;
            stringBuilder.append(obj);
        }
        return stringBuilder.toString();
    }

    public static String append(CharSequence charSequence, Object ... objectArray) {
        String string = charSequence.toString();
        if (objectArray == null || objectArray.length == 0) {
            return string;
        }
        if (objectArray.length % 2 != 0) {
            throw new IllegalArgumentException("Must specify an even number of parameter names/values");
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        HttpRequest.addPathSeparator(string, stringBuilder);
        HttpRequest.addParamPrefix(string, stringBuilder);
        stringBuilder.append(objectArray[0]);
        stringBuilder.append('=');
        Object object = objectArray[1];
        if (object != null) {
            stringBuilder.append(object);
        }
        for (int i2 = 2; i2 < objectArray.length; i2 += 2) {
            stringBuilder.append('&');
            stringBuilder.append(objectArray[i2]);
            stringBuilder.append('=');
            object = objectArray[i2 + 1];
            if (object == null) continue;
            stringBuilder.append(object);
        }
        return stringBuilder.toString();
    }

    public static HttpRequest get(CharSequence charSequence) throws HttpRequestException {
        return new HttpRequest(charSequence, METHOD_GET);
    }

    public static HttpRequest get(URL uRL) throws HttpRequestException {
        return new HttpRequest(uRL, METHOD_GET);
    }

    public static HttpRequest get(CharSequence charSequence, Map<?, ?> map, boolean bl) {
        String string = HttpRequest.append(charSequence, map);
        return HttpRequest.get(bl ? HttpRequest.encode(string) : string);
    }

    public static HttpRequest get(CharSequence charSequence, boolean bl, Object ... objectArray) {
        String string = HttpRequest.append(charSequence, objectArray);
        return HttpRequest.get(bl ? HttpRequest.encode(string) : string);
    }

    public static HttpRequest post(CharSequence charSequence) throws HttpRequestException {
        HttpRequest httpRequest = new HttpRequest(charSequence, METHOD_POST);
        httpRequest.getConnection().setConnectTimeout(connectTimeout);
        httpRequest.getConnection().setReadTimeout(readTimeOut);
        return httpRequest;
    }

    public static HttpRequest post(URL uRL) throws HttpRequestException {
        HttpRequest httpRequest = new HttpRequest(uRL, METHOD_POST);
        httpRequest.getConnection().setConnectTimeout(connectTimeout);
        httpRequest.getConnection().setReadTimeout(readTimeOut);
        return httpRequest;
    }

    public static HttpRequest post(CharSequence charSequence, Map<?, ?> map, boolean bl) {
        String string = HttpRequest.append(charSequence, map);
        return HttpRequest.post(bl ? HttpRequest.encode(string) : string);
    }

    public static HttpRequest post(CharSequence charSequence, boolean bl, Object ... objectArray) {
        String string = HttpRequest.append(charSequence, objectArray);
        return HttpRequest.post(bl ? HttpRequest.encode(string) : string);
    }

    public static HttpRequest put(CharSequence charSequence) throws HttpRequestException {
        return new HttpRequest(charSequence, METHOD_PUT);
    }

    public static HttpRequest put(URL uRL) throws HttpRequestException {
        return new HttpRequest(uRL, METHOD_PUT);
    }

    public static HttpRequest put(CharSequence charSequence, Map<?, ?> map, boolean bl) {
        String string = HttpRequest.append(charSequence, map);
        return HttpRequest.put(bl ? HttpRequest.encode(string) : string);
    }

    public static HttpRequest put(CharSequence charSequence, boolean bl, Object ... objectArray) {
        String string = HttpRequest.append(charSequence, objectArray);
        return HttpRequest.put(bl ? HttpRequest.encode(string) : string);
    }

    public static HttpRequest delete(CharSequence charSequence) throws HttpRequestException {
        return new HttpRequest(charSequence, METHOD_DELETE);
    }

    public static HttpRequest delete(URL uRL) throws HttpRequestException {
        return new HttpRequest(uRL, METHOD_DELETE);
    }

    public static HttpRequest delete(CharSequence charSequence, Map<?, ?> map, boolean bl) {
        String string = HttpRequest.append(charSequence, map);
        return HttpRequest.delete(bl ? HttpRequest.encode(string) : string);
    }

    public static HttpRequest delete(CharSequence charSequence, boolean bl, Object ... objectArray) {
        String string = HttpRequest.append(charSequence, objectArray);
        return HttpRequest.delete(bl ? HttpRequest.encode(string) : string);
    }

    public static HttpRequest head(CharSequence charSequence) throws HttpRequestException {
        return new HttpRequest(charSequence, METHOD_HEAD);
    }

    public static HttpRequest head(URL uRL) throws HttpRequestException {
        return new HttpRequest(uRL, METHOD_HEAD);
    }

    public static HttpRequest head(CharSequence charSequence, Map<?, ?> map, boolean bl) {
        String string = HttpRequest.append(charSequence, map);
        return HttpRequest.head(bl ? HttpRequest.encode(string) : string);
    }

    public static HttpRequest head(CharSequence charSequence, boolean bl, Object ... objectArray) {
        String string = HttpRequest.append(charSequence, objectArray);
        return HttpRequest.head(bl ? HttpRequest.encode(string) : string);
    }

    public static HttpRequest options(CharSequence charSequence) throws HttpRequestException {
        return new HttpRequest(charSequence, METHOD_OPTIONS);
    }

    public static HttpRequest options(URL uRL) throws HttpRequestException {
        return new HttpRequest(uRL, METHOD_OPTIONS);
    }

    public static HttpRequest trace(CharSequence charSequence) throws HttpRequestException {
        return new HttpRequest(charSequence, METHOD_TRACE);
    }

    public static HttpRequest trace(URL uRL) throws HttpRequestException {
        return new HttpRequest(uRL, METHOD_TRACE);
    }

    public static void keepAlive(boolean bl) {
        HttpRequest.setProperty("http.keepAlive", Boolean.toString(bl));
    }

    public static void proxyHost(String string) {
        HttpRequest.setProperty("http.proxyHost", string);
        HttpRequest.setProperty("https.proxyHost", string);
    }

    public static void proxyPort(int n2) {
        String string = Integer.toString(n2);
        HttpRequest.setProperty("http.proxyPort", string);
        HttpRequest.setProperty("https.proxyPort", string);
    }

    public static void nonProxyHosts(String ... stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = stringArray.length - 1;
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuilder.append(stringArray[i2]).append('|');
            }
            stringBuilder.append(stringArray[n2]);
            HttpRequest.setProperty("http.nonProxyHosts", stringBuilder.toString());
        } else {
            HttpRequest.setProperty("http.nonProxyHosts", null);
        }
    }

    private static String setProperty(final String string, final String string2) {
        PrivilegedAction<String> privilegedAction = string2 != null ? new PrivilegedAction<String>(){

            public String a() {
                return System.setProperty(string, string2);
            }

            @Override
            public /* synthetic */ Object run() {
                return this.a();
            }
        } : new PrivilegedAction<String>(){

            public String a() {
                return System.clearProperty(string);
            }

            @Override
            public /* synthetic */ Object run() {
                return this.a();
            }
        };
        return AccessController.doPrivileged(privilegedAction);
    }

    public HttpRequest(CharSequence charSequence, String string) throws HttpRequestException {
        try {
            this.url = new URL(charSequence.toString());
        }
        catch (MalformedURLException malformedURLException) {
            throw new HttpRequestException(malformedURLException);
        }
        this.requestMethod = string;
    }

    public HttpRequest(URL uRL, String string) throws HttpRequestException {
        this.url = uRL;
        this.requestMethod = string;
    }

    private Proxy createProxy() {
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.httpProxyHost, this.httpProxyPort));
    }

    private HttpURLConnection createConnection() {
        try {
            HttpURLConnection httpURLConnection = this.httpProxyHost != null ? CONNECTION_FACTORY.create(this.url, this.createProxy()) : CONNECTION_FACTORY.create(this.url);
            httpURLConnection.setRequestMethod(this.requestMethod);
            return httpURLConnection;
        }
        catch (IOException iOException) {
            throw new HttpRequestException(iOException);
        }
    }

    public String toString() {
        return this.method() + ' ' + this.url();
    }

    public HttpURLConnection getConnection() {
        if (this.connection == null) {
            this.connection = this.createConnection();
        }
        return this.connection;
    }

    public HttpRequest ignoreCloseExceptions(boolean bl) {
        this.ignoreCloseExceptions = bl;
        return this;
    }

    public boolean ignoreCloseExceptions() {
        return this.ignoreCloseExceptions;
    }

    public int code() throws HttpRequestException {
        try {
            this.closeOutput();
            return this.getConnection().getResponseCode();
        }
        catch (IOException iOException) {
            throw new HttpRequestException(iOException);
        }
    }

    public HttpRequest code(AtomicInteger atomicInteger) throws HttpRequestException {
        atomicInteger.set(this.code());
        return this;
    }

    public boolean ok() throws HttpRequestException {
        return 200 == this.code();
    }

    public boolean created() throws HttpRequestException {
        return 201 == this.code();
    }

    public boolean serverError() throws HttpRequestException {
        return 500 == this.code();
    }

    public boolean badRequest() throws HttpRequestException {
        return 400 == this.code();
    }

    public boolean notFound() throws HttpRequestException {
        return 404 == this.code();
    }

    public boolean notModified() throws HttpRequestException {
        return 304 == this.code();
    }

    public String message() throws HttpRequestException {
        try {
            this.closeOutput();
            return this.getConnection().getResponseMessage();
        }
        catch (IOException iOException) {
            throw new HttpRequestException(iOException);
        }
    }

    public HttpRequest disconnect() {
        this.getConnection().disconnect();
        return this;
    }

    public HttpRequest chunk(int n2) {
        this.getConnection().setChunkedStreamingMode(n2);
        return this;
    }

    public HttpRequest bufferSize(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("Size must be greater than zero");
        }
        this.bufferSize = n2;
        return this;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public HttpRequest uncompress(boolean bl) {
        this.uncompress = bl;
        return this;
    }

    protected ByteArrayOutputStream byteStream() {
        int n2 = this.contentLength();
        if (n2 > 0) {
            return new ByteArrayOutputStream(n2);
        }
        return new ByteArrayOutputStream();
    }

    public String body(String string) throws HttpRequestException {
        ByteArrayOutputStream byteArrayOutputStream = this.byteStream();
        try {
            this.copy(this.buffer(), byteArrayOutputStream);
            return byteArrayOutputStream.toString(HttpRequest.getValidCharset(string));
        }
        catch (IOException iOException) {
            throw new HttpRequestException(iOException);
        }
    }

    public String body() throws HttpRequestException {
        return this.body(this.charset());
    }

    public HttpRequest body(AtomicReference<String> atomicReference) throws HttpRequestException {
        atomicReference.set(this.body());
        return this;
    }

    public HttpRequest body(AtomicReference<String> atomicReference, String string) throws HttpRequestException {
        atomicReference.set(this.body(string));
        return this;
    }

    public boolean isBodyEmpty() throws HttpRequestException {
        return this.contentLength() == 0;
    }

    public byte[] bytes() throws HttpRequestException {
        ByteArrayOutputStream byteArrayOutputStream = this.byteStream();
        try {
            this.copy(this.buffer(), byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new HttpRequestException(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public BufferedInputStream buffer() throws HttpRequestException {
        return new BufferedInputStream(this.stream(), this.bufferSize);
    }

    public InputStream stream() throws HttpRequestException {
        InputStream inputStream;
        if (this.code() < 400) {
            try {
                inputStream = this.getConnection().getInputStream();
            }
            catch (IOException iOException) {
                throw new HttpRequestException(iOException);
            }
        }
        inputStream = this.getConnection().getErrorStream();
        if (inputStream == null) {
            try {
                inputStream = this.getConnection().getInputStream();
            }
            catch (IOException iOException) {
                throw new HttpRequestException(iOException);
            }
        }
        if (!this.uncompress || !ENCODING_GZIP.equals(this.contentEncoding())) {
            return inputStream;
        }
        try {
            return new GZIPInputStream(inputStream);
        }
        catch (IOException iOException) {
            throw new HttpRequestException(iOException);
        }
    }

    public InputStreamReader reader(String string) throws HttpRequestException {
        try {
            return new InputStreamReader(this.stream(), HttpRequest.getValidCharset(string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new HttpRequestException(unsupportedEncodingException);
        }
    }

    public InputStreamReader reader() throws HttpRequestException {
        return this.reader(this.charset());
    }

    public BufferedReader bufferedReader(String string) throws HttpRequestException {
        return new BufferedReader(this.reader(string), this.bufferSize);
    }

    public BufferedReader bufferedReader() throws HttpRequestException {
        return this.bufferedReader(this.charset());
    }

    public HttpRequest receive(File file) throws HttpRequestException {
        BufferedOutputStream bufferedOutputStream;
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file), this.bufferSize);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new HttpRequestException(fileNotFoundException);
        }
        return (HttpRequest)new b<HttpRequest>((Closeable)bufferedOutputStream, this.ignoreCloseExceptions){

            protected HttpRequest a() throws HttpRequestException, IOException {
                return HttpRequest.this.receive(bufferedOutputStream);
            }

            @Override
            protected /* synthetic */ Object b() throws HttpRequestException, IOException {
                return this.a();
            }
        }.call();
    }

    public HttpRequest receive(OutputStream outputStream) throws HttpRequestException {
        try {
            return this.copy(this.buffer(), outputStream);
        }
        catch (IOException iOException) {
            throw new HttpRequestException(iOException);
        }
    }

    public HttpRequest receive(PrintStream printStream) throws HttpRequestException {
        return this.receive((OutputStream)printStream);
    }

    public HttpRequest receive(final Appendable appendable) throws HttpRequestException {
        final BufferedReader bufferedReader = this.bufferedReader();
        return (HttpRequest)new b<HttpRequest>((Closeable)bufferedReader, this.ignoreCloseExceptions){

            public HttpRequest a() throws IOException {
                int n2;
                CharBuffer charBuffer = CharBuffer.allocate(HttpRequest.this.bufferSize);
                while ((n2 = bufferedReader.read(charBuffer)) != -1) {
                    charBuffer.rewind();
                    appendable.append(charBuffer, 0, n2);
                    charBuffer.rewind();
                }
                return HttpRequest.this;
            }

            @Override
            public /* synthetic */ Object b() throws HttpRequestException, IOException {
                return this.a();
            }
        }.call();
    }

    public HttpRequest receive(final Writer writer) throws HttpRequestException {
        final BufferedReader bufferedReader = this.bufferedReader();
        return (HttpRequest)new b<HttpRequest>((Closeable)bufferedReader, this.ignoreCloseExceptions){

            public HttpRequest a() throws IOException {
                return HttpRequest.this.copy(bufferedReader, writer);
            }

            @Override
            public /* synthetic */ Object b() throws HttpRequestException, IOException {
                return this.a();
            }
        }.call();
    }

    public HttpRequest readTimeout(int n2) {
        this.getConnection().setReadTimeout(n2);
        return this;
    }

    public HttpRequest connectTimeout(int n2) {
        this.getConnection().setConnectTimeout(n2);
        return this;
    }

    public HttpRequest header(String string, String string2) {
        this.getConnection().setRequestProperty(string, string2);
        return this;
    }

    public HttpRequest header(String string, Number number) {
        return this.header(string, number != null ? number.toString() : null);
    }

    public HttpRequest headers(Map<String, String> map) {
        if (!map.isEmpty()) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.header(entry);
            }
        }
        return this;
    }

    public HttpRequest header(Map.Entry<String, String> entry) {
        return this.header(entry.getKey(), entry.getValue());
    }

    public String header(String string) throws HttpRequestException {
        this.closeOutputQuietly();
        return this.getConnection().getHeaderField(string);
    }

    public Map<String, List<String>> headers() throws HttpRequestException {
        this.closeOutputQuietly();
        return this.getConnection().getHeaderFields();
    }

    public long dateHeader(String string) throws HttpRequestException {
        return this.dateHeader(string, -1L);
    }

    public long dateHeader(String string, long l2) throws HttpRequestException {
        this.closeOutputQuietly();
        return this.getConnection().getHeaderFieldDate(string, l2);
    }

    public int intHeader(String string) throws HttpRequestException {
        return this.intHeader(string, -1);
    }

    public int intHeader(String string, int n2) throws HttpRequestException {
        this.closeOutputQuietly();
        return this.getConnection().getHeaderFieldInt(string, n2);
    }

    public String[] headers(String string) {
        Map<String, List<String>> map = this.headers();
        if (map == null || map.isEmpty()) {
            return EMPTY_STRINGS;
        }
        List<String> list = map.get(string);
        if (list != null && !list.isEmpty()) {
            return list.toArray(new String[list.size()]);
        }
        return EMPTY_STRINGS;
    }

    public String parameter(String string, String string2) {
        return this.getParam(this.header(string), string2);
    }

    public Map<String, String> parameters(String string) {
        return this.getParams(this.header(string));
    }

    protected Map<String, String> getParams(String string) {
        if (string == null || string.length() == 0) {
            return Collections.emptyMap();
        }
        int n2 = string.length();
        int n3 = string.indexOf(59) + 1;
        if (n3 == 0 || n3 == n2) {
            return Collections.emptyMap();
        }
        int n4 = string.indexOf(59, n3);
        if (n4 == -1) {
            n4 = n2;
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        while (n3 < n4) {
            String string2;
            int n5;
            String string3;
            int n6 = string.indexOf(61, n3);
            if (n6 != -1 && n6 < n4 && (string3 = string.substring(n3, n6).trim()).length() > 0 && (n5 = (string2 = string.substring(n6 + 1, n4).trim()).length()) != 0) {
                if (n5 > 2 && '\"' == string2.charAt(0) && '\"' == string2.charAt(n5 - 1)) {
                    linkedHashMap.put(string3, string2.substring(1, n5 - 1));
                } else {
                    linkedHashMap.put(string3, string2);
                }
            }
            if ((n4 = string.indexOf(59, n3 = n4 + 1)) != -1) continue;
            n4 = n2;
        }
        return linkedHashMap;
    }

    protected String getParam(String string, String string2) {
        if (string == null || string.length() == 0) {
            return null;
        }
        int n2 = string.length();
        int n3 = string.indexOf(59) + 1;
        if (n3 == 0 || n3 == n2) {
            return null;
        }
        int n4 = string.indexOf(59, n3);
        if (n4 == -1) {
            n4 = n2;
        }
        while (n3 < n4) {
            String string3;
            int n5;
            int n6 = string.indexOf(61, n3);
            if (n6 != -1 && n6 < n4 && string2.equals(string.substring(n3, n6).trim()) && (n5 = (string3 = string.substring(n6 + 1, n4).trim()).length()) != 0) {
                if (n5 > 2 && '\"' == string3.charAt(0) && '\"' == string3.charAt(n5 - 1)) {
                    return string3.substring(1, n5 - 1);
                }
                return string3;
            }
            n3 = n4 + 1;
            if ((n4 = string.indexOf(59, n3)) != -1) continue;
            n4 = n2;
        }
        return null;
    }

    public String charset() {
        return this.parameter(HEADER_CONTENT_TYPE, PARAM_CHARSET);
    }

    public HttpRequest userAgent(String string) {
        return this.header(HEADER_USER_AGENT, string);
    }

    public HttpRequest referer(String string) {
        return this.header(HEADER_REFERER, string);
    }

    public HttpRequest useCaches(boolean bl) {
        this.getConnection().setUseCaches(bl);
        return this;
    }

    public HttpRequest acceptEncoding(String string) {
        return this.header(HEADER_ACCEPT_ENCODING, string);
    }

    public HttpRequest acceptGzipEncoding() {
        return this.acceptEncoding(ENCODING_GZIP);
    }

    public HttpRequest acceptCharset(String string) {
        return this.header(HEADER_ACCEPT_CHARSET, string);
    }

    public String contentEncoding() {
        return this.header(HEADER_CONTENT_ENCODING);
    }

    public String server() {
        return this.header(HEADER_SERVER);
    }

    public long date() {
        return this.dateHeader(HEADER_DATE);
    }

    public String cacheControl() {
        return this.header(HEADER_CACHE_CONTROL);
    }

    public String eTag() {
        return this.header(HEADER_ETAG);
    }

    public long expires() {
        return this.dateHeader(HEADER_EXPIRES);
    }

    public long lastModified() {
        return this.dateHeader(HEADER_LAST_MODIFIED);
    }

    public String location() {
        return this.header(HEADER_LOCATION);
    }

    public HttpRequest authorization(String string) {
        return this.header(HEADER_AUTHORIZATION, string);
    }

    public HttpRequest proxyAuthorization(String string) {
        return this.header(HEADER_PROXY_AUTHORIZATION, string);
    }

    public HttpRequest basic(String string, String string2) {
        return this.authorization("Basic " + a.a(string + ':' + string2));
    }

    public HttpRequest proxyBasic(String string, String string2) {
        return this.proxyAuthorization("Basic " + a.a(string + ':' + string2));
    }

    public HttpRequest ifModifiedSince(long l2) {
        this.getConnection().setIfModifiedSince(l2);
        return this;
    }

    public HttpRequest ifNoneMatch(String string) {
        return this.header(HEADER_IF_NONE_MATCH, string);
    }

    public HttpRequest contentType(String string) {
        return this.contentType(string, null);
    }

    public HttpRequest contentType(String string, String string2) {
        if (string2 != null && string2.length() > 0) {
            String string3 = "; charset=";
            return this.header(HEADER_CONTENT_TYPE, string + "; charset=" + string2);
        }
        return this.header(HEADER_CONTENT_TYPE, string);
    }

    public String contentType() {
        return this.header(HEADER_CONTENT_TYPE);
    }

    public int contentLength() {
        return this.intHeader(HEADER_CONTENT_LENGTH);
    }

    public HttpRequest contentLength(String string) {
        return this.contentLength(Integer.parseInt(string));
    }

    public HttpRequest contentLength(int n2) {
        this.getConnection().setFixedLengthStreamingMode(n2);
        return this;
    }

    public HttpRequest accept(String string) {
        return this.header(HEADER_ACCEPT, string);
    }

    public HttpRequest acceptJson() {
        return this.accept(CONTENT_TYPE_JSON);
    }

    protected HttpRequest copy(final InputStream inputStream, final OutputStream outputStream) throws IOException {
        return (HttpRequest)new b<HttpRequest>((Closeable)inputStream, this.ignoreCloseExceptions){

            public HttpRequest a() throws IOException {
                int n2;
                byte[] byArray = new byte[HttpRequest.this.bufferSize];
                while ((n2 = inputStream.read(byArray)) != -1) {
                    outputStream.write(byArray, 0, n2);
                }
                return HttpRequest.this;
            }

            @Override
            public /* synthetic */ Object b() throws HttpRequestException, IOException {
                return this.a();
            }
        }.call();
    }

    protected HttpRequest copy(final Reader reader, final Writer writer) throws IOException {
        return (HttpRequest)new b<HttpRequest>((Closeable)reader, this.ignoreCloseExceptions){

            public HttpRequest a() throws IOException {
                int n2;
                char[] cArray = new char[HttpRequest.this.bufferSize];
                while ((n2 = reader.read(cArray)) != -1) {
                    writer.write(cArray, 0, n2);
                }
                return HttpRequest.this;
            }

            @Override
            public /* synthetic */ Object b() throws HttpRequestException, IOException {
                return this.a();
            }
        }.call();
    }

    protected HttpRequest closeOutput() throws IOException {
        if (this.output == null) {
            return this;
        }
        if (this.multipart) {
            this.output.a("\r\n--00content0boundary00--\r\n");
        }
        if (this.ignoreCloseExceptions) {
            try {
                this.output.close();
            }
            catch (IOException iOException) {}
        } else {
            this.output.close();
        }
        this.output = null;
        return this;
    }

    protected HttpRequest closeOutputQuietly() throws HttpRequestException {
        try {
            return this.closeOutput();
        }
        catch (IOException iOException) {
            throw new HttpRequestException(iOException);
        }
    }

    protected HttpRequest openOutput() throws IOException {
        if (this.output != null) {
            return this;
        }
        this.getConnection().setDoOutput(true);
        String string = this.getParam(this.getConnection().getRequestProperty(HEADER_CONTENT_TYPE), PARAM_CHARSET);
        this.output = new e(this.getConnection().getOutputStream(), string, this.bufferSize);
        return this;
    }

    protected HttpRequest startPart() throws IOException {
        if (!this.multipart) {
            this.multipart = true;
            this.contentType(CONTENT_TYPE_MULTIPART).openOutput();
            this.output.a("--00content0boundary00\r\n");
        } else {
            this.output.a("\r\n--00content0boundary00\r\n");
        }
        return this;
    }

    protected HttpRequest writePartHeader(String string, String string2) throws IOException {
        return this.writePartHeader(string, string2, null);
    }

    protected HttpRequest writePartHeader(String string, String string2, String string3) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("form-data; name=\"").append(string);
        if (string2 != null) {
            stringBuilder.append("\"; filename=\"").append(string2);
        }
        stringBuilder.append('\"');
        this.partHeader("Content-Disposition", stringBuilder.toString());
        if (string3 != null) {
            this.partHeader(HEADER_CONTENT_TYPE, string3);
        }
        return this.send(CRLF);
    }

    public HttpRequest part(String string, String string2) {
        return this.part(string, null, string2);
    }

    public HttpRequest part(String string, String string2, String string3) throws HttpRequestException {
        return this.part(string, string2, null, string3);
    }

    public HttpRequest part(String string, String string2, String string3, String string4) throws HttpRequestException {
        try {
            this.startPart();
            this.writePartHeader(string, string2, string3);
            this.output.a(string4);
        }
        catch (IOException iOException) {
            throw new HttpRequestException(iOException);
        }
        return this;
    }

    public HttpRequest part(String string, Number number) throws HttpRequestException {
        return this.part(string, null, number);
    }

    public HttpRequest part(String string, String string2, Number number) throws HttpRequestException {
        return this.part(string, string2, number != null ? number.toString() : null);
    }

    public HttpRequest part(String string, File file) throws HttpRequestException {
        return this.part(string, null, file);
    }

    public HttpRequest part(String string, String string2, File file) throws HttpRequestException {
        return this.part(string, string2, null, file);
    }

    public HttpRequest part(String string, String string2, String string3, File file) throws HttpRequestException {
        BufferedInputStream bufferedInputStream;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        }
        catch (IOException iOException) {
            throw new HttpRequestException(iOException);
        }
        return this.part(string, string2, string3, bufferedInputStream);
    }

    public HttpRequest part(String string, InputStream inputStream) throws HttpRequestException {
        return this.part(string, null, null, inputStream);
    }

    public HttpRequest part(String string, String string2, String string3, InputStream inputStream) throws HttpRequestException {
        try {
            this.startPart();
            this.writePartHeader(string, string2, string3);
            this.copy(inputStream, this.output);
        }
        catch (IOException iOException) {
            throw new HttpRequestException(iOException);
        }
        return this;
    }

    public HttpRequest partHeader(String string, String string2) throws HttpRequestException {
        return this.send(string).send(": ").send(string2).send(CRLF);
    }

    public HttpRequest send(File file) throws HttpRequestException {
        BufferedInputStream bufferedInputStream;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new HttpRequestException(fileNotFoundException);
        }
        return this.send(bufferedInputStream);
    }

    public HttpRequest send(byte[] byArray) throws HttpRequestException {
        return this.send(new ByteArrayInputStream(byArray));
    }

    public HttpRequest send(InputStream inputStream) throws HttpRequestException {
        try {
            this.openOutput();
            this.copy(inputStream, this.output);
        }
        catch (IOException iOException) {
            throw new HttpRequestException(iOException);
        }
        return this;
    }

    public HttpRequest send(final Reader reader) throws HttpRequestException {
        try {
            this.openOutput();
        }
        catch (IOException iOException) {
            throw new HttpRequestException(iOException);
        }
        final OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)this.output, this.output.a.charset());
        return (HttpRequest)new c<HttpRequest>((Flushable)outputStreamWriter){

            protected HttpRequest a() throws IOException {
                return HttpRequest.this.copy(reader, outputStreamWriter);
            }

            @Override
            protected /* synthetic */ Object b() throws HttpRequestException, IOException {
                return this.a();
            }
        }.call();
    }

    public HttpRequest send(CharSequence charSequence) throws HttpRequestException {
        try {
            this.openOutput();
            this.output.a(charSequence.toString());
        }
        catch (IOException iOException) {
            throw new HttpRequestException(iOException);
        }
        return this;
    }

    public OutputStreamWriter writer() throws HttpRequestException {
        try {
            this.openOutput();
            return new OutputStreamWriter((OutputStream)this.output, this.output.a.charset());
        }
        catch (IOException iOException) {
            throw new HttpRequestException(iOException);
        }
    }

    public HttpRequest form(Map<?, ?> map) throws HttpRequestException {
        return this.form(map, CHARSET_UTF8);
    }

    public HttpRequest form(Map.Entry<?, ?> entry) throws HttpRequestException {
        return this.form(entry, CHARSET_UTF8);
    }

    public HttpRequest form(Map.Entry<?, ?> entry, String string) throws HttpRequestException {
        return this.form(entry.getKey(), entry.getValue(), string);
    }

    public HttpRequest form(Object object, Object object2) throws HttpRequestException {
        return this.form(object, object2, CHARSET_UTF8);
    }

    public HttpRequest form(Object object, Object object2, String string) throws HttpRequestException {
        boolean bl;
        boolean bl2 = bl = !this.form;
        if (bl) {
            this.contentType(CONTENT_TYPE_FORM, string);
            this.form = true;
        }
        string = HttpRequest.getValidCharset(string);
        try {
            this.openOutput();
            if (!bl) {
                this.output.write(38);
            }
            this.output.a(URLEncoder.encode(object.toString(), string));
            this.output.write(61);
            if (object2 != null) {
                this.output.a(URLEncoder.encode(object2.toString(), string));
            }
        }
        catch (IOException iOException) {
            throw new HttpRequestException(iOException);
        }
        return this;
    }

    public HttpRequest form(Map<?, ?> map, String string) throws HttpRequestException {
        if (!map.isEmpty()) {
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                this.form(entry, string);
            }
        }
        return this;
    }

    public HttpRequest trustAllHosts() {
        HttpURLConnection httpURLConnection = this.getConnection();
        if (httpURLConnection instanceof HttpsURLConnection) {
            ((HttpsURLConnection)httpURLConnection).setHostnameVerifier(HttpRequest.getTrustedVerifier());
        }
        return this;
    }

    public HttpRequest trustHosts() {
        HttpURLConnection httpURLConnection = this.getConnection();
        if (httpURLConnection instanceof HttpsURLConnection) {
            ((HttpsURLConnection)httpURLConnection).setHostnameVerifier(HttpRequest.getTrustedVerifier((HttpsURLConnection)httpURLConnection));
        }
        return this;
    }

    public URL url() {
        return this.getConnection().getURL();
    }

    public String method() {
        return this.getConnection().getRequestMethod();
    }

    public HttpRequest useProxy(String string, int n2) {
        if (this.connection != null) {
            throw new IllegalStateException("The connection has already been created. This method must be called before reading or writing to the request.");
        }
        this.httpProxyHost = string;
        this.httpProxyPort = n2;
        return this;
    }

    public HttpRequest followRedirects(boolean bl) {
        this.getConnection();
        HttpURLConnection.setFollowRedirects(bl);
        return this;
    }

    static {
        readTimeOut = 60000;
        connectTimeout = 60000;
        CONNECTION_FACTORY = ConnectionFactory.DEFAULT;
    }

    public static class e
    extends BufferedOutputStream {
        private final CharsetEncoder a;

        public e(OutputStream outputStream, String string, int n2) {
            super(outputStream, n2);
            this.a = Charset.forName(HttpRequest.getValidCharset(string)).newEncoder();
        }

        public e a(String string) throws IOException {
            ByteBuffer byteBuffer = this.a.encode(CharBuffer.wrap(string));
            super.write(byteBuffer.array(), 0, byteBuffer.limit());
            return this;
        }
    }

    protected static abstract class c<V>
    extends d<V> {
        private final Flushable a;

        protected c(Flushable flushable) {
            this.a = flushable;
        }

        @Override
        protected void c() throws IOException {
            this.a.flush();
        }
    }

    protected static abstract class b<V>
    extends d<V> {
        private final Closeable a;
        private final boolean b;

        protected b(Closeable closeable, boolean bl) {
            this.a = closeable;
            this.b = bl;
        }

        @Override
        protected void c() throws IOException {
            if (this.a instanceof Flushable) {
                ((Flushable)((Object)this.a)).flush();
            }
            if (this.b) {
                try {
                    this.a.close();
                }
                catch (IOException iOException) {}
            } else {
                this.a.close();
            }
        }
    }

    protected static abstract class d<V>
    implements Callable<V> {
        protected d() {
        }

        protected abstract V b() throws HttpRequestException, IOException;

        protected abstract void c() throws IOException;

        @Override
        public V call() throws HttpRequestException {
            boolean bl = false;
            try {
                V v = this.b();
                return v;
            }
            catch (HttpRequestException httpRequestException) {
                bl = true;
                throw httpRequestException;
            }
            catch (IOException iOException) {
                bl = true;
                throw new HttpRequestException(iOException);
            }
            finally {
                block10: {
                    try {
                        this.c();
                    }
                    catch (IOException iOException) {
                        if (bl) break block10;
                        throw new HttpRequestException(iOException);
                    }
                }
            }
        }
    }

    public static class HttpRequestException
    extends RuntimeException {
        private static final long serialVersionUID = -1170466989781746231L;

        protected HttpRequestException(IOException iOException) {
            super(iOException);
        }

        public IOException a() {
            return (IOException)super.getCause();
        }

        @Override
        public /* synthetic */ Throwable getCause() {
            return this.a();
        }
    }

    public static class a {
        private static final byte a = 61;
        private static final String b = "US-ASCII";
        private static final byte[] c = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};

        private a() {
        }

        private static byte[] a(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
            byte[] byArray3 = c;
            int n5 = (n3 > 0 ? byArray[n2] << 24 >>> 8 : 0) | (n3 > 1 ? byArray[n2 + 1] << 24 >>> 16 : 0) | (n3 > 2 ? byArray[n2 + 2] << 24 >>> 24 : 0);
            switch (n3) {
                case 3: {
                    byArray2[n4] = byArray3[n5 >>> 18];
                    byArray2[n4 + 1] = byArray3[n5 >>> 12 & 0x3F];
                    byArray2[n4 + 2] = byArray3[n5 >>> 6 & 0x3F];
                    byArray2[n4 + 3] = byArray3[n5 & 0x3F];
                    return byArray2;
                }
                case 2: {
                    byArray2[n4] = byArray3[n5 >>> 18];
                    byArray2[n4 + 1] = byArray3[n5 >>> 12 & 0x3F];
                    byArray2[n4 + 2] = byArray3[n5 >>> 6 & 0x3F];
                    byArray2[n4 + 3] = 61;
                    return byArray2;
                }
                case 1: {
                    byArray2[n4] = byArray3[n5 >>> 18];
                    byArray2[n4 + 1] = byArray3[n5 >>> 12 & 0x3F];
                    byArray2[n4 + 2] = 61;
                    byArray2[n4 + 3] = 61;
                    return byArray2;
                }
            }
            return byArray2;
        }

        public static String a(String string) {
            byte[] byArray;
            try {
                byArray = string.getBytes(b);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray = string.getBytes();
            }
            return com.umeng.message.util.HttpRequest$a.a(byArray);
        }

        public static String a(byte[] byArray) {
            return com.umeng.message.util.HttpRequest$a.a(byArray, 0, byArray.length);
        }

        public static String a(byte[] byArray, int n2, int n3) {
            byte[] byArray2 = com.umeng.message.util.HttpRequest$a.b(byArray, n2, n3);
            try {
                return new String(byArray2, b);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new String(byArray2);
            }
        }

        public static byte[] b(byte[] byArray, int n2, int n3) {
            if (byArray == null) {
                throw new NullPointerException("Cannot serialize a null array.");
            }
            if (n2 < 0) {
                throw new IllegalArgumentException("Cannot have negative offset: " + n2);
            }
            if (n3 < 0) {
                throw new IllegalArgumentException("Cannot have length offset: " + n3);
            }
            if (n2 + n3 > byArray.length) {
                throw new IllegalArgumentException(String.format("Cannot have offset of %d and length of %d with array of length %d", n2, n3, byArray.length));
            }
            int n4 = n3 / 3 * 4 + (n3 % 3 > 0 ? 4 : 0);
            byte[] byArray2 = new byte[n4];
            int n5 = 0;
            int n6 = 0;
            int n7 = n3 - 2;
            while (n5 < n7) {
                com.umeng.message.util.HttpRequest$a.a(byArray, n5 + n2, 3, byArray2, n6);
                n5 += 3;
                n6 += 4;
            }
            if (n5 < n3) {
                com.umeng.message.util.HttpRequest$a.a(byArray, n5 + n2, n3 - n5, byArray2, n6);
                n6 += 4;
            }
            if (n6 <= byArray2.length - 1) {
                byte[] byArray3 = new byte[n6];
                System.arraycopy(byArray2, 0, byArray3, 0, n6);
                return byArray3;
            }
            return byArray2;
        }
    }

    public static interface ConnectionFactory {
        public static final ConnectionFactory DEFAULT = new ConnectionFactory(){

            @Override
            public HttpURLConnection create(URL uRL) throws IOException {
                return (HttpURLConnection)uRL.openConnection();
            }

            @Override
            public HttpURLConnection create(URL uRL, Proxy proxy) throws IOException {
                return (HttpURLConnection)uRL.openConnection(proxy);
            }
        };

        public HttpURLConnection create(URL var1) throws IOException;

        public HttpURLConnection create(URL var1, Proxy var2) throws IOException;
    }
}

