/*
 * Decompiled with CFR 0.152.
 */
package anetwork.channel.cookie;

import android.content.Context;
import android.os.Build;
import android.webkit.CookieSyncManager;
import anet.channel.util.ALog;
import anetwork.channel.http.NetworkSdkSetting;
import java.util.List;
import java.util.Map;

public class CookieManager {
    public static final String TAG = "ANet.CookieManager";
    private static volatile boolean isSetup = false;
    private static android.webkit.CookieManager webkitCookMgr;
    private static boolean isCookieValid;

    public static synchronized void setup(Context context) {
        if (isSetup) {
            return;
        }
        try {
            if (Build.VERSION.SDK_INT < 21) {
                CookieSyncManager.createInstance((Context)context);
            }
            webkitCookMgr = android.webkit.CookieManager.getInstance();
            webkitCookMgr.setAcceptCookie(true);
            if (Build.VERSION.SDK_INT < 21) {
                webkitCookMgr.removeExpiredCookie();
            }
        }
        catch (Throwable throwable) {
            isCookieValid = false;
            ALog.e(TAG, "Cookie Manager setup failed!!!", null, throwable, new Object[0]);
        }
        isSetup = true;
    }

    private static boolean checkSetup() {
        if (!isSetup && NetworkSdkSetting.getContext() != null) {
            CookieManager.setup(NetworkSdkSetting.getContext());
        }
        return isSetup;
    }

    public static synchronized void setCookie(String string, String string2) {
        if (!CookieManager.checkSetup() || !isCookieValid) {
            return;
        }
        try {
            webkitCookMgr.setCookie(string, string2);
            if (Build.VERSION.SDK_INT < 21) {
                CookieSyncManager.getInstance().sync();
            } else {
                webkitCookMgr.flush();
            }
        }
        catch (Throwable throwable) {
            ALog.e(TAG, "set cookie failed. url=" + string + " cookies=" + string2, null, throwable, new Object[0]);
        }
    }

    public static void setCookie(String string, Map<String, List<String>> map) {
        if (string == null || map == null) {
            return;
        }
        try {
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                String string2 = entry.getKey();
                if (string2 == null || !string2.equalsIgnoreCase("Set-Cookie") && !string2.equalsIgnoreCase("Set-cookie2")) continue;
                for (String string3 : entry.getValue()) {
                    CookieManager.setCookie(string, string3);
                }
            }
        }
        catch (Exception exception) {
            ALog.e(TAG, "set cookie failed", null, exception, "url", string, "\nheaders", map);
        }
    }

    public static synchronized String getCookie(String string) {
        if (!CookieManager.checkSetup() || !isCookieValid) {
            return null;
        }
        String string2 = null;
        try {
            string2 = webkitCookMgr.getCookie(string);
        }
        catch (Throwable throwable) {
            ALog.e(TAG, "get cookie failed. url=" + string, null, throwable, new Object[0]);
        }
        return string2;
    }

    static {
        isCookieValid = true;
    }
}

