/*
 * Decompiled with CFR 0.152.
 */
package anet.channel.util;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import anet.channel.GlobalAppRuntimeInfo;
import anet.channel.appmonitor.AppMonitor;
import anet.channel.entity.ConnType;
import anet.channel.entity.ENV;
import anet.channel.statist.ExceptionStatistic;
import anet.channel.util.ALog;
import anet.channel.util.ErrorConstant;
import com.ta.utdid2.device.UTDevice;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;

public class Utils {
    private static final String TAG = "awcn.Utils";
    public static int accsVersion = 0;
    public static Context context = null;

    public static String getDeviceId(Context context) {
        return UTDevice.getUtdid((Context)context);
    }

    public static boolean isDebugMode(Context context) {
        return false;
    }

    public static String getImsi(Context context) {
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            return telephonyManager.getSubscriberId();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static String getOperator(Context context) {
        String string = Utils.getImsi(context);
        String string2 = "null";
        if (string != null && string.length() > 5) {
            string2 = string.substring(0, 5);
        }
        return string2;
    }

    public static String getMainProcessName(Context context) {
        String string = "";
        if (context == null) {
            return string;
        }
        try {
            string = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).applicationInfo.processName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return string;
    }

    public static String getProcessName(Context context, int n2) {
        String string;
        block5: {
            string = "";
            try {
                ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
                List list = activityManager.getRunningAppProcesses();
                if (list != null && list.size() > 0) {
                    for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                        if (runningAppProcessInfo.pid != n2) continue;
                        string = runningAppProcessInfo.processName;
                        break block5;
                    }
                    break block5;
                }
                String string2 = ErrorConstant.formatMsg(-108, "BuildVersion=" + String.valueOf(Build.VERSION.SDK_INT));
                AppMonitor.getInstance().commitStat(new ExceptionStatistic(-108, string2, "rt"));
            }
            catch (Exception exception) {
                AppMonitor.getInstance().commitStat(new ExceptionStatistic(-108, exception.toString(), "rt"));
            }
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = Utils.getProcessNameNew(n2);
        }
        return string;
    }

    private static String getProcessNameNew(int n2) {
        String string = "ps  |  grep  " + n2;
        BufferedReader bufferedReader = null;
        FilterOutputStream filterOutputStream = null;
        try {
            String string2;
            Process process = Runtime.getRuntime().exec("sh");
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            filterOutputStream = new DataOutputStream(process.getOutputStream());
            ((DataOutputStream)filterOutputStream).writeBytes(string + "  &\n");
            ((DataOutputStream)filterOutputStream).flush();
            ((DataOutputStream)filterOutputStream).writeBytes("exit\n");
            process.waitFor();
            while ((string2 = bufferedReader.readLine()) != null) {
                String[] stringArray = (string2 = string2.replaceAll("\\s+", "  ")).split("  ");
                if (stringArray.length < 9 || TextUtils.isEmpty((CharSequence)stringArray[1]) || !stringArray[1].trim().equals(String.valueOf(n2))) continue;
                String string3 = stringArray[8];
                return string3;
            }
        }
        catch (Exception exception) {
            ALog.e(TAG, "getProcessNameNew ", null, exception, new Object[0]);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
            }
            catch (IOException iOException) {
                ALog.e(TAG, "getProcessNameNew ", null, iOException, new Object[0]);
            }
        }
        return "";
    }

    public static String getAppVersion(Context context) {
        String string = "";
        try {
            string = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (Exception exception) {
            ALog.w(TAG, "getAppVersion", null, exception, new Object[0]);
        }
        return string;
    }

    public static Context getAppContext() {
        if (context != null) {
            return context;
        }
        Class<Utils> clazz = Utils.class;
        synchronized (Utils.class) {
            if (context != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return context;
            }
            try {
                Class<?> clazz2 = Class.forName("android.app.ActivityThread");
                Object object = clazz2.getMethod("currentActivityThread", new Class[0]).invoke(clazz2, new Object[0]);
                context = (Context)object.getClass().getMethod("getApplication", new Class[0]).invoke(object, new Object[0]);
            }
            catch (Exception exception) {
                ALog.w(TAG, "getAppContext", null, exception, new Object[0]);
            }
            return context;
        }
    }

    public static int getAccsVersion() {
        if (accsVersion != 0) {
            return accsVersion;
        }
        try {
            String string = "com.taobao.accs.ChannelService";
            ClassLoader classLoader = Utils.class.getClassLoader();
            Class<?> clazz = classLoader.loadClass(string);
            Field field = clazz.getDeclaredField("SDK_VERSION_CODE");
            accsVersion = (Integer)field.get(null);
        }
        catch (Exception exception) {
            ALog.w(TAG, "getAccsVersion", null, exception, new Object[0]);
        }
        return accsVersion;
    }

    public static String getStackMsg(Throwable throwable) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            if (stackTraceElementArray != null && stackTraceElementArray.length > 0) {
                for (int i2 = 0; i2 < stackTraceElementArray.length; ++i2) {
                    StackTraceElement stackTraceElement = stackTraceElementArray[i2];
                    stringBuffer.append(stackTraceElement.toString() + "\n");
                }
            }
        }
        catch (Exception exception) {
            ALog.e(TAG, "getStackMsg", null, exception, new Object[0]);
        }
        return stringBuffer.toString();
    }

    public static Object invokeStaticMethodThrowException(String string, String string2, Class<?>[] classArray, Object ... objectArray) throws Exception {
        if (string == null || string2 == null) {
            return null;
        }
        Object object = null;
        Class<?> clazz = Class.forName(string);
        Method method = classArray != null ? clazz.getDeclaredMethod(string2, classArray) : clazz.getDeclaredMethod(string2, new Class[0]);
        if (method != null) {
            method.setAccessible(true);
            object = objectArray != null ? method.invoke(clazz, objectArray) : method.invoke(clazz, new Object[0]);
        }
        return object;
    }

    public static int getPublicKey(ConnType connType, boolean bl, int n2) {
        if ("cdn".equals(connType.getPublicKey())) {
            n2 = bl ? 1 : 1;
        } else if ("open".equals(connType.getPublicKey())) {
            n2 = bl ? 11 : 10;
        } else if (GlobalAppRuntimeInfo.getEnv() == ENV.TEST) {
            n2 = 0;
        } else if (n2 < 0) {
            n2 = bl ? 4 : 3;
        }
        return n2;
    }
}

