/*
 * Decompiled with CFR 0.152.
 */
package anet.channel.util;

import android.text.TextUtils;
import anet.channel.util.ALog;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.Map;

public class StringUtils {
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String[] parseURL(String string) {
        int n2;
        int n3;
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        if (string.startsWith("//")) {
            string = "http:" + string;
        }
        if ((n3 = string.indexOf("://")) == -1) {
            return null;
        }
        String[] stringArray = new String[2];
        String string2 = string.substring(0, n3);
        if (!"http".equalsIgnoreCase(string2) && !"https".equalsIgnoreCase(string2)) {
            return null;
        }
        stringArray[0] = string2;
        int n4 = string.length();
        for (n2 = n3 + 3; n2 < n4; ++n2) {
            char c2 = string.charAt(n2);
            if (c2 != '/' && c2 != ':' && c2 != '?' && c2 != '#') continue;
            stringArray[1] = string.substring(n3 + 3, n2);
            return stringArray;
        }
        if (n2 == n4) {
            stringArray[1] = string.substring(n3 + 3);
            return stringArray;
        }
        return null;
    }

    public static String encodeQueryParams(Map<String, String> map, String string) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(64);
        try {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (entry.getKey() == null) continue;
                stringBuilder.append(URLEncoder.encode(entry.getKey(), string)).append("=").append(URLEncoder.encode(StringUtils.stringNull2Empty(entry.getValue()), string).replace("+", "%20")).append("&");
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ALog.e("Request", "format params failed", null, unsupportedEncodingException, new Object[0]);
        }
        return stringBuilder.toString();
    }

    public static String concatString(String string, String string2) {
        return new StringBuilder(string.length() + string2.length()).append(string).append(string2).toString();
    }

    public static String concatString(String string, String string2, String string3) {
        return new StringBuilder(string.length() + string2.length() + string3.length()).append(string).append(string2).append(string3).toString();
    }

    public static String buildKey(String string, String string2) {
        return StringUtils.concatString(string, "://", string2);
    }

    public static String simplifyString(String string, int n2) {
        if (string.length() <= n2) {
            return string;
        }
        return StringUtils.concatString(string.substring(0, n2), "......");
    }

    public static String stringNull2Empty(String string) {
        return string == null ? "" : string;
    }

    public static String md5ToHex(String string) {
        if (string == null) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            return StringUtils.bytesToHexString(messageDigest.digest(string.getBytes("utf-8")));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String bytesToHexString(byte[] byArray, char[] cArray) {
        int n2 = byArray.length;
        char[] cArray2 = new char[n2 << 1];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray2[n3++] = cArray[(0xF0 & byArray[i2]) >>> 4];
            cArray2[n3++] = cArray[0xF & byArray[i2]];
        }
        return new String(cArray2);
    }

    public static String bytesToHexString(byte[] byArray) {
        if (byArray == null) {
            return "";
        }
        return StringUtils.bytesToHexString(byArray, DIGITS_LOWER);
    }

    public static String longToIP(long l2) {
        StringBuilder stringBuilder = new StringBuilder(16);
        long l3 = 1000000000L;
        do {
            stringBuilder.append(l2 / l3);
            stringBuilder.append('.');
            l2 %= l3;
        } while ((l3 /= 1000L) > 0L);
        stringBuilder.setLength(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    public static boolean isNotBlank(String string) {
        return !StringUtils.isBlank(string);
    }

    public static boolean isBlank(String string) {
        int n2;
        if (string == null || (n2 = string.length()) == 0) {
            return true;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isWhitespace(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }
}

