/*
 * Decompiled with CFR 0.152.
 */
package anet.channel.strategy;

import anet.channel.strategy.IConnStrategy;
import anet.channel.strategy.StrategyCenter;
import anet.channel.strategy.dispatch.HttpDispatcher;
import java.util.ArrayList;
import java.util.List;

public class HttpDnsAdapter {
    public static void setHosts(ArrayList<String> arrayList) {
        HttpDispatcher.getInstance().addHosts(arrayList);
    }

    public static HttpDnsOrigin getOriginByHttpDns(String string) {
        List<IConnStrategy> list = StrategyCenter.getInstance().getConnStrategyListByHost(string);
        if (list.isEmpty()) {
            return null;
        }
        IConnStrategy iConnStrategy = list.get(0);
        return new HttpDnsOrigin(iConnStrategy);
    }

    public static ArrayList<HttpDnsOrigin> getOriginsByHttpDns(String string) {
        List<IConnStrategy> list = StrategyCenter.getInstance().getConnStrategyListByHost(string);
        if (list.isEmpty()) {
            return null;
        }
        ArrayList<HttpDnsOrigin> arrayList = new ArrayList<HttpDnsOrigin>(list.size());
        for (IConnStrategy iConnStrategy : list) {
            arrayList.add(new HttpDnsOrigin(iConnStrategy));
        }
        return arrayList;
    }

    public static String getIpByHttpDns(String string) {
        List<IConnStrategy> list = StrategyCenter.getInstance().getConnStrategyListByHost(string);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0).getIp();
    }

    public static final class HttpDnsOrigin {
        private final IConnStrategy connStrategy;

        HttpDnsOrigin(IConnStrategy iConnStrategy) {
            this.connStrategy = iConnStrategy;
        }

        public String getOriginIP() {
            return this.connStrategy.getIp();
        }

        public int getOriginPort() {
            return this.connStrategy.getPort();
        }

        public boolean canWithSPDY() {
            return !this.connStrategy.getConnType().isHttpType();
        }

        public String toString() {
            return this.connStrategy.toString();
        }
    }
}

