/*
 * Decompiled with CFR 0.152.
 */
package anet.channel.session;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import anet.channel.AccsFrameCb;
import anet.channel.Config;
import anet.channel.GlobalAppRuntimeInfo;
import anet.channel.RequestCb;
import anet.channel.Session;
import anet.channel.appmonitor.AppMonitor;
import anet.channel.entity.ENV;
import anet.channel.entity.EventType;
import anet.channel.entity.d;
import anet.channel.heartbeat.IHeartbeat;
import anet.channel.heartbeat.IHeartbeatFactory;
import anet.channel.request.Cancelable;
import anet.channel.request.Request;
import anet.channel.session.b;
import anet.channel.session.k;
import anet.channel.statist.ExceptionStatistic;
import anet.channel.statist.StatObject;
import anet.channel.status.NetworkStatusHelper;
import anet.channel.util.ALog;
import anet.channel.util.ErrorConstant;
import anet.channel.util.Utils;
import anet.channel.util.c;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import org.android.spdy.RequestPriority;
import org.android.spdy.SpdyDataProvider;
import org.android.spdy.SpdyErrorException;
import org.android.spdy.SpdyRequest;
import org.android.spdy.SpdySession;
import org.android.spdy.SuperviseConnectInfo;
import org.android.spdy.SuperviseData;

public class AccsSession
extends k {
    private static final String TAG = "awcn.AccsSession";
    public static final int CONN_TYPE_INAPP = 1;
    private AccsFrameCb mFrameCb;
    private IHeartbeat heartbeat = null;

    public AccsSession(Context context, anet.channel.entity.a a2) {
        super(context, a2, a2.c());
        this.mSessionStat.isKL = 1L;
    }

    public void setFrameCb(AccsFrameCb accsFrameCb) {
        ALog.e(TAG, "setFrameCb", this.mSeq, "AccsFrameCb", accsFrameCb);
        this.mFrameCb = accsFrameCb;
    }

    @Override
    public void setConfig(Config config) {
        super.setConfig(config);
        this.autoReCreate = config.isAccsSessionAutoCreate();
        IHeartbeatFactory iHeartbeatFactory = config.getHeartbeatFactory();
        if (iHeartbeatFactory != null) {
            this.heartbeat = iHeartbeatFactory.createHeartbeat(this);
        }
    }

    @Override
    public void close() {
        if (this.heartbeat != null) {
            this.heartbeat.stop();
            this.heartbeat = null;
        }
        super.close();
    }

    @Override
    public Cancelable request(Request request, RequestCb requestCb) {
        if (this.heartbeat != null) {
            this.mLastPingTime = System.currentTimeMillis();
            this.heartbeat.delay();
        }
        return super.request(request, requestCb);
    }

    private String buildAuthUrl() {
        String string;
        String string2 = string = Utils.getDeviceId(this.mContext);
        try {
            string2 = URLEncoder.encode(string);
        }
        catch (Throwable throwable) {}
        String string3 = null;
        try {
            string3 = this.iSecurity.sign(this.mContext, "HMAC_SHA1", this.mAppkey, !this.iSecurity.isSecOff() ? string + this.mAppkey : this.mAppkey + string);
        }
        catch (Throwable throwable) {
            ALog.e(TAG, "getAppSign", null, throwable, new Object[0]);
        }
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("https://").append(this.mIp).append(":").append(this.mPort).append("/accs/");
        stringBuilder.append("auth?1=").append(string2).append("&2=").append(string3).append("&3=").append(this.mAppkey);
        if (GlobalAppRuntimeInfo.mConnToken != null) {
            stringBuilder.append("&4=").append(GlobalAppRuntimeInfo.mConnToken);
        }
        stringBuilder.append("&5=").append(1).append("&6=").append(NetworkStatusHelper.b()).append("&7=").append(Utils.getOperator(this.mContext)).append("&8=").append("1.1.2").append("&9=").append(System.currentTimeMillis()).append("&10=").append(1).append("&11=").append(Build.VERSION.SDK_INT).append("&12=").append(this.mContext.getPackageName()).append("&13=").append(Utils.getAppVersion(this.mContext)).append("&14=").append(GlobalAppRuntimeInfo.getTtid()).append("&15=").append(Build.MODEL).append("&16=").append(Build.BRAND).append("&17=").append(Utils.getAccsVersion());
        if (this.isHorseRide) {
            stringBuilder.append("&18=").append("ign-loc");
        }
        stringBuilder.append("&19=").append(this.iSecurity.isSecOff() ? 0 : 1);
        String string4 = stringBuilder.toString();
        ALog.e(TAG, "auth", this.mSeq, "auth url", string4);
        if (!this.checkParam(string, this.mAppkey, string3)) {
            ALog.e(TAG, "connect param error!", this.mSeq, new Object[0]);
            this.onAuthFail(-104);
            return null;
        }
        return string4;
    }

    @Override
    protected void auth() {
        if (this.mSession == null) {
            this.notifyStatus(Session.Status.CONNETFAIL, null);
            return;
        }
        String string = this.buildAuthUrl();
        if (string == null) {
            return;
        }
        SpdyRequest spdyRequest = null;
        try {
            URL uRL = new URL(string);
            spdyRequest = TextUtils.isEmpty((CharSequence)this.mProxyIp) || this.mProxyPort <= 0 ? new SpdyRequest(uRL, "GET", RequestPriority.DEFAULT_PRIORITY, this.mReqTimeout, this.mConnTimeout) : new SpdyRequest(uRL, uRL.getHost(), uRL.getPort(), this.mProxyIp, this.mProxyPort, "GET", RequestPriority.DEFAULT_PRIORITY, this.mReqTimeout, this.mConnTimeout, 0);
            spdyRequest.setDomain(this.mHost);
            SpdyDataProvider spdyDataProvider = new SpdyDataProvider((byte[])null);
            this.mSession.submitRequest(spdyRequest, spdyDataProvider, this.mHost, new a());
        }
        catch (Throwable throwable) {
            ALog.e(TAG, "auth exception ", this.mSeq, throwable, new Object[0]);
            this.onAuthFail(-302);
        }
    }

    private void onAuthFail(int n2) {
        this.notifyStatus(Session.Status.AUTH_FAIL, null);
        if (this.mSessionStat != null) {
            this.mSessionStat.closeReason = "Accs_Auth_Fail";
            this.mSessionStat.errorCode = n2;
        }
        this.close();
    }

    private boolean checkParam(String string, String string2, String string3) {
        boolean bl = true;
        if (GlobalAppRuntimeInfo.getEnv() == ENV.TEST) {
            return bl;
        }
        if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2) || TextUtils.isEmpty((CharSequence)string3)) {
            bl = false;
            int n2 = 1;
            if (TextUtils.isEmpty((CharSequence)string)) {
                n2 = 1;
            } else if (TextUtils.isEmpty((CharSequence)string2)) {
                n2 = 2;
            } else if (TextUtils.isEmpty((CharSequence)string3)) {
                n2 = 3;
            }
            ExceptionStatistic exceptionStatistic = new ExceptionStatistic(-104, ErrorConstant.formatMsg(-104, "1.1.2 errorCode=" + n2), "rt");
            AppMonitor.getInstance().commitStat(exceptionStatistic);
        }
        return bl;
    }

    @Override
    public void sendCustomFrame(int n2, byte[] byArray, int n3) {
        try {
            ALog.e(TAG, "sendCustomFrame", this.mSeq, "dataId", n2, "type", n3);
            if (this.mStatus == Session.Status.AUTH_SUCC && this.mSession != null) {
                if (byArray != null && byArray.length > 16384) {
                    this.onException(n2, -303, false, null);
                } else {
                    this.mSession.sendCustomControlFrame(n2, n3, 0, byArray == null ? 0 : byArray.length, byArray);
                    ++this.mSessionStat.requestCount;
                    ++this.mSessionStat.cfRCount;
                    this.mLastPingTime = System.currentTimeMillis();
                    if (this.heartbeat != null) {
                        this.heartbeat.delay();
                    }
                }
            } else {
                ALog.e(TAG, "sendCustomFrame", this.mSeq, "sendCustomFrame con invalid mStatus:" + (Object)((Object)this.mStatus));
                this.onException(n2, -301, true, "session invalid");
            }
        }
        catch (SpdyErrorException spdyErrorException) {
            ALog.e(TAG, "sendCustomFrame error", this.mSeq, spdyErrorException, new Object[0]);
            this.onException(n2, -300, true, "SpdyErrorException: " + spdyErrorException.toString());
        }
        catch (Exception exception) {
            ALog.e(TAG, "sendCustomFrame error", this.mSeq, exception, new Object[0]);
            this.onException(n2, -101, true, exception.toString());
        }
    }

    private void onException(int n2, int n3, boolean bl, String string) {
        if (this.mFrameCb != null) {
            this.mFrameCb.onException(n2, n3, bl, string);
        }
    }

    @Override
    protected Runnable getRecvTimeOutRunnable() {
        return new anet.channel.session.a(this);
    }

    @Override
    public void spdySessionCloseCallback(SpdySession spdySession, Object object, SuperviseConnectInfo superviseConnectInfo, int n2) {
        if (this.heartbeat != null) {
            this.heartbeat.stop();
        }
        super.spdySessionCloseCallback(spdySession, object, superviseConnectInfo, n2);
    }

    @Override
    public void spdyCustomControlFrameRecvCallback(SpdySession spdySession, Object object, int n2, int n3, int n4, int n5, byte[] byArray) {
        Object object2;
        ALog.e(TAG, "[spdyCustomControlFrameRecvCallback]", this.mSeq, "len", n5, "frameCb", this.mFrameCb);
        if (ALog.isPrintLog(1)) {
            object2 = "";
            if (n5 < 512) {
                for (int i2 = 0; i2 < byArray.length; ++i2) {
                    object2 = (String)object2 + Integer.toHexString(0xFF & byArray[i2]) + " ";
                }
                ALog.e(TAG, null, this.mSeq, "str", object2);
            }
        }
        if (this.mFrameCb != null) {
            this.mFrameCb.onDataReceive(this, byArray, n2, n3);
        } else {
            ALog.e(TAG, "AccsFrameCb is null", this.mSeq, new Object[0]);
            object2 = new ExceptionStatistic(-105, null, "rt");
            AppMonitor.getInstance().commitStat((StatObject)object2);
        }
        ++this.mSessionStat.inceptCount;
    }

    @Override
    public void spdyCustomControlFrameFailCallback(SpdySession spdySession, Object object, int n2, int n3) {
        ALog.e(TAG, "spdyCustomControlFrameFailCallback", this.mSeq, "dataId", n2);
        this.onException(n2, n3, true, "tnet error");
    }

    static /* synthetic */ String access$000(AccsSession accsSession) {
        return accsSession.mSeq;
    }

    static /* synthetic */ void access$100(AccsSession accsSession, EventType eventType, d d2) {
        accsSession.handleCallbacks(eventType, d2);
    }

    class a
    extends b {
        a() {
        }

        @Override
        public void spdyOnStreamResponse(SpdySession spdySession, long l2, Map<String, List<String>> map, Object object) {
            try {
                String string;
                int n2 = 0;
                try {
                    n2 = Integer.parseInt(c.b(map, ":status"));
                }
                catch (NumberFormatException numberFormatException) {}
                ALog.e(AccsSession.TAG, "AUTH httpStatusCode: " + n2, AccsSession.this.mSeq, new Object[0]);
                if (n2 == 200) {
                    AccsSession.this.notifyStatus(Session.Status.AUTH_SUCC, null);
                    if (AccsSession.this.heartbeat != null) {
                        AccsSession.this.mLastPingTime = System.currentTimeMillis();
                        AccsSession.this.heartbeat.start();
                    }
                    AccsSession.this.mSessionStat.ret = 1;
                    ALog.d(AccsSession.TAG, "spdyOnStreamResponse", AccsSession.this.mSeq, "authTime", AccsSession.this.mSessionStat.authTime);
                } else {
                    AccsSession.this.onAuthFail(n2);
                }
                if (AccsSession.this.mConnectedTime > 0L) {
                    AccsSession.this.mSessionStat.authTime = System.currentTimeMillis() - AccsSession.this.mConnectedTime;
                }
                if (!TextUtils.isEmpty((CharSequence)(string = c.b(map, "x-at")))) {
                    GlobalAppRuntimeInfo.mConnToken = string;
                }
            }
            catch (Exception exception) {
                ALog.e(AccsSession.TAG, "spdyOnStreamResponse", AccsSession.this.mSeq, exception, new Object[0]);
                AccsSession.this.close();
            }
        }

        @Override
        public void spdyStreamCloseCallback(SpdySession spdySession, long l2, int n2, Object object, SuperviseData superviseData) {
            if (n2 != 0) {
                ALog.e(AccsSession.TAG, "AUTH spdyStreamCloseCallback: " + n2, AccsSession.this.mSeq, new Object[0]);
                AccsSession.this.onAuthFail(n2);
            }
        }
    }
}

