/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.message;

import android.annotation.SuppressLint;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Build;
import android.os.IBinder;
import android.text.TextUtils;
import com.umeng.message.MessageSharedPrefs;
import com.umeng.message.PushAgent;
import com.umeng.message.UHandler;
import com.umeng.message.UmengMessageHandler;
import com.umeng.message.common.UmLog;
import com.umeng.message.entity.UMessage;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Stack;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.json.JSONObject;

public class UmengDownloadResourceService
extends Service {
    public static final String TAG = UmengDownloadResourceService.class.getSimpleName();
    private static final String d = ".tmp";
    private static final String e = "RETRY_TIME";
    private static final String f = "OPERATIOIN";
    private static final int g = 1;
    private static final int h = 2;
    private static final long i = 0x100000L;
    private static final long j = 86400000L;
    private static final int k = 300000;
    private static final int l = 3;
    ScheduledThreadPoolExecutor a;
    Context b;
    private static Thread m;
    ArrayList<String> c;

    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onCreate() {
        this.a = new ScheduledThreadPoolExecutor(Runtime.getRuntime().availableProcessors() * 4);
        this.b = this;
        this.c = new ArrayList();
    }

    @SuppressLint(value={"NewApi"})
    public int onStartCommand(Intent intent, int n2, int n3) {
        if (intent == null) {
            return super.onStartCommand(intent, n2, n3);
        }
        int n4 = intent.getIntExtra(f, 2);
        int n5 = intent.getIntExtra(e, 3);
        String string = intent.getStringExtra("body");
        UMessage uMessage = null;
        try {
            uMessage = new UMessage(new JSONObject(string));
            uMessage.message_id = intent.getStringExtra("id");
            uMessage.task_id = intent.getStringExtra("task_id");
            if (this.c.contains(uMessage.msg_id)) {
                return super.onStartCommand(intent, n2, n3);
            }
            this.c.add(uMessage.msg_id);
            switch (n4) {
                case 2: {
                    UmLog.i(TAG, "Start Download Resource");
                    this.setAlarm(uMessage, --n5);
                    this.checkCache();
                    this.downloadResource(uMessage, n5);
                    break;
                }
                case 1: {
                    this.deleteAlarm(uMessage, n5);
                    UmLog.i(TAG, "Show Notification After Downloaded Resource");
                    this.notification(uMessage);
                    this.c.remove(uMessage.msg_id);
                    if (this.c.size() != 0) break;
                    this.stopSelf();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return super.onStartCommand(intent, n2, n3);
    }

    public void notification(UMessage uMessage) {
        UHandler uHandler = null;
        uHandler = "notificationpullapp".equals(uMessage.display_type) ? PushAgent.getInstance((Context)this).getAdHandler() : PushAgent.getInstance((Context)this).getMessageHandler();
        if (uHandler != null) {
            if (TextUtils.equals((CharSequence)"autoupdate", (CharSequence)uMessage.display_type)) {
                UmengMessageHandler umengMessageHandler = (UmengMessageHandler)PushAgent.getInstance(this.b).getMessageHandler();
                if (umengMessageHandler != null) {
                    umengMessageHandler.dealWithNotificationMessage(this.b, uMessage);
                }
            } else {
                uHandler.handleMessage((Context)this, uMessage);
            }
        }
    }

    @SuppressLint(value={"NewApi"})
    public void downloadResource(UMessage uMessage, int n2) {
        DownloadResourceTask downloadResourceTask = new DownloadResourceTask(uMessage, n2);
        if (Build.VERSION.SDK_INT >= 11) {
            downloadResourceTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        } else {
            downloadResourceTask.execute(new Void[0]);
        }
    }

    public void setAlarm(UMessage uMessage, int n2) {
        UmLog.i(TAG, "setAlarm");
        PendingIntent pendingIntent = this.a(uMessage, n2);
        AlarmManager alarmManager = (AlarmManager)this.getSystemService("alarm");
        alarmManager.set(1, System.currentTimeMillis() + 300000L, pendingIntent);
    }

    public void deleteAlarm(UMessage uMessage, int n2) {
        UmLog.i(TAG, "deleteAlarm");
        PendingIntent pendingIntent = this.a(uMessage, n2);
        AlarmManager alarmManager = (AlarmManager)this.getSystemService("alarm");
        alarmManager.cancel(pendingIntent);
    }

    private PendingIntent a(UMessage uMessage, int n2) {
        String string = uMessage.getRaw().toString();
        int n3 = uMessage.msg_id.hashCode();
        Intent intent = new Intent(this.b, UmengDownloadResourceService.class);
        intent.putExtra("body", string);
        intent.putExtra("id", uMessage.message_id);
        intent.putExtra("task_id", uMessage.task_id);
        intent.putExtra(f, 2);
        intent.putExtra(e, n2);
        PendingIntent pendingIntent = PendingIntent.getService((Context)this.b, (int)n3, (Intent)intent, (int)0x8000000);
        UmLog.i(TAG, "PendingIntent: msgId:" + uMessage.msg_id + ",requestCode:" + n3 + ",retryTime:" + n2);
        return pendingIntent;
    }

    public void close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void checkCache() {
        try {
            File file = new File(UmengDownloadResourceService.getMessageResourceFolder(this.b, null));
            UmengDownloadResourceService.checkDir(file, 0x100000L, 86400000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkDir(File file, long l2, final long l3) throws IOException {
        if (file.exists() && UmengDownloadResourceService.a(file.getCanonicalFile()) > l2) {
            final File file2 = file;
            if (m == null) {
                m = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        UmengDownloadResourceService.b(file2, l3);
                        m = null;
                    }
                });
            }
            Thread thread = m;
            synchronized (thread) {
                m.start();
            }
        }
    }

    private static long a(File file) {
        if (file == null || !file.exists() || !file.isDirectory()) {
            return 0L;
        }
        long l2 = 0L;
        Stack<File> stack = new Stack<File>();
        stack.clear();
        stack.push(file);
        while (!stack.isEmpty()) {
            File[] fileArray;
            File file2 = (File)stack.pop();
            for (File file3 : fileArray = file2.listFiles()) {
                if (file3.isDirectory()) continue;
                l2 += file3.length();
            }
        }
        return l2;
    }

    private static void b(File file, long l2) {
        File[] fileArray;
        if (!(file != null && file.exists() && file.canWrite() && file.isDirectory())) {
            return;
        }
        for (File file2 : fileArray = file.listFiles()) {
            if (file2.isDirectory() || System.currentTimeMillis() - file2.lastModified() <= l2) continue;
            file2.delete();
        }
    }

    public static String getMessageResourceFolder(Context context, UMessage uMessage) {
        String string = context.getCacheDir() + "/umeng_push/";
        if (uMessage != null && uMessage.msg_id != null) {
            string = string + uMessage.msg_id + "/";
        }
        return string;
    }

    public class DownloadResourceTask
    extends AsyncTask<Void, Void, Boolean> {
        UMessage a;
        ArrayList<String> b;
        int c;

        public DownloadResourceTask(UMessage uMessage, int n2) {
            this.a = uMessage;
            this.b = new ArrayList();
            if ("notificationpullapp".equals(uMessage.display_type)) {
                String string = uMessage.custom;
                JSONObject jSONObject = null;
                try {
                    jSONObject = new JSONObject(string);
                    String string2 = jSONObject.optString("img");
                    this.b.add(string2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (uMessage.isLargeIconFromInternet()) {
                this.b.add(uMessage.img);
            }
            if (uMessage.isSoundFromInternet()) {
                this.b.add(uMessage.sound);
            }
            this.c = n2;
        }

        protected Boolean a(Void ... voidArray) {
            boolean bl = true;
            for (String string : this.b) {
                bl &= this.download(string);
            }
            return bl;
        }

        protected void a(Boolean bl) {
            super.onPostExecute((Object)bl);
            UmengDownloadResourceService.this.c.remove(this.a.msg_id);
            if (bl.booleanValue() || this.c <= 0) {
                MessageSharedPrefs.getInstance(UmengDownloadResourceService.this.b).setMessageResourceDownloaded(this.a.msg_id);
                String string = this.a.getRaw().toString();
                Intent intent = new Intent(UmengDownloadResourceService.this.b, UmengDownloadResourceService.class);
                intent.putExtra("body", string);
                intent.putExtra("id", this.a.message_id);
                intent.putExtra("task_id", this.a.task_id);
                intent.putExtra(UmengDownloadResourceService.f, 1);
                intent.putExtra(UmengDownloadResourceService.e, this.c);
                UmengDownloadResourceService.this.startService(intent);
            } else if (UmengDownloadResourceService.this.c.size() == 0) {
                UmengDownloadResourceService.this.stopSelf();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean download(String string) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                return true;
            }
            InputStream inputStream = null;
            FileOutputStream fileOutputStream = null;
            try {
                String string2 = string.hashCode() + "";
                String string3 = UmengDownloadResourceService.getMessageResourceFolder(UmengDownloadResourceService.this.b, this.a);
                File file = new File(string3, string2 + UmengDownloadResourceService.d);
                File file2 = new File(string3, string2);
                if (file2.exists()) {
                    boolean bl = true;
                    return bl;
                }
                File file3 = new File(string3);
                if (!file3.exists()) {
                    file3.mkdirs();
                }
                if (file.exists()) {
                    file.delete();
                }
                string = new URI(string).toASCIIString();
                inputStream = new URL(string).openStream();
                fileOutputStream = new FileOutputStream(file);
                byte[] byArray = new byte[10240];
                int n2 = 0;
                while ((n2 = inputStream.read(byArray)) > 0) {
                    fileOutputStream.write(byArray, 0, n2);
                }
                file.renameTo(file2);
                boolean bl = true;
                UmengDownloadResourceService.this.close(inputStream);
                UmengDownloadResourceService.this.close(fileOutputStream);
                return bl;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                UmengDownloadResourceService.this.close(inputStream);
                UmengDownloadResourceService.this.close(fileOutputStream);
            }
            return false;
        }

        protected /* synthetic */ void onPostExecute(Object object) {
            this.a((Boolean)object);
        }

        protected /* synthetic */ Object doInBackground(Object[] objectArray) {
            return this.a((Void[])objectArray);
        }
    }
}

