/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.accs.utl;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Proxy;
import android.os.Build;
import android.os.Process;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import anet.channel.util.HMacUtil;
import com.alibaba.wireless.security.open.SecurityGuardManager;
import com.alibaba.wireless.security.open.SecurityGuardParamContext;
import com.alibaba.wireless.security.open.dynamicdatastore.IDynamicDataStoreComponent;
import com.alibaba.wireless.security.open.securesignature.ISecureSignatureComponent;
import com.alibaba.wireless.security.open.staticdataencrypt.IStaticDataEncryptComponent;
import com.taobao.accs.ACCSManager;
import com.taobao.accs.AccsClientConfig;
import com.taobao.accs.client.GlobalClientInfo;
import com.taobao.accs.utl.ALog;
import com.taobao.accs.utl.a;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class UtilityImpl {
    private static final String TAG = "UtilityImpl";
    public static final String NET_TYPE_UNKNOWN = "unknown";
    public static final String NET_TYPE_WIFI = "wifi";
    public static final String NET_TYPE_4G = "4g";
    public static final String NET_TYPE_3G = "3g";
    public static final String NET_TYPE_2G = "2g";
    private static final byte[] mLock = new byte[0];
    private static final String SSL_TIKET_KEY = "accs_ssl_ticket_key";
    private static final String SSL_TIKET_KEY2 = "accs_ssl_key2_";
    public static final int TNET_FILE_SIZE = 0x500000;
    public static final int TNET_FILE_NUM = 5;

    public static String getProxyHost(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("ACCS_SDK", 4);
        String string = sharedPreferences.getString("proxy_host", null);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        string = UtilityImpl.getProxyIp();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return string;
    }

    public static int getProxyPort(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("ACCS_SDK", 4);
        int n2 = sharedPreferences.getInt("proxy_port", -1);
        if (n2 > 0) {
            return n2;
        }
        if (UtilityImpl.getProxyHost(context) == null) {
            return -1;
        }
        try {
            return UtilityImpl.getProxyPort();
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public static boolean appVersionChanged(Context context) {
        byte[] byArray = mLock;
        synchronized (mLock) {
            int n2 = context.getSharedPreferences("ACCS_SDK", 0).getInt("appVersionCode", -1);
            int n3 = 0;
            PackageInfo packageInfo = GlobalClientInfo.getInstance(context).getPackageInfo();
            if (packageInfo != null) {
                n3 = packageInfo.versionCode;
            }
            if (n2 != n3) {
                UtilityImpl.saveAppVersionCode(context);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return true;
            }
            return false;
        }
    }

    private static void saveAppVersionCode(Context context) {
        try {
            SharedPreferences.Editor editor = context.getSharedPreferences("ACCS_SDK", 0).edit();
            editor.putInt("appVersionCode", GlobalClientInfo.getInstance((Context)context).getPackageInfo().versionCode);
            editor.apply();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void focusDisableService(Context context) {
        byte[] byArray = mLock;
        synchronized (mLock) {
            SharedPreferences.Editor editor = context.getSharedPreferences("ACCS_SDK", 0).edit();
            editor.putBoolean("fouce_disable", true);
            editor.commit();
            UtilityImpl.disableService(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void focusEnableService(Context context) {
        byte[] byArray = mLock;
        synchronized (mLock) {
            SharedPreferences.Editor editor = context.getSharedPreferences("ACCS_SDK", 0).edit();
            editor.putBoolean("fouce_disable", false);
            editor.commit();
            UtilityImpl.enableService(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static boolean getFocusDisableStatus(Context context) {
        boolean bl = false;
        if (context == null) {
            return bl;
        }
        try {
            byte[] byArray = mLock;
            synchronized (mLock) {
                bl = context.getSharedPreferences("ACCS_SDK", 0).getBoolean("fouce_disable", false);
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        {
            return bl;
        }
    }

    public static boolean getServiceEnabled(Context context) {
        ComponentName componentName = new ComponentName(context, "com.taobao.accs.ChannelService");
        PackageManager packageManager = context.getPackageManager();
        try {
            ServiceInfo serviceInfo = packageManager.getServiceInfo(componentName, 128);
            if (serviceInfo.enabled) {
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ALog.e(TAG, UtilityImpl.getStackMsg(exception), new Object[0]);
        }
        return false;
    }

    public static boolean getAgooServiceEnabled(Context context) {
        ComponentName componentName = new ComponentName(context, com.taobao.accs.client.a.a(context.getPackageName()));
        PackageManager packageManager = context.getPackageManager();
        try {
            if (componentName.getPackageName().equals("!")) {
                ALog.e(TAG, "getAgooServiceEnabled,exception,comptName.getPackageName()=" + componentName.getPackageName(), new Object[0]);
                return false;
            }
            ServiceInfo serviceInfo = packageManager.getServiceInfo(componentName, 128);
            if (serviceInfo.enabled) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static void enableService(Context context) {
        ComponentName componentName = new ComponentName(context, "com.taobao.accs.ChannelService");
        ALog.d(TAG, "enableService,comptName=" + componentName.toString(), new Object[0]);
        PackageManager packageManager = context.getPackageManager();
        try {
            packageManager.setComponentEnabledSetting(componentName, 1, 1);
        }
        catch (Exception exception) {}
    }

    public static void disableService(Context context) {
        ComponentName componentName = new ComponentName(context, "com.taobao.accs.ChannelService");
        PackageManager packageManager = context.getPackageManager();
        try {
            ALog.d(TAG, "disableService,comptName=" + componentName.toString(), new Object[0]);
            ServiceInfo serviceInfo = packageManager.getServiceInfo(componentName, 128);
            if (serviceInfo.enabled) {
                packageManager.setComponentEnabledSetting(componentName, 2, 1);
                UtilityImpl.killService(context);
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
    }

    public static void killService(Context context) {
        try {
            int n2 = Process.myUid();
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            if (activityManager == null) {
                return;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : activityManager.getRunningAppProcesses()) {
                if (runningAppProcessInfo.uid != n2) continue;
                if (!TextUtils.isEmpty((CharSequence)com.taobao.accs.client.a.e) && com.taobao.accs.client.a.e.equals(runningAppProcessInfo.processName)) {
                    ALog.e(TAG, "kill1 " + runningAppProcessInfo.processName, new Object[0]);
                    Process.killProcess((int)runningAppProcessInfo.pid);
                    return;
                }
                if (!runningAppProcessInfo.processName.endsWith(":channel")) continue;
                ALog.e(TAG, "kill " + runningAppProcessInfo.processName, new Object[0]);
                Process.killProcess((int)runningAppProcessInfo.pid);
                return;
            }
            ALog.e(TAG, "kill nothing", new Object[0]);
        }
        catch (Throwable throwable) {
            ALog.e(TAG, "killService", throwable, new Object[0]);
        }
    }

    public static String getNetworkType(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null) {
            return NET_TYPE_UNKNOWN;
        }
        if (networkInfo.getType() == 1) {
            return NET_TYPE_WIFI;
        }
        String string = networkInfo.getSubtypeName();
        String string2 = "";
        if (!TextUtils.isEmpty((CharSequence)string)) {
            string2 = string.replaceAll(" ", "");
        }
        return string2;
    }

    public static String getNetworkTypeExt(Context context) {
        NetworkInfo networkInfo;
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo == null) {
                return NET_TYPE_UNKNOWN;
            }
            if (networkInfo.getType() == 1) {
                return NET_TYPE_WIFI;
            }
            int n2 = networkInfo.getSubtype();
            switch (n2) {
                case 1: 
                case 2: 
                case 4: 
                case 7: 
                case 11: {
                    return NET_TYPE_2G;
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 14: 
                case 15: {
                    return NET_TYPE_3G;
                }
                case 13: {
                    return NET_TYPE_4G;
                }
            }
        }
        catch (Exception exception) {
            ALog.e(TAG, "getNetworkTypeExt", exception, new Object[0]);
            return null;
        }
        String string = networkInfo.getSubtypeName();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return NET_TYPE_UNKNOWN;
        }
        if (string.equalsIgnoreCase("td-scdma") || string.equalsIgnoreCase("td_scdma") || string.equalsIgnoreCase("tds_hsdpa")) {
            return NET_TYPE_3G;
        }
        return NET_TYPE_UNKNOWN;
    }

    public static String getImsi(Context context) {
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            return telephonyManager.getSubscriberId();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static long String2Time(String string) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS", Locale.US);
            return simpleDateFormat.parse(string).getTime();
        }
        catch (Throwable throwable) {
            return 0L;
        }
    }

    public static String formatTime(long l2) {
        String string = "";
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS", Locale.US);
            string = simpleDateFormat.format(new Date(l2));
        }
        catch (Throwable throwable) {
            ALog.e(TAG, "formatTime", throwable, new Object[0]);
        }
        return string;
    }

    public static String formatDay(long l2) {
        String string = "";
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
            string = simpleDateFormat.format(l2);
        }
        catch (Throwable throwable) {
            ALog.e(TAG, "formatDay", throwable, new Object[0]);
        }
        return string;
    }

    public static boolean isForeground(Context context) {
        try {
            long l2 = System.currentTimeMillis();
            ActivityManager activityManager = GlobalClientInfo.getInstance(context).getActivityManager();
            ComponentName componentName = ((ActivityManager.RunningTaskInfo)activityManager.getRunningTasks((int)1).get((int)0)).topActivity;
            String string = componentName.getPackageName();
            if (!TextUtils.isEmpty((CharSequence)string) && string.equals(context.getPackageName())) {
                return true;
            }
            if (ALog.isPrintLog(ALog.Level.D)) {
                ALog.d(TAG, "isForeground time " + (System.currentTimeMillis() - l2), new Object[0]);
            }
        }
        catch (Throwable throwable) {
            ALog.e(TAG, "isForeground error ", throwable, new Object[0]);
        }
        return false;
    }

    private static boolean isSecurityOff(String string) {
        AccsClientConfig accsClientConfig = AccsClientConfig.getConfig(string);
        int n2 = accsClientConfig == null ? 0 : accsClientConfig.getSecurity();
        return n2 == 2;
    }

    public static String getAppsign(Context context, String string, String string2, String string3, String string4, String string5) {
        String string6 = null;
        if (TextUtils.isEmpty((CharSequence)string)) {
            ALog.e(TAG, "getAppsign appkey null", new Object[0]);
            return string6;
        }
        try {
            if (UtilityImpl.isSecurityOff(string)) {
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    string6 = HMacUtil.hmacSha1Hex(string2.getBytes(), (string + string3).getBytes());
                } else {
                    ALog.e(TAG, "getAppsign secret null", new Object[0]);
                }
            } else {
                SecurityGuardManager securityGuardManager = SecurityGuardManager.getInstance((Context)context);
                if (securityGuardManager != null) {
                    ALog.d(TAG, "SecurityGuardManager not null!", new Object[0]);
                    ISecureSignatureComponent iSecureSignatureComponent = securityGuardManager.getSecureSignatureComp();
                    SecurityGuardParamContext securityGuardParamContext = new SecurityGuardParamContext();
                    securityGuardParamContext.appKey = string;
                    securityGuardParamContext.paramMap.put("INPUT", string3 + string);
                    securityGuardParamContext.requestType = 3;
                    AccsClientConfig accsClientConfig = AccsClientConfig.getConfig(string);
                    String string7 = accsClientConfig != null ? accsClientConfig.getAuthCode() : null;
                    string6 = iSecureSignatureComponent.signRequest(securityGuardParamContext, string7);
                } else {
                    ALog.d(TAG, "SecurityGuardManager is null", new Object[0]);
                }
            }
        }
        catch (Throwable throwable) {
            ALog.e(TAG, "getAppsign", throwable, new Object[0]);
        }
        return string6;
    }

    public static byte[] staticBinarySafeDecryptNoB64(Context context, String string, byte[] byArray) {
        byte[] byArray2 = null;
        if (UtilityImpl.isSecurityOff(string)) {
            return byArray2;
        }
        if (context == null || byArray == null) {
            ALog.e(TAG, "staticBinarySafeDecryptNoB64 input null!", new Object[0]);
            return byArray2;
        }
        try {
            IStaticDataEncryptComponent iStaticDataEncryptComponent;
            AccsClientConfig accsClientConfig = AccsClientConfig.getConfig(string);
            String string2 = accsClientConfig != null ? accsClientConfig.getAuthCode() : null;
            ALog.i(TAG, "staticBinarySafeDecryptNoB64", "appkey", string, "authcode", string2);
            SecurityGuardManager securityGuardManager = SecurityGuardManager.getInstance((Context)context);
            if (securityGuardManager != null && (iStaticDataEncryptComponent = securityGuardManager.getStaticDataEncryptComp()) != null) {
                byArray2 = iStaticDataEncryptComponent.staticBinarySafeDecryptNoB64(16, "tnet_pksg_key", byArray, string2);
            }
            if (byArray2 == null) {
                ALog.e(TAG, "staticBinarySafeDecryptNoB64 null", new Object[0]);
            }
        }
        catch (Throwable throwable) {
            ALog.e(TAG, "staticBinarySafeDecryptNoB64", throwable, new Object[0]);
        }
        return byArray2;
    }

    public static int SecurityGuardPutSslTicket2(Context context, String string, String string2, byte[] byArray) {
        int n2 = -1;
        if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2) || context == null || byArray == null) {
            return n2;
        }
        try {
            IDynamicDataStoreComponent iDynamicDataStoreComponent;
            if (UtilityImpl.isSecurityOff(string)) {
                return n2;
            }
            SecurityGuardManager securityGuardManager = SecurityGuardManager.getInstance((Context)context);
            if (securityGuardManager != null && (iDynamicDataStoreComponent = securityGuardManager.getDynamicDataStoreComp()) != null) {
                n2 = iDynamicDataStoreComponent.putByteArray(SSL_TIKET_KEY2 + string2, byArray);
            }
        }
        catch (Throwable throwable) {
            ALog.e(TAG, "SecurityGuardPutSslTicket2", throwable, new Object[0]);
        }
        return n2;
    }

    public static byte[] SecurityGuardGetSslTicket2(Context context, String string, String string2) {
        byte[] byArray = null;
        if (context == null || TextUtils.isEmpty((CharSequence)string2) || TextUtils.isEmpty((CharSequence)string)) {
            ALog.i(TAG, "get sslticket input null", new Object[0]);
            return byArray;
        }
        try {
            IDynamicDataStoreComponent iDynamicDataStoreComponent;
            if (UtilityImpl.isSecurityOff(string)) {
                return byArray;
            }
            SecurityGuardManager securityGuardManager = SecurityGuardManager.getInstance((Context)context);
            if (securityGuardManager != null && (iDynamicDataStoreComponent = securityGuardManager.getDynamicDataStoreComp()) != null) {
                byArray = iDynamicDataStoreComponent.getByteArray(SSL_TIKET_KEY2 + string2);
            }
        }
        catch (Throwable throwable) {
            ALog.e(TAG, "SecurityGuardGetSslTicket2", throwable, new Object[0]);
        }
        return byArray;
    }

    public static boolean isNetworkConnected(Context context) {
        if (context != null) {
            try {
                ConnectivityManager connectivityManager = GlobalClientInfo.getInstance(context).getConnectivityManager();
                NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
                if (networkInfo != null) {
                    return networkInfo.isConnected();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return true;
    }

    public static String getDeviceId(Context context) {
        return a.b(context);
    }

    public static boolean isServiceRunning(Context context, String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List list = activityManager.getRunningServices(30);
        for (ActivityManager.RunningServiceInfo runningServiceInfo : list) {
            if (!runningServiceInfo.service.getPackageName().equals(string) || !runningServiceInfo.service.getClassName().equals("com.taobao.accs.ChannelService")) continue;
            return true;
        }
        return false;
    }

    public static boolean isFirstStart(Context context) {
        byte[] byArray = mLock;
        synchronized (mLock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return context.getSharedPreferences("ACCS_SDK", 0).getInt("version", -1) != 220;
        }
    }

    public static void setSdkStart(Context context) {
        try {
            byte[] byArray = mLock;
            synchronized (mLock) {
                SharedPreferences.Editor editor = context.getSharedPreferences("ACCS_SDK", 0).edit();
                editor.putInt("version", 220);
                editor.apply();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                ALog.i(TAG, "setSdkStart", new Object[0]);
            }
        }
        catch (Throwable throwable) {
            ALog.e(TAG, "setSdkStart", throwable, new Object[0]);
        }
    }

    public static boolean packageExist(Context context, String string) {
        try {
            context.getPackageManager().getPackageInfo(string, 0);
            return true;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            ALog.e(TAG, "package not exist", "pkg", string);
            return false;
        }
    }

    public static boolean utdidChanged(Context context) {
        boolean bl = false;
        try {
            byte[] byArray = mLock;
            synchronized (mLock) {
                String string = UtilityImpl.getDeviceId(context);
                SharedPreferences sharedPreferences = context.getSharedPreferences("ACCS_SDK", 0);
                String string2 = sharedPreferences.getString("utdid", string);
                bl = !string2.equals(string);
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
        catch (Throwable throwable) {
            ALog.e(TAG, "saveUtdid", throwable, new Object[0]);
        }
        {
            return bl;
        }
    }

    public static void saveUtdid(Context context) {
        try {
            byte[] byArray = mLock;
            synchronized (mLock) {
                SharedPreferences.Editor editor = context.getSharedPreferences("ACCS_SDK", 0).edit();
                editor.putString("utdid", UtilityImpl.getDeviceId(context));
                editor.apply();
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        catch (Throwable throwable) {
            ALog.e(TAG, "saveUtdid", throwable, new Object[0]);
        }
        {
            return;
        }
    }

    public static boolean channelServiceExist(Context context, String string) {
        try {
            return context.getPackageManager().getServiceInfo(new ComponentName(string, "com.taobao.accs.ChannelService"), 0).isEnabled();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void setServiceTime(Context context, String string, long l2) {
        try {
            SharedPreferences.Editor editor = context.getSharedPreferences("ACCS_SDK_CHANNEL", 0).edit();
            editor.putLong(string, l2);
            editor.commit();
            ALog.d(TAG, "setServiceTime:" + l2, new Object[0]);
        }
        catch (Throwable throwable) {
            ALog.e(TAG, "setServiceTime:", throwable, new Object[0]);
        }
    }

    public static long getServiceAliveTime(Context context) {
        long l2 = 0L;
        try {
            SharedPreferences sharedPreferences = context.getSharedPreferences("ACCS_SDK_CHANNEL", 0);
            long l3 = sharedPreferences.getLong("service_start", 0L);
            long l4 = sharedPreferences.getLong("service_end", 0L);
            if (l3 > 0L) {
                l2 = l4 - l3;
            }
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putLong("service_start", 0L);
            editor.putLong("service_end", 0L);
            editor.commit();
        }
        catch (Throwable throwable) {
            ALog.e(TAG, "getServiceAliveTime:", throwable, new Object[0]);
        }
        return l2;
    }

    public static boolean isAccsStatisticsOff(Context context) {
        return true;
    }

    public static int praseInt(String string) {
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n2;
    }

    public static String getAppVersion(Context context) {
        String string = "";
        try {
            string = GlobalClientInfo.getInstance((Context)context).getPackageInfo().versionName;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    public static String getProcessName(Context context, int n2) {
        return a.a(context, n2);
    }

    public static boolean isMainProcess(Context context) {
        return a.a(context);
    }

    public static boolean isChannelProcess(Context context) {
        return false;
    }

    public static int getByteLen(String string) {
        int n2 = 0;
        if (string == null) {
            return n2;
        }
        try {
            n2 = string.getBytes("utf-8").length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return n2;
    }

    public static String getStackMsg(Throwable throwable) {
        return a.a(throwable);
    }

    public static File getExternalFilesDir(Context context) {
        return context.getExternalFilesDir(null);
    }

    public static File getCacheFilesDir(Context context) {
        return context.getExternalCacheDir();
    }

    public static void storeCookie(Context context, String string) {
        try {
            if (!TextUtils.isEmpty((CharSequence)string)) {
                GlobalClientInfo.c = string;
                SharedPreferences.Editor editor = context.getSharedPreferences("ACCS_COOKIE", 0).edit();
                editor.putString("cookie_sec", string);
                editor.apply();
            }
        }
        catch (Exception exception) {
            ALog.e(TAG, "storeCookie fail", exception, new Object[0]);
        }
    }

    public static String restoreCookie(Context context) {
        String string = null;
        try {
            SharedPreferences sharedPreferences = context.getSharedPreferences("ACCS_COOKIE", 4);
            string = sharedPreferences.getString("cookie_sec", null);
        }
        catch (Exception exception) {
            ALog.e(TAG, "reStoreCookie fail", exception, new Object[0]);
        }
        return string;
    }

    public static void clearCookie(Context context) {
        try {
            GlobalClientInfo.c = null;
            SharedPreferences.Editor editor = context.getSharedPreferences("ACCS_COOKIE", 0).edit();
            editor.clear();
            editor.apply();
        }
        catch (Throwable throwable) {
            ALog.e(TAG, "clearCookie fail", throwable, new Object[0]);
        }
    }

    public static long getUsableSpace() {
        return a.a();
    }

    public static String convertHost(String string) {
        String string2 = null;
        try {
            if (TextUtils.isEmpty((CharSequence)string)) {
                return string2;
            }
            if (string.startsWith("//")) {
                string2 = "https:" + string;
                return string2;
            }
            int n2 = string.indexOf("://");
            if (n2 == -1) {
                string2 = "https://" + string;
                return string2;
            }
            String string3 = string.substring(n2 + 3);
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                string2 = "https://" + string3;
            }
        }
        catch (Throwable throwable) {
            ALog.e(TAG, "convertHost", throwable, new Object[0]);
        }
        return string2;
    }

    public static String getProxyIp() {
        if (Build.VERSION.SDK_INT < 11) {
            return Proxy.getDefaultHost();
        }
        return System.getProperty("http.proxyHost");
    }

    public static int getProxyPort() {
        if (Build.VERSION.SDK_INT < 11) {
            return Proxy.getDefaultPort();
        }
        try {
            return Integer.parseInt(System.getProperty("http.proxyPort"));
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public static String getProxy() {
        String string = UtilityImpl.getProxyIp() + ":" + UtilityImpl.getProxyPort();
        if (ALog.isPrintLog(ALog.Level.D)) {
            ALog.d(TAG, "getProxy:" + string, new Object[0]);
        }
        return string;
    }

    public static String isNotificationEnabled(Context context) {
        return a.d(context);
    }

    public static String getTnetLogFilePath(Context context, String string) {
        String string2 = null;
        try {
            File file = context.getExternalFilesDir("tnetlogs");
            if (file == null || !file.exists() || !file.canWrite()) {
                file = context.getDir("logs", 0);
            }
            ALog.d(TAG, "getTnetLogFilePath :" + file, new Object[0]);
            string2 = file + "/" + string.toLowerCase();
        }
        catch (Throwable throwable) {
            ALog.e(TAG, "getTnetLogFilePath", throwable, new Object[0]);
        }
        return string2;
    }

    public static String int2String(int n2) {
        String string = null;
        try {
            string = String.valueOf(n2);
        }
        catch (Exception exception) {
            ALog.e(TAG, "int2String", exception, new Object[0]);
        }
        return string;
    }

    public static int String2Int(String string) {
        int n2 = 0;
        try {
            n2 = Integer.valueOf(string);
        }
        catch (Exception exception) {
            ALog.e(TAG, "String2Int", exception, new Object[0]);
        }
        return n2;
    }

    public static String getDefaultAppkey(Context context) {
        String[] stringArray = UtilityImpl.getAppkey(context);
        return stringArray != null && stringArray.length > 0 ? stringArray[0] : null;
    }

    public static String[] getAppkey(Context context) {
        String[] stringArray = null;
        byte[] byArray = mLock;
        synchronized (mLock) {
            stringArray = ACCSManager.getAppkey(context);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return stringArray;
        }
    }

    public static void saveAppKey(Context context, String string, String string2) {
        try {
            byte[] byArray = mLock;
            synchronized (mLock) {
                SharedPreferences sharedPreferences = context.getSharedPreferences("ACCS_SDK", 0);
                String string3 = sharedPreferences.getString("appkey", "");
                if (TextUtils.isEmpty((CharSequence)string) || string3.equals(string) || string3.contains(string)) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
                String string4 = TextUtils.isEmpty((CharSequence)string3) ? string : string3 + "|" + string;
                SharedPreferences.Editor editor = sharedPreferences.edit();
                editor.putString("appkey", string4);
                editor.commit();
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        {
            return;
        }
    }

    public static void clearSharePreferences(Context context) {
        try {
            byte[] byArray = mLock;
            synchronized (mLock) {
                SharedPreferences sharedPreferences = context.getSharedPreferences("ACCS_SDK", 0);
                String string = sharedPreferences.getString("appkey", null);
                String string2 = sharedPreferences.getString("app_sercet", null);
                String string3 = sharedPreferences.getString("proxy_host", null);
                int n2 = sharedPreferences.getInt("proxy_port", -1);
                int n3 = sharedPreferences.getInt("version", -1);
                int n4 = sharedPreferences.getInt("debug_mode", 0);
                SharedPreferences.Editor editor = context.getSharedPreferences("ACCS_SDK", 0).edit();
                editor.clear();
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    editor.putString("appkey", string);
                }
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    editor.putString("app_sercet", string2);
                }
                if (!TextUtils.isEmpty((CharSequence)string3)) {
                    editor.putString("proxy_host", string3);
                }
                if (n2 > 0) {
                    editor.putInt("proxy_port", n2);
                }
                if (n3 > 0) {
                    editor.putInt("version", n3);
                }
                if (n4 == 2 || n4 == 1) {
                    editor.putInt("debug_mode", n4);
                }
                editor.commit();
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        catch (Throwable throwable) {
            ALog.e(TAG, "clearSharePreferences", throwable, new Object[0]);
        }
        {
            return;
        }
    }
}

