/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.accs;

import android.content.Context;
import android.text.TextUtils;
import anet.channel.SessionCenter;
import anet.channel.entity.ENV;
import com.taobao.accs.ACCSManager;
import com.taobao.accs.AccsClientConfig;
import com.taobao.accs.AccsException;
import com.taobao.accs.IACCSManager;
import com.taobao.accs.IAppReceiver;
import com.taobao.accs.ILoginInfo;
import com.taobao.accs.base.AccsAbstractDataListener;
import com.taobao.accs.base.TaoBaseService;
import com.taobao.accs.utl.ALog;
import com.taobao.accs.utl.j;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ACCSClient {
    protected IACCSManager mAccsManager;
    private static final String TAG = "ACCSClient";
    private static Context mContext;
    private AccsClientConfig mConfig;
    public static Map<String, ACCSClient> mACCSClients;

    public ACCSClient(Context context, AccsClientConfig accsClientConfig) {
        this.mConfig = accsClientConfig;
        this.mAccsManager = ACCSManager.getAccsInstance(mContext, accsClientConfig.getAppKey());
    }

    public static synchronized String init(Context context, String string) throws AccsException {
        if (context == null || TextUtils.isEmpty((CharSequence)string)) {
            throw new AccsException("params error");
        }
        AccsClientConfig.Builder builder = new AccsClientConfig.Builder();
        AccsClientConfig accsClientConfig = builder.setAppKey(string).build();
        return ACCSClient.init(context, accsClientConfig);
    }

    public static synchronized String init(Context context, AccsClientConfig accsClientConfig) throws AccsException {
        if (context == null || accsClientConfig == null) {
            throw new AccsException("params error");
        }
        mContext = context.getApplicationContext();
        ALog.i(TAG, "init", "config", accsClientConfig.toString());
        return accsClientConfig.getTag();
    }

    public static synchronized ACCSClient getAccsClient(String string) throws AccsException {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new AccsException("tag null");
        }
        AccsClientConfig accsClientConfig = AccsClientConfig.getConfigByTag(string);
        if (accsClientConfig == null) {
            ALog.e(TAG, "configTag not exist, please init first!!", new Object[0]);
            throw new AccsException("tag not exist");
        }
        ALog.i(TAG, "getAccsClient", "configTag", string);
        ACCSClient aCCSClient = mACCSClients.get(string);
        if (aCCSClient == null) {
            ALog.i(TAG, "getAccsClient create client", "config", accsClientConfig.toString());
            aCCSClient = new ACCSClient(mContext, accsClientConfig);
            mACCSClients.put(string, aCCSClient);
            return aCCSClient;
        }
        if (accsClientConfig.equals(aCCSClient.mConfig)) {
            ALog.i(TAG, "getAccsClient exists", new Object[0]);
            return aCCSClient;
        }
        ALog.i(TAG, "getAccsClient update config", "old config", aCCSClient.mConfig.getTag(), "new config", accsClientConfig.getTag());
        aCCSClient.mConfig = accsClientConfig;
        aCCSClient.mAccsManager = ACCSManager.getAccsInstance(mContext, accsClientConfig.getAppKey());
        return aCCSClient;
    }

    public static synchronized void setEnvironment(Context context, @AccsClientConfig.ENV int n2) {
        int n3 = n2;
        try {
            if (n2 < 0 || n2 > 2) {
                ALog.e(TAG, "env error", "env", n2);
                n3 = 0;
            }
            int n4 = AccsClientConfig.mEnv;
            AccsClientConfig.mEnv = n3;
            if (n4 != n3) {
                ALog.i(TAG, "setEnvironment:" + n3, new Object[0]);
                j.b(context);
                j.d(context);
                j.c(context);
                if (n3 == 2) {
                    SessionCenter.switchEnvironment(ENV.TEST);
                } else if (n3 == 1) {
                    SessionCenter.switchEnvironment(ENV.PREPARE);
                }
                for (Map.Entry<String, ACCSClient> entry : mACCSClients.entrySet()) {
                    try {
                        ACCSClient.getAccsClient(entry.getKey());
                    }
                    catch (AccsException accsException) {
                        ALog.e(TAG, "setEnvironment update client", accsException, new Object[0]);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            ALog.e(TAG, "setEnvironment", throwable, new Object[0]);
        }
        finally {
            j.a(context, n3);
        }
    }

    public void bindApp(String string, IAppReceiver iAppReceiver) {
        if (this.mAccsManager == null) {
            ALog.e(TAG, "bindApp mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.bindApp(mContext, this.mConfig.getAppKey(), this.mConfig.getAppSecret(), string, iAppReceiver);
    }

    public void bindUser(String string) {
        if (this.mAccsManager == null) {
            ALog.e(TAG, "bindUser mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.bindUser(mContext, string);
    }

    public void bindUser(String string, boolean bl) {
        if (this.mAccsManager == null) {
            ALog.e(TAG, "bindUser mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.bindUser(mContext, string, bl);
    }

    public void unbindUser() {
        if (this.mAccsManager == null) {
            ALog.e(TAG, "unbindUser mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.unbindUser(mContext);
    }

    public void bindService(String string) {
        if (this.mAccsManager == null) {
            ALog.e(TAG, "bindService mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.bindService(mContext, string);
    }

    public void unbindService(String string) {
        if (this.mAccsManager == null) {
            ALog.e(TAG, "unbindService mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.unbindService(mContext, string);
    }

    public String sendData(ACCSManager.AccsRequest accsRequest) {
        if (this.mAccsManager == null) {
            ALog.e(TAG, "sendData mAccsManager null", new Object[0]);
            return null;
        }
        return this.mAccsManager.sendData(mContext, accsRequest);
    }

    public String sendRequest(ACCSManager.AccsRequest accsRequest) {
        if (this.mAccsManager == null) {
            ALog.e(TAG, "sendRequest mAccsManager null", new Object[0]);
            return null;
        }
        return this.mAccsManager.sendRequest(mContext, accsRequest);
    }

    public String sendPushResponse(ACCSManager.AccsRequest accsRequest, TaoBaseService.ExtraInfo extraInfo) {
        if (this.mAccsManager == null) {
            ALog.e(TAG, "sendPushResponse mAccsManager null", new Object[0]);
            return null;
        }
        return this.mAccsManager.sendPushResponse(mContext, accsRequest, extraInfo);
    }

    public boolean isNetworkReachable() {
        if (this.mAccsManager == null) {
            ALog.e(TAG, "isNetworkReachable mAccsManager null", new Object[0]);
            return false;
        }
        return this.mAccsManager.isNetworkReachable(mContext);
    }

    public void forceDisableService() {
        if (this.mAccsManager == null) {
            ALog.e(TAG, "forceDisableService mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.forceDisableService(mContext);
    }

    public void forceEnableService() {
        if (this.mAccsManager == null) {
            ALog.e(TAG, "forceEnableService mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.forceEnableService(mContext);
    }

    public void startInAppConnection(String string, IAppReceiver iAppReceiver) {
        if (this.mAccsManager == null) {
            ALog.e(TAG, "startInAppConnection mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.startInAppConnection(mContext, this.mConfig.getAppKey(), this.mConfig.getAppSecret(), string, iAppReceiver);
    }

    public void setLoginInfo(ILoginInfo iLoginInfo) {
        if (this.mAccsManager == null) {
            ALog.e(TAG, "setLoginInfo mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.setLoginInfo(mContext, iLoginInfo);
    }

    public void clearLoginInfo() {
        if (this.mAccsManager == null) {
            ALog.e(TAG, "clearLoginInfo mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.clearLoginInfo(mContext);
    }

    public boolean cancel(String string) {
        if (this.mAccsManager == null) {
            ALog.e(TAG, "cancel mAccsManager null", new Object[0]);
            return false;
        }
        return this.mAccsManager.cancel(mContext, string);
    }

    public boolean isChannelError(int n2) {
        if (this.mAccsManager == null) {
            ALog.e(TAG, "isChannelError mAccsManager null", new Object[0]);
            return true;
        }
        return this.mAccsManager.isChannelError(n2);
    }

    public Map<String, Boolean> getChannelState() throws Exception {
        if (this.mAccsManager == null) {
            ALog.e(TAG, "getChannelState mAccsManager null", new Object[0]);
            return null;
        }
        return this.mAccsManager.getChannelState();
    }

    public Map<String, Boolean> forceReConnectChannel() throws Exception {
        if (this.mAccsManager == null) {
            ALog.e(TAG, "forceReConnectChannel mAccsManager null", new Object[0]);
            return null;
        }
        return this.mAccsManager.forceReConnectChannel();
    }

    public String getUserUnit() {
        if (this.mAccsManager == null) {
            ALog.e(TAG, "getUserUnit mAccsManager null", new Object[0]);
            return null;
        }
        return this.mAccsManager.getUserUnit();
    }

    public void registerSerivce(String string, String string2) {
        if (this.mAccsManager == null) {
            ALog.e(TAG, "registerSerivce mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.registerSerivce(mContext, string, string2);
    }

    public void unRegisterSerivce(String string) {
        if (this.mAccsManager == null) {
            ALog.e(TAG, "unRegisterSerivce mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.unRegisterSerivce(mContext, string);
    }

    public void registerDataListener(String string, AccsAbstractDataListener accsAbstractDataListener) {
        if (this.mAccsManager == null) {
            ALog.e(TAG, "registerDataListener mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.registerDataListener(mContext, string, accsAbstractDataListener);
    }

    public void unRegisterDataListener(String string) {
        if (this.mAccsManager == null) {
            ALog.e(TAG, "unRegisterDataListener mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.unRegisterDataListener(mContext, string);
    }

    public void sendBusinessAck(String string, String string2, String string3, short s, String string4, Map<TaoBaseService.ExtHeaderType, String> map) {
        if (this.mAccsManager == null) {
            ALog.e(TAG, "sendBusinessAck mAccsManager null", new Object[0]);
            return;
        }
        this.mAccsManager.sendBusinessAck(string, string2, string3, s, string4, map);
    }

    static {
        mACCSClients = new ConcurrentHashMap<String, ACCSClient>(2);
    }
}

