/*
 * Decompiled with CFR 0.152.
 */
package anetwork.channel.unified;

import android.text.TextUtils;
import anet.channel.Config;
import anet.channel.GlobalAppRuntimeInfo;
import anet.channel.RequestCb;
import anet.channel.Session;
import anet.channel.SessionCenter;
import anet.channel.appmonitor.AppMonitor;
import anet.channel.entity.ConnType;
import anet.channel.entity.ENV;
import anet.channel.entity.a;
import anet.channel.flow.b;
import anet.channel.flow.c;
import anet.channel.request.Cancelable;
import anet.channel.request.Request;
import anet.channel.statist.RequestStatistic;
import anet.channel.status.NetworkStatusHelper;
import anet.channel.util.ALog;
import anet.channel.util.e;
import anetwork.channel.aidl.DefaultFinishEvent;
import anetwork.channel.cache.Cache;
import anetwork.channel.cache.CacheHelper;
import anetwork.channel.config.NetworkConfigCenter;
import anetwork.channel.cookie.CookieManager;
import anetwork.channel.http.NetworkSdkSetting;
import anetwork.channel.stat.NetworkStat;
import anetwork.channel.statist.StatisticReqTimes;
import anetwork.channel.unified.IUnifiedTask;
import anetwork.channel.unified.RequestContext;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

class NetworkTask
implements IUnifiedTask {
    public static final String TAG = "anet.NetworkTask";
    RequestContext rc;
    Cache cache = null;
    Cache.Entry entry = null;
    ByteArrayOutputStream cacheBuffer = null;
    String f_refer = "other";
    volatile Cancelable cancelable = null;
    volatile boolean isCanceled = false;
    volatile AtomicBoolean isDone = null;
    int statusCode = 0;
    int contentLength = 0;
    int dataChunkIndex = 0;

    NetworkTask(RequestContext requestContext, Cache cache, Cache.Entry entry) {
        this.rc = requestContext;
        this.isDone = requestContext.isDone;
        this.cache = cache;
        this.entry = entry;
        this.f_refer = requestContext.config.getHeaders().get("f-refer");
    }

    @Override
    public void cancel() {
        this.isCanceled = true;
        if (this.cancelable != null) {
            this.cancelable.cancel();
        }
    }

    @Override
    public void run() {
        if (this.isCanceled) {
            return;
        }
        if (!NetworkStatusHelper.f()) {
            if (ALog.isPrintLog(2)) {
                ALog.i(TAG, "network unavailable", this.rc.seqNum, new Object[]{"NetworkStatus", NetworkStatusHelper.a()});
            }
            this.rc.callback.onFinish(new DefaultFinishEvent(-200));
            return;
        }
        if (ALog.isPrintLog(2)) {
            ALog.i(TAG, "exec request", this.rc.seqNum, "retryTimes", this.rc.config.getCurrentRetryTimes());
        }
        try {
            this.sendRequest(this.tryGetSession(), this.rc.config.getAwcnRequest());
        }
        catch (Exception exception) {
            ALog.e(TAG, "send request failed.", this.rc.seqNum, exception, new Object[0]);
        }
    }

    private e checkCName(e e2) {
        e e3;
        String string = this.rc.config.getHeaders().get("x-host-cname");
        if (!TextUtils.isEmpty((CharSequence)string) && (e3 = e.a(e2.d().replace(this.rc.config.getHttpUrl().b(), string))) != null) {
            e2 = e3;
        }
        return e2;
    }

    private SessionCenter getSessionCenter() {
        Config config;
        String string = this.rc.config.getRequestProperty("APPKEY");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return SessionCenter.getInstance();
        }
        ENV eNV = ENV.ONLINE;
        String string2 = this.rc.config.getRequestProperty("ENVIRONMENT");
        if ("Pre".equals(string2)) {
            eNV = ENV.PREPARE;
        } else if ("Test".equals(string2)) {
            eNV = ENV.TEST;
        }
        if (eNV != NetworkSdkSetting.CURRENT_ENV) {
            NetworkSdkSetting.CURRENT_ENV = eNV;
            SessionCenter.switchEnvironment(eNV);
        }
        if ((config = Config.getConfig(string, eNV)) == null) {
            config = new Config.Builder().setAppkey(string).setEnv(eNV).setAuthCode(this.rc.config.getRequestProperty("AuthCode")).build();
        }
        return SessionCenter.getInstance(config);
    }

    private Session tryGetSession() {
        SessionCenter sessionCenter = this.getSessionCenter();
        Session session = null;
        if (this.rc.config.getRequestType() == 1 && NetworkConfigCenter.isSpdyEnabled() && this.rc.config.getCurrentRetryTimes() == 0) {
            session = sessionCenter.get(this.checkCName(this.rc.config.getHttpUrl()), ConnType.TypeLevel.SPDY, (long)this.rc.config.getConnectTimeout());
        }
        if (session == null && this.rc.config.isHttpSessionEnable() && !NetworkStatusHelper.g()) {
            session = sessionCenter.get(this.rc.config.getHttpUrl(), ConnType.TypeLevel.HTTP, 0L);
        }
        if (session == null) {
            ALog.i(TAG, "create HttpSession with local DNS", this.rc.seqNum, new Object[0]);
            session = new anet.channel.session.e(GlobalAppRuntimeInfo.getContext(), new a(this.rc.config.getHttpUrl().c(), this.rc.seqNum, null));
        }
        this.rc.statisticData.connectionType = session.getConnType().toProtocol();
        this.rc.statisticData.isSSL = session.getConnType().isSSL();
        ALog.i(TAG, "tryGetSession", this.rc.seqNum, "Session", session);
        return session;
    }

    private void sendRequest(Session session, Request request) {
        Object object;
        if (session == null || this.isCanceled) {
            return;
        }
        Request.Builder builder = null;
        if (this.rc.config.isRequestCookieEnabled() && !TextUtils.isEmpty((CharSequence)(object = CookieManager.getCookie(this.rc.config.getUrlString())))) {
            builder = request.newBuilder();
            builder.addHeader("Cookie", (String)object);
        }
        if (this.entry != null) {
            if (builder == null) {
                builder = request.newBuilder();
            }
            if (this.entry.etag != null) {
                builder.addHeader("If-None-Match", this.entry.etag);
            }
            if (this.entry.lastModified > 0L) {
                builder.addHeader("If-Modified-Since", CacheHelper.toGMTDate(this.entry.lastModified));
            }
        }
        object = builder == null ? request : builder.build();
        StatisticReqTimes.getIntance().putReq(((Request)object).getUrl());
        this.cancelable = session.request((Request)object, new RequestCb((Request)object){
            final /* synthetic */ Request val$request;
            {
                this.val$request = request;
            }

            @Override
            public void onResponseCode(int n2, Map<String, List<String>> map) {
                CharSequence charSequence;
                if (NetworkTask.this.isDone.get()) {
                    return;
                }
                if (ALog.isPrintLog(2)) {
                    charSequence = new StringBuilder("[onResponseCode]");
                    ((StringBuilder)charSequence).append("responseCode:").append(n2);
                    if (map != null) {
                        ((StringBuilder)charSequence).append(", header:").append(map.toString());
                    }
                    ALog.i(NetworkTask.TAG, ((StringBuilder)charSequence).toString(), NetworkTask.this.rc.seqNum, new Object[0]);
                }
                if (anet.channel.util.c.a(this.val$request, n2) && (charSequence = anet.channel.util.c.b(map, "Location")) != null) {
                    e e2 = e.a((String)charSequence);
                    if (e2 != null) {
                        if (NetworkTask.this.isDone.compareAndSet(false, true)) {
                            e2.h();
                            NetworkTask.this.rc.config.redirectToUrl(e2);
                            NetworkTask.this.rc.statisticData.host = NetworkTask.this.rc.config.getHttpUrl().b();
                            NetworkTask.this.rc.isDone = new AtomicBoolean();
                            NetworkTask.this.rc.runningTask = new NetworkTask(NetworkTask.this.rc, null, null);
                            anet.channel.c.c.a(NetworkTask.this.rc.runningTask, 0);
                        }
                        return;
                    }
                    ALog.e(NetworkTask.TAG, "redirect url is invalid!", this.val$request.getSeq(), "redirect url", charSequence);
                }
                try {
                    NetworkTask.this.rc.cancelTimeoutTask();
                    NetworkTask.this.statusCode = n2;
                    CookieManager.setCookie(NetworkTask.this.rc.config.getUrlString(), map);
                    NetworkTask.this.contentLength = anet.channel.util.c.c(map);
                    if (n2 == 304 && NetworkTask.this.entry != null) {
                        NetworkTask.this.entry.responseHeaders.putAll(map);
                        NetworkTask.this.rc.callback.onResponseCode(200, NetworkTask.this.entry.responseHeaders);
                        NetworkTask.this.rc.callback.onDataReceiveSize(1, NetworkTask.this.entry.data.length, anet.channel.a.a.a(NetworkTask.this.entry.data));
                        return;
                    }
                    if (NetworkTask.this.cache != null) {
                        NetworkTask.this.entry = CacheHelper.parseCacheHeaders(map);
                        if (NetworkTask.this.entry != null) {
                            anet.channel.util.c.c(map, "Cache-Control");
                            map.put("Cache-Control", Arrays.asList("no-store"));
                            NetworkTask.this.cacheBuffer = new ByteArrayOutputStream(NetworkTask.this.contentLength != 0 ? NetworkTask.this.contentLength : 5120);
                        }
                    }
                    NetworkTask.this.rc.callback.onResponseCode(n2, map);
                }
                catch (Exception exception) {
                    ALog.w(NetworkTask.TAG, "[onResponseCode] error.", NetworkTask.this.rc.seqNum, exception, new Object[0]);
                }
            }

            @Override
            public void onDataReceive(anet.channel.a.a a2, boolean bl) {
                if (NetworkTask.this.isDone.get()) {
                    return;
                }
                if (NetworkTask.this.dataChunkIndex == 0) {
                    ALog.i(NetworkTask.TAG, "[onDataReceive] receive first data chunk!", NetworkTask.this.rc.seqNum, new Object[0]);
                }
                if (bl) {
                    ALog.i(NetworkTask.TAG, "[onDataReceive] receive last data chunk!", NetworkTask.this.rc.seqNum, new Object[0]);
                }
                try {
                    ++NetworkTask.this.dataChunkIndex;
                    NetworkTask.this.rc.callback.onDataReceiveSize(NetworkTask.this.dataChunkIndex, NetworkTask.this.contentLength, a2);
                    if (NetworkTask.this.cacheBuffer != null) {
                        NetworkTask.this.cacheBuffer.write(a2.a(), 0, a2.c());
                        if (bl) {
                            NetworkTask.this.entry.data = NetworkTask.this.cacheBuffer.toByteArray();
                            long l2 = System.currentTimeMillis();
                            NetworkTask.this.cache.put(NetworkTask.this.rc.config.getUrlString(), NetworkTask.this.entry);
                            ALog.i(NetworkTask.TAG, "write cache", NetworkTask.this.rc.seqNum, "cost", System.currentTimeMillis() - l2, "size", NetworkTask.this.entry.data.length, "key", NetworkTask.this.rc.config.getUrlString());
                        }
                    }
                }
                catch (Exception exception) {
                    ALog.w(NetworkTask.TAG, "[onDataReceive] error.", NetworkTask.this.rc.seqNum, exception, new Object[0]);
                }
            }

            @Override
            public void onFinish(int n2, String string, RequestStatistic requestStatistic) {
                if (NetworkTask.this.isDone.getAndSet(true)) {
                    return;
                }
                NetworkTask.this.rc.cancelTimeoutTask();
                if (ALog.isPrintLog(2)) {
                    ALog.i(NetworkTask.TAG, "[onFinish]", NetworkTask.this.rc.seqNum, "code", n2, "msg", string);
                }
                try {
                    if (n2 < 0 && NetworkTask.this.rc.config.isAllowRetry()) {
                        NetworkTask.this.rc.config.retryRequest();
                        NetworkTask.this.rc.isDone = new AtomicBoolean();
                        NetworkTask.this.rc.runningTask = new NetworkTask(NetworkTask.this.rc, NetworkTask.this.cache, NetworkTask.this.entry);
                        anet.channel.c.c.a(new Runnable(){

                            @Override
                            public void run() {
                                anet.channel.c.c.b(NetworkTask.this.rc.runningTask);
                            }
                        }, NetworkTask.this.rc.config.getCurrentRetryTimes() * 2000, TimeUnit.MILLISECONDS);
                        return;
                    }
                    if (NetworkTask.this.statusCode == 0) {
                        NetworkTask.this.statusCode = n2;
                    }
                    requestStatistic.statusCode = NetworkTask.this.statusCode;
                    requestStatistic.msg = string;
                    NetworkTask.this.rc.statisticData.filledBy(requestStatistic);
                    DefaultFinishEvent defaultFinishEvent = null;
                    if (NetworkTask.this.statusCode == 304 && NetworkTask.this.entry != null) {
                        requestStatistic.protocolType = "cache";
                        defaultFinishEvent = new DefaultFinishEvent(200, string, NetworkTask.this.rc.statisticData);
                    } else {
                        defaultFinishEvent = new DefaultFinishEvent(NetworkTask.this.statusCode, string, NetworkTask.this.rc.statisticData);
                    }
                    NetworkTask.this.rc.callback.onFinish(defaultFinishEvent);
                    if (ALog.isPrintLog(2)) {
                        ALog.i(NetworkTask.TAG, NetworkTask.this.rc.statisticData.toString(), NetworkTask.this.rc.seqNum, new Object[0]);
                    }
                    if (n2 != -200) {
                        AppMonitor.getInstance().commitStat(requestStatistic);
                    }
                    if (n2 >= 0) {
                        anet.channel.monitor.b.a().a(requestStatistic.start, requestStatistic.start + requestStatistic.oneWayTime, requestStatistic.recDataSize);
                    }
                    c.a().commitFlow(new b(NetworkTask.this.f_refer, requestStatistic));
                    NetworkStat.getNetworkStat().put(NetworkTask.this.rc.config.getUrlString(), NetworkTask.this.rc.statisticData);
                    StatisticReqTimes.getIntance().updateReqTimes(this.val$request.getUrl(), System.currentTimeMillis());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }
}

