/*
 * Decompiled with CFR 0.152.
 */
package anetwork.channel.entity;

import anet.channel.request.Request;
import anet.channel.statist.RequestStatistic;
import anet.channel.util.e;
import anetwork.channel.Header;
import anetwork.channel.Param;
import anetwork.channel.aidl.ParcelableRequest;
import anetwork.channel.config.NetworkConfigCenter;
import anetwork.channel.util.SeqGen;
import java.util.HashMap;
import java.util.Map;

public class RequestConfig {
    private static final String TAG = "ANet.RequestConfig";
    private static final int MAX_RETRY_TIMES = 3;
    private static final int DFT_CONNECT_TIMEOUT = 20000;
    private static final int DFT_READ_TIMEOUT = 20000;
    private final ParcelableRequest request;
    private Request awcnRequest = null;
    private int mCurrentRetryTimes = 0;
    private int mRedirectTimes = 0;
    private int maxRetryTime = 0;
    private int connectTimeout = 0;
    private int readTimeout = 0;
    private RequestStatistic rs = null;
    private final String seqNo;
    private final int type;

    public RequestConfig(ParcelableRequest parcelableRequest, int n2) {
        if (parcelableRequest == null) {
            throw new IllegalArgumentException("request is null");
        }
        this.request = parcelableRequest;
        this.type = n2;
        this.seqNo = SeqGen.createSeqNo(parcelableRequest.getSeqNo(), n2 == 0 ? "HTTP" : "DGRD");
        this.connectTimeout = parcelableRequest.getConnectTimeout();
        if (this.connectTimeout <= 0) {
            this.connectTimeout = 20000;
        }
        this.readTimeout = parcelableRequest.getReadTimeout();
        if (this.readTimeout <= 0) {
            this.readTimeout = 20000;
        }
        this.maxRetryTime = parcelableRequest.getRetryTime();
        if (this.maxRetryTime < 0 || this.maxRetryTime > 3) {
            this.maxRetryTime = 2;
        }
        e e2 = this.initHttpUrl();
        this.rs = new RequestStatistic(e2.b(), String.valueOf(parcelableRequest.getBizId()));
        this.rs.url = e2.d();
        this.awcnRequest = this.buildRequest(e2);
    }

    public Request getAwcnRequest() {
        return this.awcnRequest;
    }

    public void setAwcnRequest(Request request) {
        this.awcnRequest = request;
    }

    private e initHttpUrl() {
        e e2 = e.a(this.request.getURL());
        if (e2 == null) {
            throw new IllegalArgumentException("url is invalid. url=" + this.request.getURL());
        }
        if (!NetworkConfigCenter.isSSLEnabled()) {
            e2.f();
        } else if (!"1".equals(this.request.getExtProperty("EnableSchemeReplace"))) {
            e2.h();
        } else {
            e2.g();
        }
        return e2;
    }

    private Request buildRequest(e e2) {
        Request.Builder builder = new Request.Builder().setUrl(e2).setMethod(this.request.getMethod()).setBody(this.request.getBodyEntry()).setReadTimeout(this.getReadTimeout()).setConnectTimeout(this.getConnectTimeout()).setRedirectEnable(this.request.getFollowRedirects()).setRedirectTimes(this.mRedirectTimes).setBizId(String.valueOf(this.request.getBizId())).setSeq(this.getSeqNo()).setRequestStatistic(this.rs);
        if (this.request.getParams() != null) {
            for (Param param : this.request.getParams()) {
                builder.addParam(param.getKey(), param.getValue());
            }
        }
        if (this.request.getCharset() != null) {
            builder.setCharset(this.request.getCharset());
        }
        builder.setHeaders(this.initHeaders());
        return builder.build();
    }

    public RequestStatistic getStatistic() {
        return this.rs;
    }

    public int getCurrentRetryTimes() {
        return this.mCurrentRetryTimes;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getWaitTimeout() {
        return this.readTimeout * (this.maxRetryTime + 1);
    }

    public String getSeqNo() {
        return this.seqNo;
    }

    public int getRequestType() {
        return this.type;
    }

    public String getRequestProperty(String string) {
        return this.request.getExtProperty(string);
    }

    public boolean isAllowRetry() {
        return this.mCurrentRetryTimes < this.maxRetryTime;
    }

    public boolean isHttpSessionEnable() {
        return NetworkConfigCenter.isHttpSessionEnable() && !"1".equals(this.request.getExtProperty("EnableHttpDns"));
    }

    public e getHttpUrl() {
        return this.awcnRequest.getHttpUrl();
    }

    public String getUrlString() {
        return this.awcnRequest.getUrlString();
    }

    public Map<String, String> getHeaders() {
        return this.awcnRequest.getHeaders();
    }

    private Map<String, String> initHeaders() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.request.getHeaders() != null) {
            for (Header header : this.request.getHeaders()) {
                String string = header.getName();
                if ("Host".equalsIgnoreCase(string) || ":host".equalsIgnoreCase(string) || "Cookie".equalsIgnoreCase(string)) continue;
                hashMap.put(string, header.getValue());
            }
        }
        return hashMap;
    }

    public boolean isRequestCookieEnabled() {
        return !"1".equals(this.request.getExtProperty("EnableCookie"));
    }

    public void retryRequest() {
        ++this.mCurrentRetryTimes;
        this.rs.retryTimes = this.mCurrentRetryTimes;
    }

    public void redirectToUrl(e e2) {
        ++this.mRedirectTimes;
        this.rs = new RequestStatistic(e2.b(), String.valueOf(this.request.getBizId()));
        this.rs.url = e2.d();
        this.awcnRequest = this.buildRequest(e2);
    }
}

