/*
 * Decompiled with CFR 0.152.
 */
package anetwork.channel.cache;

import anet.channel.util.c;
import anetwork.channel.cache.Cache;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class CacheHelper {
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final DateFormat STANDARD_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);

    public static String toGMTDate(long l2) {
        return STANDARD_FORMAT.format(new Date(l2));
    }

    private static long parseGMTDate(String string) {
        if (string.length() == 0) {
            return 0L;
        }
        try {
            ParsePosition parsePosition = new ParsePosition(0);
            Date date = STANDARD_FORMAT.parse(string, parsePosition);
            if (parsePosition.getIndex() == string.length()) {
                return date.getTime();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0L;
    }

    public static Cache.Entry parseCacheHeaders(Map<String, List<String>> map) {
        Object object;
        long l2 = System.currentTimeMillis();
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        boolean bl = false;
        String string = c.b(map, "Cache-Control");
        if (string != null) {
            bl = true;
            object = string.split(",");
            for (int i2 = 0; i2 < ((String[])object).length; ++i2) {
                String string2 = object[i2].trim();
                if (string2.equals("no-cache") || string2.equals("no-store")) {
                    return null;
                }
                if (!string2.startsWith("max-age=")) continue;
                try {
                    l7 = Long.parseLong(string2.substring(8));
                    continue;
                }
                catch (Exception exception) {}
            }
        }
        if ((string = c.b(map, "Date")) != null) {
            l3 = CacheHelper.parseGMTDate(string);
        }
        if ((string = c.b(map, "Expires")) != null) {
            l5 = CacheHelper.parseGMTDate(string);
        }
        if ((string = c.b(map, "Last-Modified")) != null) {
            l4 = CacheHelper.parseGMTDate(string);
        }
        String string3 = c.b(map, "ETag");
        if (bl) {
            l6 = l2 + l7 * 1000L;
        } else if (l3 > 0L && l5 >= l3) {
            l6 = l2 + (l5 - l3);
        }
        object = new Cache.Entry();
        object.etag = string3;
        object.ttl = l6;
        object.serverDate = l3;
        object.lastModified = l4;
        object.responseHeaders = map;
        return object;
    }

    static {
        STANDARD_FORMAT.setTimeZone(GMT);
    }
}

