/*
 * Decompiled with CFR 0.152.
 */
package anetwork.channel.aidl;

import android.os.Parcel;
import android.os.Parcelable;
import anet.channel.request.BodyEntry;
import anet.channel.util.ALog;
import anetwork.channel.Header;
import anetwork.channel.Param;
import anetwork.channel.Request;
import anetwork.channel.entity.BasicHeader;
import anetwork.channel.entity.StringParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ParcelableRequest
implements Parcelable {
    private static final String TAG = "ANet.ParcelableRequest";
    public long reqStartTime;
    private Request request;
    private BodyEntry bodyEntry;
    private int retryTime;
    private String url;
    private String charset;
    private boolean isRedirect;
    private List<Header> headers = new ArrayList<Header>();
    private String method;
    private List<Param> params = new ArrayList<Param>();
    private int connectTimeout;
    private int readTimeout;
    private int bizId;
    private String seqNo;
    private Map<String, String> extProperties;
    public static final Parcelable.Creator<ParcelableRequest> CREATOR = new Parcelable.Creator<ParcelableRequest>(){

        public ParcelableRequest createFromParcel(Parcel parcel) {
            return ParcelableRequest.readFromParcel(parcel);
        }

        public ParcelableRequest[] newArray(int n2) {
            return new ParcelableRequest[n2];
        }
    };

    public ParcelableRequest(Request request) {
        this.request = request;
        if (request != null) {
            if (request.getURI() != null) {
                this.url = request.getURI().toString();
            } else if (request.getURL() != null) {
                this.url = request.getURL().toString();
            }
            this.retryTime = request.getRetryTime();
            this.charset = request.getCharset();
            this.isRedirect = request.getFollowRedirects();
            this.headers = request.getHeaders();
            this.method = request.getMethod();
            this.params = request.getParams();
            this.bodyEntry = request.getBodyEntry();
            this.connectTimeout = request.getConnectTimeout();
            this.readTimeout = request.getReadTimeout();
            this.bizId = request.getBizId();
            this.seqNo = request.getSeqNo();
            this.extProperties = request.getExtProperties();
        }
        this.reqStartTime = System.currentTimeMillis();
    }

    public ParcelableRequest() {
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        if (this.request == null) {
            return;
        }
        try {
            parcel.writeInt(this.request.getRetryTime());
            parcel.writeString(this.url.toString());
            parcel.writeString(this.request.getCharset());
            boolean[] blArray = new boolean[]{this.request.getFollowRedirects()};
            parcel.writeBooleanArray(blArray);
            parcel.writeString(this.request.getMethod());
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.request.getHeaders() != null) {
                for (int i2 = 0; i2 < this.request.getHeaders().size(); ++i2) {
                    if (this.request.getHeaders().get(i2) == null) continue;
                    arrayList.add(this.request.getHeaders().get(i2).getName() + "&" + this.request.getHeaders().get(i2).getValue());
                }
            }
            parcel.writeList(arrayList);
            List<Param> list = this.request.getParams();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            if (list != null) {
                for (int i3 = 0; i3 < list.size(); ++i3) {
                    Param param = list.get(i3);
                    if (param == null) continue;
                    arrayList2.add(param.getKey() + "&" + param.getValue());
                }
            }
            parcel.writeList(arrayList2);
            parcel.writeParcelable((Parcelable)this.bodyEntry, 0);
            parcel.writeLong(this.reqStartTime);
            parcel.writeInt(this.request.getConnectTimeout());
            parcel.writeInt(this.request.getReadTimeout());
            parcel.writeInt(this.request.getBizId());
            parcel.writeString(this.request.getSeqNo());
            Map<String, String> map = this.request.getExtProperties();
            parcel.writeInt(map == null ? 0 : 1);
            if (map != null) {
                parcel.writeMap(map);
            }
        }
        catch (Throwable throwable) {
            ALog.w(TAG, "[writeToParcel]", null, throwable, new Object[0]);
        }
    }

    public static ParcelableRequest readFromParcel(Parcel parcel) {
        ParcelableRequest parcelableRequest = new ParcelableRequest();
        try {
            ArrayList arrayList;
            parcelableRequest.retryTime = parcel.readInt();
            parcelableRequest.url = parcel.readString();
            parcelableRequest.charset = parcel.readString();
            boolean[] blArray = new boolean[1];
            parcel.readBooleanArray(blArray);
            parcelableRequest.isRedirect = blArray[0];
            parcelableRequest.method = parcel.readString();
            ArrayList arrayList2 = new ArrayList();
            parcel.readList(arrayList2, ParcelableRequest.class.getClassLoader());
            if (arrayList2 != null) {
                for (int i2 = 0; i2 < arrayList2.size(); ++i2) {
                    int n2;
                    String string = (String)arrayList2.get(i2);
                    if (string == null || (n2 = string.indexOf("&")) == -1 || n2 == string.length() - 1) continue;
                    BasicHeader basicHeader = new BasicHeader(string.substring(0, n2), string.substring(n2 + 1));
                    parcelableRequest.headers.add(basicHeader);
                }
            }
            if ((arrayList = parcel.readArrayList(ParcelableRequest.class.getClassLoader())) != null) {
                for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                    int n3;
                    String string = (String)arrayList.get(i3);
                    if (string == null || (n3 = string.indexOf("&")) == -1 || n3 == string.length() - 1) continue;
                    parcelableRequest.params.add(new StringParam(string.substring(0, n3), string.substring(n3 + 1)));
                }
            }
            parcelableRequest.bodyEntry = (BodyEntry)parcel.readParcelable(ParcelableRequest.class.getClassLoader());
            parcelableRequest.reqStartTime = parcel.readLong();
            parcelableRequest.connectTimeout = parcel.readInt();
            parcelableRequest.readTimeout = parcel.readInt();
            parcelableRequest.bizId = parcel.readInt();
            parcelableRequest.seqNo = parcel.readString();
            if (parcel.readInt() != 0) {
                parcelableRequest.extProperties = parcel.readHashMap(ParcelableRequest.class.getClassLoader());
            }
        }
        catch (Throwable throwable) {
            ALog.w(TAG, "[readFromParcel]", null, throwable, new Object[0]);
        }
        return parcelableRequest;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getMethod() {
        return this.method;
    }

    public String getURL() {
        return this.url;
    }

    public boolean getFollowRedirects() {
        return this.isRedirect;
    }

    public BodyEntry getBodyEntry() {
        return this.bodyEntry;
    }

    public int getRetryTime() {
        return this.retryTime;
    }

    public List<Param> getParams() {
        return this.params;
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getBizId() {
        return this.bizId;
    }

    public String getSeqNo() {
        return this.seqNo;
    }

    public String getExtProperty(String string) {
        if (this.extProperties == null) {
            return null;
        }
        return this.extProperties.get(string);
    }
}

