/*
 * Decompiled with CFR 0.152.
 */
package anetwork.channel;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Log;
import anet.channel.GlobalAppRuntimeInfo;
import anet.channel.entity.ConnType;
import anet.channel.request.ByteArrayEntry;
import anet.channel.request.Request;
import anet.channel.session.b;
import anet.channel.session.c;
import anet.channel.strategy.IConnStrategy;
import anet.channel.strategy.StrategyCenter;
import anet.channel.util.Utils;
import anet.channel.util.c;
import anetwork.channel.Response;
import anetwork.channel.entity.RequestImpl;
import anetwork.channel.http.HttpNetwork;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.android.spdy.RequestPriority;
import org.android.spdy.SessionCb;
import org.android.spdy.SessionInfo;
import org.android.spdy.SpdyAgent;
import org.android.spdy.SpdyRequest;
import org.android.spdy.SpdySession;
import org.android.spdy.SpdySessionKind;
import org.android.spdy.SpdyVersion;
import org.android.spdy.SuperviseConnectInfo;
import org.android.spdy.SuperviseData;
import org.apache.http.conn.ConnectTimeoutException;
import org.json.JSONObject;

public class NetworkInfo {
    private static final String TAG = NetworkInfo.class.getSimpleName();
    public static final String RESULT_UNCONNECTED = "NETWORK_UNCONNECTED";
    public static final String RESULT_UNAUTHORIZED = "NETWORK_UNAUTHROIZED";
    public static final String RESULT_BACKGROUND = "BACKGROUND ACTIVITY";
    private static final String URL_DETECT = "http://140.205.130.1/api/cdnDetect?method=createDetect";
    private static final String URL_MTOP_WJAS = "http://api.m.taobao.com/gw/mtop.common.getTimeStamp/*";
    private static final String URL_ASERVER_CENTER = "http://acs.m.taobao.com/gw/mtop.wdetail.getitemdetail/";
    private static final String URL_ASERVER_UNIT = "http://unitacs.m.taobao.com/gw/mtop.wdetail.getitemdetail/";
    private static final String URL_ASERVER_UNSZ = "http://unszacs.m.taobao.com/gw/mtop.wdetail.getitemdetail/";
    private static final String URL_NETWORK_HEALTH = "http://api.m.taobao.com/status.taobao";
    private static final String URL_HWS = "http://hws.m.taobao.com/cache/desc/5.0?id=42860783596&type=1&f=TB1FFmAJFXXXXbvXFXX8qtpFXlX";
    private static final String URL_H5 = "http://h5.m.taobao.com/app/category/www/man/index.html";
    private static final String URL_ASSET_CDN = "http://g.alicdn.com/tbc/??search-suggest/1.4.6/mods/storage-min.js";
    private static final String URL_GW_CDN = "http://gw.alicdn.com/bao/uploaded/i2/12071029418847231/T13I2HFk8aXXXXXXXX_!!0-item_pic.jpg_170x170.jpg";
    private static final String URL_TAOBAO = "http://m.taobao.com";
    private static final String URL_BAIDU = "http://www.baidu.com";
    private static final String URL_TENCENT = "http://www.tencent.com";
    private static final String URL_204 = "http://client.aliyun.com/";
    private static final String DESC_SEPARATOR = "==============================\n";
    private static final int THREAD_NUMS = 4;
    private static final int NET_UNCONNECTED = 0;
    private static final int NET_UNAUTHORIZED = 1;
    private static final int NET_CONNECTED = 2;
    private static NetworkInfo mInstance = new NetworkInfo();
    private ExecutorService mService = new ThreadPoolExecutor(4, 4, 60L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(60));
    private Context context;
    private ConcurrentHashMap<Integer, String> resultMap;
    private NetworkInfoListener listener;

    private NetworkInfo() {
    }

    public static void getNetworkInfo(Context context, NetworkInfoListener networkInfoListener) {
        try {
            final NetworkInfo networkInfo = NetworkInfo.getInstance();
            networkInfo.context = context;
            networkInfo.listener = networkInfoListener;
            new Thread(){

                @Override
                public void run() {
                    boolean bl;
                    int n2 = networkInfo.checkNetworkState(networkInfo.context);
                    boolean bl2 = bl = !GlobalAppRuntimeInfo.isAppBackground();
                    if (!bl) {
                        NetworkInfo.onFinished(networkInfo.listener, NetworkInfo.RESULT_BACKGROUND);
                    } else if (n2 == 2) {
                        networkInfo.resultMap = new ConcurrentHashMap();
                        CountDownLatch countDownLatch = new CountDownLatch(21);
                        networkInfo.submitAllTasks(countDownLatch);
                        WaitThread waitThread = new WaitThread(networkInfo.listener, countDownLatch);
                        waitThread.start();
                    } else if (n2 == 1) {
                        NetworkInfo.onFinished(networkInfo.listener, NetworkInfo.RESULT_UNAUTHORIZED);
                    } else if (n2 == 0) {
                        NetworkInfo.onFinished(networkInfo.listener, NetworkInfo.RESULT_UNCONNECTED);
                    }
                }
            }.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void onFinished(final NetworkInfoListener networkInfoListener, final String string) {
        new Thread(){

            @Override
            public void run() {
                networkInfoListener.onFinished(string);
            }
        }.start();
    }

    public static String getNetworkInfo(Context context) {
        try {
            boolean bl;
            NetworkInfo networkInfo = NetworkInfo.getInstance();
            networkInfo.context = context;
            int n2 = networkInfo.checkNetworkState(context);
            boolean bl2 = bl = !GlobalAppRuntimeInfo.isAppBackground();
            if (!bl) {
                return RESULT_BACKGROUND;
            }
            if (n2 == 2) {
                networkInfo.resultMap = new ConcurrentHashMap();
                CountDownLatch countDownLatch = new CountDownLatch(21);
                networkInfo.submitAllTasks(countDownLatch);
                return networkInfo.waitResult(countDownLatch);
            }
            if (n2 == 1) {
                return RESULT_UNAUTHORIZED;
            }
            if (n2 == 0) {
                return RESULT_UNCONNECTED;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return "Exception";
    }

    private void submitAllTasks(CountDownLatch countDownLatch) {
        for (int i2 = 0; i2 < 21; ++i2) {
            NetworkTask networkTask = new NetworkTask(this.context, i2, this.resultMap, countDownLatch);
            this.mService.submit(networkTask);
        }
    }

    private String waitResult(CountDownLatch countDownLatch) {
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < 21; ++i2) {
            stringBuilder.append(this.getDescByIndex(i2)).append(" ").append(this.resultMap.get(i2)).append("\n");
        }
        return stringBuilder.toString();
    }

    private String getDescByIndex(int n2) {
        switch (n2) {
            case 0: {
                return "Network Type:";
            }
            case 1: {
                return "Mobile IP:";
            }
            case 2: {
                return "APN:";
            }
            case 3: {
                return "Proxy Host:";
            }
            case 4: {
                return "Proxy Port:";
            }
            case 5: {
                return "Proxy Bypass:";
            }
            case 6: {
                return "==============================\nHttpNetwork:\napi.m.taobao.com:";
            }
            case 7: {
                return "gw.alicdn.com:";
            }
            case 8: {
                return "g.alicdn.com:";
            }
            case 9: {
                return "www.taobao.com:";
            }
            case 11: {
                return "www.baidu.com:";
            }
            case 10: {
                return "www.tencent.com:";
            }
            case 12: {
                return "POST:";
            }
            case 13: {
                return "==============================\nAMDC:\nhttp://api.m.taobao.com/gw/mtop.common.getTimeStamp/*\n";
            }
            case 14: {
                return "http://gw.alicdn.com/bao/uploaded/i2/12071029418847231/T13I2HFk8aXXXXXXXX_!!0-item_pic.jpg_170x170.jpg\n";
            }
            case 15: {
                return "http://g.alicdn.com/tbc/??search-suggest/1.4.6/mods/storage-min.js\n";
            }
            case 18: {
                return "http://acs.m.taobao.com/gw/mtop.wdetail.getitemdetail/\n";
            }
            case 19: {
                return "http://unitacs.m.taobao.com/gw/mtop.wdetail.getitemdetail/\n";
            }
            case 20: {
                return "http://unszacs.m.taobao.com/gw/mtop.wdetail.getitemdetail/\n";
            }
            case 17: {
                return "http://h5.m.taobao.com/app/category/www/man/index.html\n";
            }
            case 16: {
                return "http://hws.m.taobao.com/cache/desc/5.0?id=42860783596&type=1&f=TB1FFmAJFXXXXbvXFXX8qtpFXlX\n";
            }
        }
        return "";
    }

    private static NetworkInfo getInstance() {
        return mInstance;
    }

    private int isNetworkConnected(Context context) {
        android.net.NetworkInfo[] networkInfoArray;
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        for (android.net.NetworkInfo networkInfo : networkInfoArray = connectivityManager.getAllNetworkInfo()) {
            if (networkInfo.getState() != NetworkInfo.State.CONNECTED) continue;
            try {
                HttpURLConnection httpURLConnection = this.getURLConnection(URL_204);
                String string = this.readContent(httpURLConnection);
                if (!"".equals(string) || httpURLConnection.getResponseCode() != 204) {
                    return 1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 2;
        }
        return 0;
    }

    private String getConnectionType(Context context) {
        if (this.isNetworkConnected(context) == 2) {
            android.net.NetworkInfo[] networkInfoArray;
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            for (android.net.NetworkInfo networkInfo : networkInfoArray = connectivityManager.getAllNetworkInfo()) {
                if (networkInfo.getState() != NetworkInfo.State.CONNECTED) continue;
                return networkInfo.getTypeName();
            }
        }
        return "";
    }

    private String getCurrentApn(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        android.net.NetworkInfo networkInfo = connectivityManager.getNetworkInfo(0);
        return networkInfo.getExtraInfo() == null ? "Null" : networkInfo.getExtraInfo();
    }

    private String getIpAndLdns(Context context) {
        String string = "";
        try {
            JSONObject jSONObject = new JSONObject(this.readContent(this.getURLConnection(URL_DETECT)));
            String string2 = jSONObject.optString("content", "");
            JSONObject jSONObject2 = new JSONObject(this.readContent(this.getURLConnection(string2))).getJSONObject("content");
            StringBuilder stringBuilder = new StringBuilder(32);
            stringBuilder.append(jSONObject2.optString("localIp")).append('\n').append("Local DNS: ").append(jSONObject2.optString("ldns"));
            string = stringBuilder.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private String getStringOrEmpty(String string) {
        return string == null ? "" : string;
    }

    private String readContent(HttpURLConnection httpURLConnection) {
        try {
            String string = null;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), "UTF-8"));
            StringBuilder stringBuilder = new StringBuilder();
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string).append("\n");
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    private HttpURLConnection getURLConnection(String string) {
        HttpURLConnection httpURLConnection = null;
        try {
            URL uRL = new URL(string);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setConnectTimeout(10000);
            httpURLConnection.setReadTimeout(10000);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.connect();
        }
        catch (MalformedURLException malformedURLException) {
            Log.e((String)TAG, (String)"URL Error");
        }
        catch (SocketTimeoutException socketTimeoutException) {
            Log.e((String)TAG, (String)"Socket Time Out Exception");
        }
        catch (ConnectTimeoutException connectTimeoutException) {
            Log.e((String)TAG, (String)"Connect Time Out Exception");
        }
        catch (IOException iOException) {
            Log.e((String)TAG, (String)"Open Connection Exception");
        }
        return httpURLConnection;
    }

    private int isUrlReachableByHttpNetwork(Context context, String string) {
        if (this.isNetworkConnected(context) == 2) {
            RequestImpl requestImpl = new RequestImpl(string);
            requestImpl.setRetryTime(1);
            requestImpl.setConnectTimeout(10000);
            requestImpl.setReadTimeout(10000);
            HttpNetwork httpNetwork = new HttpNetwork(context);
            Response response = httpNetwork.syncSend(requestImpl, null);
            return response.getStatusCode();
        }
        return -1;
    }

    private int checkNetworkState(final Context context) {
        Future<Integer> future = this.mService.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return NetworkInfo.this.isNetworkConnected(context);
            }
        });
        int n2 = 0;
        try {
            n2 = future.get();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        return n2;
    }

    public String checkAMDCPolices(Context context, String string) {
        Object object;
        Object object2;
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return "";
        }
        String string2 = uRL.getHost();
        List<IConnStrategy> list = StrategyCenter.getInstance().getConnStrategyListByHost(string2);
        if (list == null || list.isEmpty()) {
            return "";
        }
        Collections.shuffle(list);
        while (list.size() > 4) {
            list.remove(0);
        }
        CountDownLatch countDownLatch = new CountDownLatch(list.size());
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        for (IConnStrategy object32 : list) {
            Object object3;
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("Strategy: ").append(object32.getIp()).append(":").append(object32.getPort()).append(" - ").append(object32.getConnType());
            object = ((StringBuilder)object2).toString();
            hashMap.put((String)object, new String[]{"false", "null", "false", "null"});
            ConnType connType = object32.getConnType();
            Request request = new Request.Builder().setUrl(connType.isSSL() ? string.replace("http:", "https:") : string).build();
            request.setDnsOptimize(object32.getIp(), object32.getPort());
            if (connType.equals(ConnType.HTTP) || connType.equals(ConnType.HTTPS)) {
                try {
                    Request request2 = request;
                    object3 = anet.channel.session.c.a(request2, null);
                    int string3 = ((c.a)object3).a;
                    if (string3 > 0) {
                        ((String[])hashMap.get((Object)object))[0] = "true";
                        ((String[])hashMap.get((Object)object))[2] = "true";
                    } else {
                        ((String[])hashMap.get((Object)object))[0] = "false";
                        ((String[])hashMap.get((Object)object))[2] = "false";
                    }
                    ((String[])hashMap.get((Object)object))[1] = string3 + "";
                    ((String[])hashMap.get((Object)object))[3] = string3 + "";
                    continue;
                }
                finally {
                    countDownLatch.countDown();
                    continue;
                }
            }
            object3 = SpdyAgent.getInstance(context, SpdyVersion.SPDY3, SpdySessionKind.NONE_SESSION);
            String string3 = String.format("%s_%d", "", System.currentTimeMillis());
            SessionInfo sessionInfo = new SessionInfo(object32.getIp(), object32.getPort(), string2, "", 0, string3, new SessionCallback(hashMap, (String)object), object32.getConnType().getTnetConType());
            sessionInfo.setConnectionTimeoutMs(10000);
            sessionInfo.setPubKeySeqNum(Utils.getPublicKey(object32.getConnType(), false, -1));
            SpdySession spdySession = ((SpdyAgent)object3).createSession(sessionInfo);
            SpdyRequest spdyRequest = new SpdyRequest(request.getUrl(), "GET", RequestPriority.DEFAULT_PRIORITY, 60000, 40000);
            spdyRequest.addHeader(":host", uRL.getHost());
            spdySession.submitRequest(spdyRequest, null, spdySession, new SpdyRequestCallback(hashMap, (String)object, countDownLatch));
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        Set set = hashMap.entrySet();
        StringBuilder stringBuilder = new StringBuilder();
        object2 = set.iterator();
        while (object2.hasNext()) {
            object = (Map.Entry)object2.next();
            stringBuilder.append((String)object.getKey()).append("\n").append("\tConnection:").append(((String[])object.getValue())[0]).append(", code:").append(((String[])object.getValue())[1]).append(", Request:").append(((String[])object.getValue())[2]).append(", code: ").append(((String[])object.getValue())[3]).append("\n");
        }
        return stringBuilder.toString();
    }

    private int isConnectedViaPost(Context context) {
        RequestImpl requestImpl = new RequestImpl(URL_NETWORK_HEALTH);
        requestImpl.setMethod("POST");
        requestImpl.setRetryTime(1);
        StringBuilder stringBuilder = new StringBuilder();
        while (stringBuilder.length() < 2000) {
            stringBuilder.append("data");
        }
        requestImpl.setBodyEntry(new ByteArrayEntry(stringBuilder.toString().getBytes()));
        HttpNetwork httpNetwork = new HttpNetwork(context);
        Response response = httpNetwork.syncSend(requestImpl, null);
        return response.getStatusCode();
    }

    static class WaitThread
    extends Thread {
        private NetworkInfoListener listener;
        private CountDownLatch latch;

        public WaitThread(NetworkInfoListener networkInfoListener, CountDownLatch countDownLatch) {
            this.listener = networkInfoListener;
            this.latch = countDownLatch;
        }

        @Override
        public void run() {
            try {
                String string = NetworkInfo.getInstance().waitResult(this.latch);
                this.listener.onFinished(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private class NetworkTask
    implements Callable<String> {
        public static final int TYPE_NETWORK_TYPE = 0;
        public static final int TYPE_IP_LDNS = 1;
        public static final int TYPE_APN = 2;
        public static final int TYPE_PROXY_HOST = 3;
        public static final int TYPE_PROXY_PORT = 4;
        public static final int TYPE_PROXY_BYPASS = 5;
        public static final int TYPE_HTTP_MTOP = 6;
        public static final int TYPE_HTTP_GW_CDN = 7;
        public static final int TYPE_HTTP_ASSET_CDN = 8;
        public static final int TYPE_HTTP_TAOBAO = 9;
        public static final int TYPE_HTTP_TENCENT = 10;
        public static final int TYPE_HTTP_BAIDU = 11;
        public static final int TYPE_HTTP_POST = 12;
        public static final int TYPE_CHECK_WJAS = 13;
        public static final int TYPE_CHECK_IMG_CDN = 14;
        public static final int TYPE_CHECK_ASSET_CDN = 15;
        public static final int TYPE_CHECK_HWS = 16;
        public static final int TYPE_CHECK_H5 = 17;
        public static final int TYPE_CHECK_ASERVER_CENTER = 18;
        public static final int TYPE_CHECK_ASERVER_UNIT = 19;
        public static final int TYPE_CHECK_ASERVER_UNSZ = 20;
        public static final int TOTAL_COUNT = 21;
        private Context context;
        private int type;
        private ConcurrentHashMap<Integer, String> map;
        private CountDownLatch latch;

        public NetworkTask(Context context, int n2, ConcurrentHashMap<Integer, String> concurrentHashMap, CountDownLatch countDownLatch) {
            this.context = context;
            this.type = n2;
            this.map = concurrentHashMap;
            this.latch = countDownLatch;
        }

        @Override
        public String call() throws Exception {
            return this.execute();
        }

        private String execute() {
            String string = null;
            NetworkInfo networkInfo = NetworkInfo.getInstance();
            switch (this.type) {
                case 0: {
                    string = networkInfo.getConnectionType(this.context);
                    break;
                }
                case 1: {
                    string = networkInfo.getIpAndLdns(this.context);
                    break;
                }
                case 2: {
                    string = networkInfo.getCurrentApn(this.context);
                    break;
                }
                case 3: {
                    string = NetworkInfo.this.getStringOrEmpty(System.getProperty("http.proxyHost"));
                    break;
                }
                case 4: {
                    string = NetworkInfo.this.getStringOrEmpty(System.getProperty("http.proxyPort"));
                    break;
                }
                case 5: {
                    string = NetworkInfo.this.getStringOrEmpty(System.getProperty("http.nonProxyHosts"));
                    break;
                }
                case 6: {
                    string = NetworkInfo.this.isUrlReachableByHttpNetwork(this.context, NetworkInfo.URL_MTOP_WJAS) + "";
                    break;
                }
                case 7: {
                    string = NetworkInfo.this.isUrlReachableByHttpNetwork(this.context, NetworkInfo.URL_GW_CDN) + "";
                    break;
                }
                case 8: {
                    string = NetworkInfo.this.isUrlReachableByHttpNetwork(this.context, NetworkInfo.URL_ASSET_CDN) + "";
                    break;
                }
                case 9: {
                    string = NetworkInfo.this.isUrlReachableByHttpNetwork(this.context, NetworkInfo.URL_TAOBAO) + "";
                    break;
                }
                case 10: {
                    string = NetworkInfo.this.isUrlReachableByHttpNetwork(this.context, NetworkInfo.URL_TENCENT) + "";
                    break;
                }
                case 11: {
                    string = NetworkInfo.this.isUrlReachableByHttpNetwork(this.context, NetworkInfo.URL_BAIDU) + "";
                    break;
                }
                case 12: {
                    string = networkInfo.isConnectedViaPost(this.context) + "";
                    break;
                }
                case 13: {
                    string = networkInfo.checkAMDCPolices(this.context, NetworkInfo.URL_MTOP_WJAS);
                    break;
                }
                case 14: {
                    string = networkInfo.checkAMDCPolices(this.context, NetworkInfo.URL_GW_CDN);
                    break;
                }
                case 15: {
                    string = networkInfo.checkAMDCPolices(this.context, NetworkInfo.URL_ASSET_CDN);
                    break;
                }
                case 17: {
                    string = networkInfo.checkAMDCPolices(this.context, NetworkInfo.URL_H5);
                    break;
                }
                case 16: {
                    string = networkInfo.checkAMDCPolices(this.context, NetworkInfo.URL_HWS);
                    break;
                }
                case 18: {
                    string = networkInfo.checkAMDCPolices(this.context, NetworkInfo.URL_ASERVER_CENTER);
                    break;
                }
                case 19: {
                    string = networkInfo.checkAMDCPolices(this.context, NetworkInfo.URL_ASERVER_UNIT);
                    break;
                }
                case 20: {
                    string = networkInfo.checkAMDCPolices(this.context, NetworkInfo.URL_ASERVER_UNSZ);
                }
            }
            this.map.put(this.type, string);
            this.latch.countDown();
            return string;
        }
    }

    private class SpdyRequestCallback
    extends b {
        private CountDownLatch latch;
        private String key;
        private HashMap<String, String[]> map;

        public SpdyRequestCallback(HashMap<String, String[]> hashMap, String string, CountDownLatch countDownLatch) {
            this.key = string;
            this.latch = countDownLatch;
            this.map = hashMap;
        }

        @Override
        public void spdyStreamCloseCallback(SpdySession spdySession, long l2, int n2, Object object, SuperviseData superviseData) {
            this.latch.countDown();
        }

        @Override
        public void spdyOnStreamResponse(SpdySession spdySession, long l2, Map<String, List<String>> map, Object object) {
            this.map.get((Object)this.key)[2] = "true";
            this.map.get((Object)this.key)[3] = c.b(map, ":status") + "";
            spdySession.closeSession();
        }
    }

    private class SessionCallback
    implements SessionCb {
        private String key;
        private HashMap<String, String[]> map;

        private SessionCallback(HashMap<String, String[]> hashMap, String string) {
            this.key = string;
            this.map = hashMap;
        }

        @Override
        public void spdySessionConnectCB(SpdySession spdySession, SuperviseConnectInfo superviseConnectInfo) {
            this.map.get((Object)this.key)[0] = "true";
            this.map.get((Object)this.key)[1] = "0";
        }

        @Override
        public void spdyPingRecvCallback(SpdySession spdySession, long l2, Object object) {
        }

        @Override
        public void spdyCustomControlFrameRecvCallback(SpdySession spdySession, Object object, int n2, int n3, int n4, int n5, byte[] byArray) {
        }

        @Override
        public void spdyCustomControlFrameFailCallback(SpdySession spdySession, Object object, int n2, int n3) {
        }

        @Override
        public void spdySessionFailedError(SpdySession spdySession, int n2, Object object) {
            this.map.get((Object)this.key)[1] = n2 + "";
        }

        @Override
        public void spdySessionCloseCallback(SpdySession spdySession, Object object, SuperviseConnectInfo superviseConnectInfo, int n2) {
            Log.i((String)TAG, (String)("spdy session close: " + spdySession.getDomain()));
        }

        @Override
        public void bioPingRecvCallback(SpdySession spdySession, int n2) {
        }

        @Override
        public byte[] getSSLMeta(SpdySession spdySession) {
            return new byte[0];
        }

        @Override
        public int putSSLMeta(SpdySession spdySession, byte[] byArray) {
            return 0;
        }
    }

    public static interface NetworkInfoListener {
        public void onFinished(String var1);
    }
}

