/*
 * Decompiled with CFR 0.152.
 */
package anet.channel.strategy.dispatch;

import android.text.TextUtils;
import anet.channel.GlobalAppRuntimeInfo;
import anet.channel.strategy.a;
import anet.channel.strategy.dispatch.DispatchEvent;
import anet.channel.strategy.dispatch.b;
import anet.channel.strategy.dispatch.c;
import anet.channel.util.ALog;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;

public class HttpDispatcher {
    private CopyOnWriteArraySet<IDispatchEventListener> listeners = new CopyOnWriteArraySet();
    private b executor = new b();
    private volatile boolean isEnable = true;
    private Set<String> uniqueIdSet = Collections.newSetFromMap(new ConcurrentHashMap());
    private Set<String> initHosts = new TreeSet<String>();
    private AtomicBoolean isInitHostsFilled = new AtomicBoolean();

    public static HttpDispatcher getInstance() {
        return Singleton.instance;
    }

    private HttpDispatcher() {
        this.fillInitHosts();
    }

    public void sendAmdcRequest(Set<String> set, String string, int n2) {
        if (!this.isEnable || set == null || set.isEmpty()) {
            return;
        }
        if (ALog.isPrintLog(2)) {
            ALog.i("awcn.HttpDispatcher", "sendAmdcRequest", null, "hosts", set.toString());
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("hosts", set);
        hashMap.put("preIp", string);
        hashMap.put("cv", String.valueOf(n2));
        this.executor.a(hashMap);
    }

    public void addListener(IDispatchEventListener iDispatchEventListener) {
        this.listeners.add(iDispatchEventListener);
    }

    public void removeListener(IDispatchEventListener iDispatchEventListener) {
        this.listeners.remove(iDispatchEventListener);
    }

    void fireEvent(DispatchEvent dispatchEvent) {
        for (IDispatchEventListener iDispatchEventListener : this.listeners) {
            iDispatchEventListener.onEvent(dispatchEvent);
        }
    }

    public void setEnable(boolean bl) {
        this.isEnable = bl;
    }

    public synchronized void addHosts(List<String> list) {
        if (list != null) {
            this.initHosts.addAll(list);
            this.uniqueIdSet.clear();
        }
    }

    public static void setInitHosts(List<String> list) {
        if (list != null) {
            c.a = list.toArray(new String[0]);
        }
    }

    public synchronized Set<String> getInitHosts() {
        this.fillInitHosts();
        return new HashSet<String>(this.initHosts);
    }

    private void fillInitHosts() {
        if (!this.isInitHostsFilled.get() && GlobalAppRuntimeInfo.getContext() != null && this.isInitHostsFilled.compareAndSet(false, true)) {
            this.initHosts.add(c.a());
            if (GlobalAppRuntimeInfo.isTargetProcess()) {
                this.initHosts.addAll(Arrays.asList(c.a));
                this.initHosts.addAll(a.a());
            }
        }
    }

    public boolean isInitHostsChanged(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        boolean bl = this.uniqueIdSet.contains(string);
        if (!bl) {
            this.uniqueIdSet.add(string);
        }
        return !bl;
    }

    public void switchENV() {
        this.uniqueIdSet.clear();
        this.initHosts.clear();
        this.isInitHostsFilled.set(false);
    }

    private static class Singleton {
        static HttpDispatcher instance = new HttpDispatcher();

        private Singleton() {
        }
    }

    public static interface IDispatchEventListener {
        public void onEvent(DispatchEvent var1);
    }
}

