/*
 * Decompiled with CFR 0.152.
 */
package anet.channel.strategy;

import anet.channel.entity.ConnType;
import anet.channel.entity.EventType;
import anet.channel.entity.d;
import anet.channel.strategy.IConnStrategy;
import anet.channel.strategy.IPConnStrategy;
import anet.channel.strategy.RawConnStrategy;
import anet.channel.strategy.b;
import anet.channel.strategy.c;
import anet.channel.strategy.l;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public abstract class ConnStrategyList {
    public abstract List<IConnStrategy> getStrategyList();

    public abstract void update(l.b var1);

    public abstract void resetStatus();

    public abstract boolean isUnavailable();

    public abstract void notifyConnEvent(IConnStrategy var1, EventType var2, d var3);

    public static ConnStrategyList createForIDC() {
        return new IDCStrategyList();
    }

    public static ConnStrategyList createForIDC(String[] stringArray, RawConnStrategy ... rawConnStrategyArray) {
        if (stringArray == null) {
            return null;
        }
        return new IDCStrategyList(stringArray, rawConnStrategyArray);
    }

    public static ConnStrategyList createForCDN() {
        return new CDNStrategyList();
    }

    static <T> int a(Collection<T> collection, Predicate<T> predicate) {
        if (collection == null) {
            return -1;
        }
        int n2 = 0;
        for (T t : collection) {
            if (predicate.apply(t)) break;
            ++n2;
        }
        return n2 == collection.size() ? -1 : n2;
    }

    private static interface Predicate<T> {
        public boolean apply(T var1);
    }

    private static class IDCStrategyList
    extends ConnStrategyList
    implements Serializable {
        public final List<String> ips = new ArrayList<String>();
        public final List<RawConnStrategy> strategies = new ArrayList<RawConnStrategy>();
        public volatile transient List<IConnStrategy> cache = null;

        public IDCStrategyList() {
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.ips).append(' ').append(this.strategies);
            return stringBuilder.toString();
        }

        public IDCStrategyList(String[] stringArray, RawConnStrategy ... rawConnStrategyArray) {
            this.ips.addAll(Arrays.asList(stringArray));
            Collections.shuffle(this.ips);
            this.strategies.addAll(Arrays.asList(rawConnStrategyArray));
            this.a();
        }

        @Override
        public List<IConnStrategy> getStrategyList() {
            if (this.cache == null) {
                IDCStrategyList iDCStrategyList = this;
                synchronized (iDCStrategyList) {
                    if (this.cache == null) {
                        this.a();
                    }
                }
            }
            return new ArrayList<IConnStrategy>(this.cache);
        }

        @Override
        public void update(l.b b2) {
            this.ips.clear();
            this.ips.addAll(Arrays.asList(b2.e));
            for (RawConnStrategy rawConnStrategy : this.strategies) {
                rawConnStrategy.isToRemove = true;
            }
            int n2 = b2.f.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                RawConnStrategy rawConnStrategy;
                List<RawConnStrategy> list = this.strategies;
                l.a a2 = b2.f[i2];
                ConnType connType = ConnType.valueOf(a2);
                c c2 = new c(this, a2, connType);
                int n3 = ConnStrategyList.a(list, c2);
                if (n3 != -1) {
                    rawConnStrategy = this.strategies.get(n3);
                    rawConnStrategy.isToRemove = false;
                    rawConnStrategy.resetConnStatus();
                    continue;
                }
                rawConnStrategy = RawConnStrategy.a.a(a2);
                if (rawConnStrategy == null) continue;
                this.strategies.add(rawConnStrategy);
            }
            ListIterator<RawConnStrategy> listIterator = this.strategies.listIterator();
            while (listIterator.hasNext()) {
                if (!listIterator.next().isToRemove) continue;
                listIterator.remove();
            }
            this.a();
        }

        private void a() {
            if (this.cache == null) {
                this.cache = new ArrayList<IConnStrategy>();
            } else {
                this.cache.clear();
            }
            for (String string : this.ips) {
                for (RawConnStrategy rawConnStrategy : this.strategies) {
                    this.cache.add(IPConnStrategy.a.a(string, rawConnStrategy));
                }
            }
        }

        @Override
        public void resetStatus() {
            for (RawConnStrategy rawConnStrategy : this.strategies) {
                rawConnStrategy.resetConnStatus();
            }
        }

        @Override
        public boolean isUnavailable() {
            for (RawConnStrategy rawConnStrategy : this.strategies) {
                if (!rawConnStrategy.isAvailable()) continue;
                return false;
            }
            return true;
        }

        @Override
        public void notifyConnEvent(IConnStrategy iConnStrategy, EventType eventType, d d2) {
            if (!(iConnStrategy instanceof IPConnStrategy)) {
                return;
            }
            boolean bl = false;
            for (RawConnStrategy rawConnStrategy : this.strategies) {
                if (((IPConnStrategy)iConnStrategy).rawConnStrategy != rawConnStrategy) continue;
                bl = true;
                break;
            }
            if (bl) {
                iConnStrategy.notifyEvent(eventType, d2);
                Collections.sort(this.strategies);
            }
        }
    }

    private static class CDNStrategyList
    extends ConnStrategyList
    implements Serializable {
        private List<IPConnStrategy> a = new ArrayList<IPConnStrategy>();

        public String toString() {
            return this.a.toString();
        }

        @Override
        public List<IConnStrategy> getStrategyList() {
            return new ArrayList<IConnStrategy>(this.a);
        }

        @Override
        public void update(l.b b2) {
            for (IPConnStrategy iPConnStrategy : this.a) {
                iPConnStrategy.isToRemove = true;
            }
            for (int i2 = 0; i2 < b2.e.length; ++i2) {
                for (int i3 = 0; i3 < b2.f.length; ++i3) {
                    IPConnStrategy iPConnStrategy;
                    String string = b2.e[i2];
                    List<IPConnStrategy> list = this.a;
                    l.a a2 = b2.f[i3];
                    ConnType connType = ConnType.valueOf(a2);
                    b b3 = new b(this, a2, connType, string);
                    int n2 = ConnStrategyList.a(list, b3);
                    if (n2 != -1) {
                        iPConnStrategy = this.a.get(n2);
                        iPConnStrategy.isToRemove = false;
                        iPConnStrategy.resetConnStatus();
                        continue;
                    }
                    iPConnStrategy = IPConnStrategy.a.a(string, a2);
                    if (iPConnStrategy == null) continue;
                    this.a.add(iPConnStrategy);
                }
            }
            ListIterator<IPConnStrategy> listIterator = this.a.listIterator();
            while (listIterator.hasNext()) {
                if (!listIterator.next().isToRemove) continue;
                listIterator.remove();
            }
        }

        @Override
        public void resetStatus() {
            for (IPConnStrategy iPConnStrategy : this.a) {
                iPConnStrategy.resetConnStatus();
            }
        }

        @Override
        public boolean isUnavailable() {
            for (IPConnStrategy iPConnStrategy : this.a) {
                if (!iPConnStrategy.isAvailable()) continue;
                return false;
            }
            return true;
        }

        @Override
        public void notifyConnEvent(IConnStrategy iConnStrategy, EventType eventType, d d2) {
            if (this.a.indexOf(iConnStrategy) != -1) {
                iConnStrategy.notifyEvent(eventType, d2);
                Collections.sort(this.a);
            }
        }
    }
}

