/*
 * Decompiled with CFR 0.152.
 */
package anet.channel.statist;

import anet.channel.statist.Dimension;
import anet.channel.statist.Monitor;
import anet.channel.statist.RequestStatistic;
import anet.channel.statist.StatObject;
import anet.channel.util.ErrorConstant;

@Monitor(module="networkPrefer", monitorPoint="NetworkError")
public class ExceptionStatistic
extends StatObject {
    @Dimension
    public int resultCode;
    @Dimension
    public String exceptionType;
    @Dimension
    public String host;
    @Dimension
    public String errorMsg;
    @Dimension
    public String exceptionStack;
    @Dimension
    public String url;
    @Dimension
    public String ip;
    @Dimension
    public int port;
    @Dimension
    public boolean isSSL;
    @Dimension
    public boolean isProxy;
    @Dimension
    public String proxyType;
    @Dimension
    public String netType;
    @Dimension
    public boolean isDNS;
    @Dimension
    public String protocolType;
    @Dimension
    public String bizId;

    public ExceptionStatistic() {
    }

    public ExceptionStatistic(int n2, String string, String string2) {
        this.resultCode = n2;
        this.errorMsg = string != null ? string : ErrorConstant.getErrMsg(n2);
        this.exceptionType = string2;
    }

    public ExceptionStatistic(int n2, String string, RequestStatistic requestStatistic, Throwable throwable) {
        this.exceptionType = "nw";
        this.resultCode = n2;
        this.errorMsg = string != null ? string : ErrorConstant.getErrMsg(n2);
        String string2 = this.exceptionStack = throwable != null ? throwable.toString() : "";
        if (requestStatistic != null) {
            this.host = requestStatistic.host;
            this.ip = requestStatistic.ip;
            this.port = requestStatistic.port;
            this.isSSL = requestStatistic.isSSL;
            this.isProxy = requestStatistic.isProxy;
            this.proxyType = String.valueOf(requestStatistic.proxyType);
            this.netType = requestStatistic.netType;
            this.isDNS = requestStatistic.isDNS;
            this.protocolType = String.valueOf(requestStatistic.protocolType);
            this.bizId = requestStatistic.bizId;
        }
    }
}

