/*
 * Decompiled with CFR 0.152.
 */
package anetwork.channel.unified;

import anet.channel.appmonitor.AppMonitor;
import anet.channel.c.c;
import anet.channel.request.Request;
import anet.channel.statist.ExceptionStatistic;
import anet.channel.statist.RequestStatistic;
import anet.channel.util.ALog;
import anet.channel.util.ErrorConstant;
import anetwork.channel.aidl.DefaultFinishEvent;
import anetwork.channel.cache.Cache;
import anetwork.channel.cache.CacheManager;
import anetwork.channel.config.NetworkConfigCenter;
import anetwork.channel.entity.Repeater;
import anetwork.channel.entity.RequestConfig;
import anetwork.channel.interceptor.Callback;
import anetwork.channel.interceptor.Interceptor;
import anetwork.channel.interceptor.InterceptorManager;
import anetwork.channel.unified.CacheTask;
import anetwork.channel.unified.FutureResponse;
import anetwork.channel.unified.NetworkTask;
import anetwork.channel.unified.RequestContext;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

class UnifiedRequestTask {
    private static final String TAG = "ANet.UnifiedRequestTask";
    private RequestContext rc;

    public UnifiedRequestTask(RequestConfig requestConfig, Repeater repeater) {
        repeater.setSeqNo(requestConfig.getSeqNo());
        this.rc = new RequestContext(requestConfig, repeater);
        requestConfig.getStatistic().start = System.currentTimeMillis();
    }

    public Future request() {
        if (ALog.isPrintLog(2)) {
            ALog.i(TAG, "request", this.rc.seqNum, "Url", this.rc.config.getUrlString());
        }
        return new UnifiedRequestChain(0, this.rc.config.getAwcnRequest(), this.rc.callback).proceed(this.rc.config.getAwcnRequest(), this.rc.callback);
    }

    private void commitTimeoutTask() {
        this.rc.timeoutTask = c.a(new Runnable(){

            @Override
            public void run() {
                if (((UnifiedRequestTask)UnifiedRequestTask.this).rc.isDone.compareAndSet(false, true)) {
                    ALog.e(UnifiedRequestTask.TAG, "task time out", ((UnifiedRequestTask)UnifiedRequestTask.this).rc.seqNum, new Object[0]);
                    UnifiedRequestTask.this.rc.cancelRunningTask();
                    ((UnifiedRequestTask)UnifiedRequestTask.this).rc.statisticData.resultCode = -202;
                    ((UnifiedRequestTask)UnifiedRequestTask.this).rc.callback.onFinish(new DefaultFinishEvent(-202, null, ((UnifiedRequestTask)UnifiedRequestTask.this).rc.statisticData));
                    RequestStatistic requestStatistic = ((UnifiedRequestTask)UnifiedRequestTask.this).rc.config.getStatistic();
                    requestStatistic.statusCode = -202;
                    requestStatistic.msg = ErrorConstant.getErrMsg(-202);
                    AppMonitor.getInstance().commitStat(requestStatistic);
                    AppMonitor.getInstance().commitStat(new ExceptionStatistic(-202, null, requestStatistic, null));
                }
            }
        }, this.rc.config.getWaitTimeout(), TimeUnit.MILLISECONDS);
    }

    void cancelTask() {
        if (this.rc.isDone.compareAndSet(false, true)) {
            if (ALog.isPrintLog(2)) {
                ALog.i(TAG, "task cancelled", this.rc.seqNum, new Object[0]);
            }
            this.rc.cancelRunningTask();
            this.rc.cancelTimeoutTask();
            this.rc.statisticData.resultCode = -204;
            this.rc.callback.onFinish(new DefaultFinishEvent(-204, null, this.rc.statisticData));
            AppMonitor.getInstance().commitStat(new ExceptionStatistic(-204, null, this.rc.config.getStatistic(), null));
        }
    }

    class UnifiedRequestChain
    implements Interceptor.Chain {
        private int index = 0;
        private Request request = null;
        private Callback callback = null;

        UnifiedRequestChain(int n2, Request request, Callback callback) {
            this.index = n2;
            this.request = request;
            this.callback = callback;
        }

        @Override
        public Request request() {
            return this.request;
        }

        @Override
        public Callback callback() {
            return this.callback;
        }

        @Override
        public Future proceed(Request request, Callback callback) {
            if (this.index < InterceptorManager.getSize()) {
                UnifiedRequestChain unifiedRequestChain = new UnifiedRequestChain(this.index + 1, request, callback);
                Interceptor interceptor = InterceptorManager.getInterceptor(this.index);
                ALog.e("awcn.UnifiedRequestChain", "[proceed]", request.getSeq(), "index", this.index, "interceptor", interceptor);
                return interceptor.intercept(unifiedRequestChain);
            }
            ((UnifiedRequestTask)UnifiedRequestTask.this).rc.config.setAwcnRequest(request);
            ((UnifiedRequestTask)UnifiedRequestTask.this).rc.callback = callback;
            Cache cache = null;
            if (NetworkConfigCenter.isHttpCacheEnable() && !"no-cache".equals(request.getHeaders().get("Cache-Control"))) {
                cache = CacheManager.getCache(((UnifiedRequestTask)UnifiedRequestTask.this).rc.config.getUrlString(), ((UnifiedRequestTask)UnifiedRequestTask.this).rc.config.getHeaders());
            }
            ((UnifiedRequestTask)UnifiedRequestTask.this).rc.runningTask = cache != null ? new CacheTask(UnifiedRequestTask.this.rc, cache) : new NetworkTask(UnifiedRequestTask.this.rc, null, null);
            c.a(((UnifiedRequestTask)UnifiedRequestTask.this).rc.runningTask, 0);
            UnifiedRequestTask.this.commitTimeoutTask();
            return new FutureResponse(UnifiedRequestTask.this);
        }
    }
}

