/*
 * Decompiled with CFR 0.152.
 */
package anetwork.channel.unified;

import anet.channel.a.a;
import anet.channel.appmonitor.AppMonitor;
import anet.channel.statist.RequestStatistic;
import anet.channel.util.ALog;
import anetwork.channel.aidl.DefaultFinishEvent;
import anetwork.channel.cache.Cache;
import anetwork.channel.unified.IUnifiedTask;
import anetwork.channel.unified.NetworkTask;
import anetwork.channel.unified.RequestContext;

public class CacheTask
implements IUnifiedTask {
    private static final String TAG = "anet.CacheTask";
    private RequestContext rc = null;
    private Cache cache = null;
    private volatile boolean isCanceled = false;

    public CacheTask(RequestContext requestContext, Cache cache) {
        this.rc = requestContext;
        this.cache = cache;
    }

    @Override
    public void cancel() {
        this.isCanceled = true;
    }

    @Override
    public void run() {
        if (this.isCanceled) {
            return;
        }
        RequestStatistic requestStatistic = this.rc.config.getStatistic();
        if (this.cache != null) {
            long l2 = System.currentTimeMillis();
            Cache.Entry entry = this.cache.get(this.rc.config.getUrlString());
            long l3 = System.currentTimeMillis();
            requestStatistic.cacheTime = l3 - l2;
            if (ALog.isPrintLog(2)) {
                ALog.i(TAG, "read cache", this.rc.seqNum, "hit", entry != null, "cost", requestStatistic.cacheTime, "length", entry != null ? entry.data.length : 0, "key", this.rc.config.getUrlString());
            }
            if (entry != null && entry.isFresh()) {
                if (this.rc.isDone.compareAndSet(false, true)) {
                    this.rc.cancelTimeoutTask();
                    requestStatistic.ret = true;
                    requestStatistic.statusCode = 200;
                    requestStatistic.protocolType = "cache";
                    requestStatistic.oneWayTime = l3 - requestStatistic.start;
                    this.rc.statisticData.filledBy(requestStatistic);
                    if (ALog.isPrintLog(2)) {
                        ALog.i(TAG, "hit fresh cache", this.rc.seqNum, new Object[0]);
                        ALog.i(TAG, this.rc.statisticData.toString(), this.rc.seqNum, new Object[0]);
                    }
                    this.rc.callback.onResponseCode(200, entry.responseHeaders);
                    this.rc.callback.onDataReceiveSize(1, entry.data.length, a.a(entry.data));
                    this.rc.callback.onFinish(new DefaultFinishEvent(200, null, this.rc.statisticData));
                    AppMonitor.getInstance().commitStat(requestStatistic);
                }
                return;
            }
            if (this.isCanceled) {
                return;
            }
            NetworkTask networkTask = new NetworkTask(this.rc, this.cache, entry);
            this.rc.runningTask = networkTask;
            networkTask.run();
        }
    }
}

