/*
 * Decompiled with CFR 0.152.
 */
package anetwork.channel.statist;

import android.text.TextUtils;
import anet.channel.util.ALog;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.json.JSONObject;

public class StatisticReqTimes {
    private static final String TAG = "awcn.StatisticReqTimes";
    private static StatisticReqTimes instance;
    private boolean isStarting;
    private long startPoint;
    private Set<String> currentReqUrls;
    private Set<String> whiteReqUrls;
    private long finalResult;

    private StatisticReqTimes() {
        this.initAttrs();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StatisticReqTimes getIntance() {
        if (instance != null) return instance;
        Class<StatisticReqTimes> clazz = StatisticReqTimes.class;
        synchronized (StatisticReqTimes.class) {
            if (instance != null) return instance;
            instance = new StatisticReqTimes();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void initAttrs() {
        this.isStarting = false;
        this.startPoint = 0L;
        this.finalResult = 0L;
        if (this.currentReqUrls == null) {
            this.currentReqUrls = new HashSet<String>();
        } else {
            this.currentReqUrls.clear();
        }
        if (this.whiteReqUrls == null) {
            this.whiteReqUrls = new HashSet<String>();
        }
    }

    public void updateWhiteReqUrls(String string) {
        if (this.whiteReqUrls == null) {
            this.whiteReqUrls = new HashSet<String>();
        } else {
            this.whiteReqUrls.clear();
        }
        if (ALog.isPrintLog(2)) {
            ALog.i(TAG, "urlsFromOrange: " + string, null, new Object[0]);
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            try {
                JSONObject jSONObject = new JSONObject(string);
                Iterator iterator = jSONObject.keys();
                while (iterator.hasNext()) {
                    this.whiteReqUrls.add((String)iterator.next());
                }
            }
            catch (Exception exception) {
                ALog.e(TAG, "whiteReqUrls from orange isnot json format", null, new Object[0]);
            }
        }
    }

    public void start() {
        if (ALog.isPrintLog(2)) {
            ALog.i(TAG, "start statistic req times", null, new Object[0]);
        }
        this.initAttrs();
        this.isStarting = true;
    }

    public void putReq(URL uRL) {
        String string;
        if (this.isStarting && this.whiteReqUrls.contains(string = uRL.getPath())) {
            if (this.currentReqUrls.isEmpty()) {
                this.startPoint = System.currentTimeMillis();
            }
            this.currentReqUrls.add(string);
        }
    }

    public void updateReqTimes(URL uRL, long l2) {
        String string;
        if (this.isStarting && l2 > 0L && uRL != null && this.currentReqUrls.remove(string = uRL.getPath()) && this.currentReqUrls.isEmpty()) {
            long l3 = System.currentTimeMillis() - this.startPoint;
            ALog.i(TAG, "this req spend times: " + l3, null, new Object[0]);
            this.finalResult += l3;
        }
    }

    public long end() {
        long l2 = 0L;
        if (this.isStarting) {
            l2 = this.finalResult;
            if (ALog.isPrintLog(2)) {
                ALog.i(TAG, "finalResult:" + this.finalResult, null, new Object[0]);
            }
        }
        this.initAttrs();
        return l2;
    }
}

