/*
 * Decompiled with CFR 0.152.
 */
package anetwork.channel.statist;

import anet.channel.statist.RequestStatistic;
import anet.channel.util.StringUtils;
import java.io.Serializable;

public class StatisticData
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -3538602124202475612L;
    public String connectionType = "";
    public boolean isRequestSuccess = false;
    public int resultCode = 0;
    public String host = "";
    @Deprecated
    public String api_v = "";
    public String ip_port = "";
    @Deprecated
    public boolean isSpdy = false;
    public boolean isSSL = false;
    @Deprecated
    public int dnsTime = 0;
    @Deprecated
    public int isDNSTimeout = 0;
    @Deprecated
    public long tcpLinkDate = 0L;
    @Deprecated
    public long tcpConnTime = 0L;
    public long oneWayTime_ANet = 0L;
    public long cacheTime = 0L;
    @Deprecated
    public long oneWayTime_AEngine = 0L;
    @Deprecated
    public long oneWayTime_Jni = 0L;
    public long postBodyTime = 0L;
    @Deprecated
    public long spdyWaitTime = 0L;
    public long sendBeforeTime = 0L;
    public long firstDataTime = 0L;
    public long recDataTime = 0L;
    @Deprecated
    public long receiveDataTime = 0L;
    public long serverRT = 0L;
    public long rtt = 0L;
    @Deprecated
    public long netTime = 0L;
    public long sendSize = 0L;
    public long totalSize = 0L;
    @Deprecated
    public long responseBodySize = 0L;
    public long dataSpeed = 0L;
    @Deprecated
    public String timeoutType = "";
    public int retryTime;
    @Deprecated
    public int redirectTime;
    public String netStatSum;

    public void filledBy(RequestStatistic requestStatistic) {
        if (requestStatistic != null) {
            this.resultCode = requestStatistic.statusCode;
            this.connectionType = requestStatistic.protocolType;
            this.isRequestSuccess = requestStatistic.ret;
            this.host = requestStatistic.host;
            if (requestStatistic.ip != null && requestStatistic.port != 0) {
                this.ip_port = String.format("%s:%d", requestStatistic.ip, requestStatistic.port);
            }
            this.isSSL = requestStatistic.isSSL;
            this.oneWayTime_ANet = requestStatistic.oneWayTime;
            this.cacheTime = requestStatistic.cacheTime;
            this.firstDataTime = requestStatistic.firstDataTime;
            this.sendBeforeTime = requestStatistic.sendBeforeTime;
            this.recDataTime = requestStatistic.recDataTime;
            this.sendSize = requestStatistic.sendDataSize;
            this.totalSize = requestStatistic.recDataSize;
            this.serverRT = requestStatistic.serverRT;
            this.dataSpeed = this.recDataTime != 0L ? this.totalSize / this.recDataTime : this.totalSize;
        }
    }

    public String sumNetStat() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("isSuccess=").append(this.isRequestSuccess);
        stringBuilder.append(",host=").append(this.host);
        stringBuilder.append(",resultCode=").append(this.resultCode);
        stringBuilder.append(",connType=").append(this.connectionType);
        stringBuilder.append(",oneWayTime_ANet=").append(this.oneWayTime_ANet);
        stringBuilder.append(",ip_port=").append(this.ip_port);
        stringBuilder.append(",isSSL=").append(this.isSSL);
        stringBuilder.append(",cacheTime=").append(this.cacheTime);
        stringBuilder.append(",postBodyTime=").append(this.postBodyTime);
        stringBuilder.append(",firstDataTime=").append(this.firstDataTime);
        stringBuilder.append(",recDataTime=").append(this.recDataTime);
        stringBuilder.append(",serverRT=").append(this.serverRT);
        stringBuilder.append(",rtt=").append(this.rtt);
        stringBuilder.append(",sendSize=").append(this.sendSize);
        stringBuilder.append(",totalSize=").append(this.totalSize);
        stringBuilder.append(",dataSpeed=").append(this.dataSpeed);
        stringBuilder.append(",retryTime=").append(this.retryTime);
        return stringBuilder.toString();
    }

    public String toString() {
        if (StringUtils.isBlank(this.netStatSum)) {
            this.netStatSum = this.sumNetStat();
        }
        StringBuilder stringBuilder = new StringBuilder("StatisticData [");
        stringBuilder.append(this.netStatSum);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

