/*
 * Decompiled with CFR 0.152.
 */
package anetwork.channel.config;

import anet.channel.b.b;
import anet.channel.b.d;
import anet.channel.util.ALog;
import anetwork.channel.config.IRemoteConfig;
import anetwork.channel.config.NetworkConfigCenter;
import anetwork.channel.statist.StatisticReqTimes;
import com.taobao.orange.OrangeConfig;
import com.taobao.orange.OrangeConfigListenerV1;

class OrangeConfigImpl
implements IRemoteConfig {
    private static final String TAG = "awcn.OrangeConfigImpl";
    private static final String NETWORK_SDK_GROUP = "networkSdk";
    private static final String NETWORK_EMPTY_SCHEME_HTTPS_SWITCH = "network_empty_scheme_https_switch";
    private static final String NETWORK_SPDY_ENABLE_SWITCH = "network_spdy_enable_switch";
    private static final String NETWORK_HTTPS_VALIDATION_ENABLE_SWITCH = "network_https_validation_enable_switch";
    private static final String NETWORK_MONITOR_WHITELIST_URL = "network_monitor_whitelist_url";
    private static final String NETWORK_HTTP_CACHE_SWITCH = "network_http_cache_switch";
    private static boolean mOrangeValid = false;

    OrangeConfigImpl() {
    }

    @Override
    public void register() {
        if (!mOrangeValid) {
            ALog.w(TAG, "no orange sdk", null, new Object[0]);
            return;
        }
        try {
            OrangeConfig.getInstance().registerListener(new String[]{NETWORK_SDK_GROUP}, new OrangeConfigListenerV1(){

                public void onConfigUpdate(String string, boolean bl) {
                    OrangeConfigImpl.this.onConfigUpdate(string);
                }
            });
            this.getConfig(NETWORK_SDK_GROUP, NETWORK_EMPTY_SCHEME_HTTPS_SWITCH, "true");
            StatisticReqTimes.getIntance().updateWhiteReqUrls(this.getConfig(NETWORK_SDK_GROUP, NETWORK_MONITOR_WHITELIST_URL, null));
        }
        catch (Exception exception) {
            ALog.e(TAG, "register fail", null, exception, new Object[0]);
        }
    }

    @Override
    public void unRegister() {
        if (!mOrangeValid) {
            ALog.w(TAG, "no orange sdk", null, new Object[0]);
            return;
        }
        OrangeConfig.getInstance().unregisterListener(new String[]{NETWORK_SDK_GROUP});
    }

    @Override
    public String getConfig(String ... stringArray) {
        if (!mOrangeValid) {
            ALog.w(TAG, "no orange sdk", null, new Object[0]);
            return null;
        }
        try {
            return OrangeConfig.getInstance().getConfig(stringArray[0], stringArray[1], stringArray[2]);
        }
        catch (Exception exception) {
            ALog.e(TAG, "get config failed!", null, exception, new Object[0]);
            return null;
        }
    }

    @Override
    public void onConfigUpdate(String string) {
        if (NETWORK_SDK_GROUP.equals(string)) {
            ALog.i(TAG, "onConfigUpdate", null, "namespace", string);
            try {
                boolean bl = Boolean.valueOf(this.getConfig(string, NETWORK_EMPTY_SCHEME_HTTPS_SWITCH, "true"));
                if (bl) {
                    b.a().a(d.class);
                } else {
                    b.a().b(d.class);
                }
                boolean bl2 = Boolean.valueOf(this.getConfig(string, NETWORK_SPDY_ENABLE_SWITCH, "true"));
                NetworkConfigCenter.setSpdyEnabled(bl2);
                boolean bl3 = Boolean.valueOf(this.getConfig(string, NETWORK_HTTPS_VALIDATION_ENABLE_SWITCH, "true"));
                NetworkConfigCenter.setHttpsValidationEnabled(bl3);
                boolean bl4 = Boolean.valueOf(this.getConfig(string, NETWORK_HTTP_CACHE_SWITCH, "true"));
                NetworkConfigCenter.setHttpCacheEnable(bl4);
                StatisticReqTimes.getIntance().updateWhiteReqUrls(this.getConfig(NETWORK_SDK_GROUP, NETWORK_MONITOR_WHITELIST_URL, null));
            }
            catch (Exception exception) {}
        }
    }

    static {
        try {
            Class.forName("com.taobao.orange.OrangeConfig");
            mOrangeValid = true;
        }
        catch (Exception exception) {
            mOrangeValid = false;
        }
    }
}

