/*
 * Decompiled with CFR 0.152.
 */
package anetwork.channel.cache;

import anet.channel.util.ALog;
import anet.channel.util.StringUtils;
import anetwork.channel.cache.Cache;
import com.taobao.alivfssdk.cache.AVFSCache;
import com.taobao.alivfssdk.cache.AVFSCacheConfig;
import com.taobao.alivfssdk.cache.AVFSCacheManager;
import com.taobao.alivfssdk.cache.IAVFSCache;

class AVFSCacheImpl
implements Cache {
    private static final String TAG = "anet.AVFSCacheImpl";
    private static final String MODULE_NAME = "networksdk.httpcache";
    private static boolean isAvfsCacheExist = true;
    private static Object nullCallback = null;

    AVFSCacheImpl() {
    }

    public void initialize() {
        if (!isAvfsCacheExist) {
            return;
        }
        AVFSCache aVFSCache = AVFSCacheManager.getInstance().cacheForModule(MODULE_NAME);
        if (aVFSCache != null) {
            AVFSCacheConfig aVFSCacheConfig = new AVFSCacheConfig();
            aVFSCacheConfig.limitSize = 0x500000L;
            aVFSCacheConfig.fileMemMaxSize = 0x100000L;
            aVFSCache.moduleConfig(aVFSCacheConfig);
        }
    }

    @Override
    public Cache.Entry get(String string) {
        if (!isAvfsCacheExist) {
            return null;
        }
        try {
            IAVFSCache iAVFSCache = this.getFileCache();
            if (iAVFSCache != null) {
                string = StringUtils.md5ToHex(string);
                return (Cache.Entry)iAVFSCache.objectForKey(string);
            }
        }
        catch (Exception exception) {
            ALog.e(TAG, "get cache failed", null, exception, new Object[0]);
        }
        return null;
    }

    @Override
    public void put(String string, Cache.Entry entry) {
        if (!isAvfsCacheExist) {
            return;
        }
        try {
            IAVFSCache iAVFSCache = this.getFileCache();
            if (iAVFSCache != null) {
                string = StringUtils.md5ToHex(string);
                iAVFSCache.setObjectForKey(string, (Object)entry, (IAVFSCache.OnObjectSetCallback)nullCallback);
            }
        }
        catch (Exception exception) {
            ALog.e(TAG, "put cache failed", null, exception, new Object[0]);
        }
    }

    private IAVFSCache getFileCache() {
        AVFSCache aVFSCache = AVFSCacheManager.getInstance().cacheForModule(MODULE_NAME);
        if (aVFSCache != null) {
            return aVFSCache.getFileCache();
        }
        return null;
    }

    static {
        try {
            Class.forName("com.taobao.alivfssdk.cache.AVFSCacheManager");
            nullCallback = new IAVFSCache.OnObjectSetCallback(){

                public void onObjectSetCallback(String string, boolean bl) {
                }
            };
        }
        catch (ClassNotFoundException classNotFoundException) {
            isAvfsCacheExist = false;
            ALog.w(TAG, "no alivfs sdk!", null, new Object[0]);
        }
    }
}

